/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.record;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.uniffle.client.record.Record;
import org.apache.uniffle.client.record.RecordCollection;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.records.RecordsWriter;

public class RecordBuffer<K, V>
implements RecordCollection<K, V, V> {
    private final int partitionId;
    private int size = 0;
    private List<Record<K, V>> records = new ArrayList<Record<K, V>>();

    public RecordBuffer(int partitionId) {
        this.partitionId = partitionId;
    }

    @Override
    public void addRecord(K key, V value) {
        Record record = Record.create(key, value);
        this.records.add(record);
        ++this.size;
    }

    public void addRecord(Record<K, V> record) {
        this.records.add(record);
        ++this.size;
    }

    public void addRecords(List<Record<K, V>> records) {
        this.records.addAll(records);
        this.size += records.size();
    }

    public List<Record<K, V>> getRecords() {
        return this.records;
    }

    public void sort(final Comparator comparator) {
        if (comparator == null) {
            throw new RssException("comparator is not set");
        }
        this.records.sort(new Comparator<Record>(){

            @Override
            public int compare(Record o1, Record o2) {
                return comparator.compare(o1.getKey(), o2.getKey());
            }
        });
    }

    @Override
    public void serialize(RecordsWriter writer) throws IOException {
        for (Record<K, V> record : this.records) {
            writer.append(record.getKey(), record.getValue());
        }
    }

    public void clear() {
        this.size = 0;
        this.records.clear();
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public int size() {
        return this.size;
    }

    public K getKey(int index) {
        return this.records.get(index).getKey();
    }

    public V getValue(int index) {
        return this.records.get(index).getValue();
    }

    public K getLastKey() {
        return this.records.get(this.records.size() - 1).getKey();
    }

    public K getFirstKey() {
        return this.records.get(0).getKey();
    }
}

