/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.function.Function;
import org.apache.uniffle.common.ShuffleBlockInfo;
import org.apache.uniffle.common.ShuffleServerInfo;

public class DeferredCompressedBlock
extends ShuffleBlockInfo {
    private final Function<DeferredCompressedBlock, DeferredCompressedBlock> rebuildFunction;
    private int estimatedCompressedSize;
    private boolean isInitialized = false;

    public DeferredCompressedBlock(int shuffleId, int partitionId, long blockId, List<ShuffleServerInfo> shuffleServerInfos, int uncompressLength, long freeMemory, long taskAttemptId, Function<Integer, List<ShuffleServerInfo>> partitionAssignmentRetrieveFunc, Function<DeferredCompressedBlock, DeferredCompressedBlock> rebuildFunction, int estimatedCompressedSize) {
        super(shuffleId, partitionId, blockId, shuffleServerInfos, uncompressLength, freeMemory, taskAttemptId, partitionAssignmentRetrieveFunc);
        this.rebuildFunction = rebuildFunction;
        this.estimatedCompressedSize = estimatedCompressedSize;
    }

    public void reset(byte[] data, int length, long crc) {
        this.length = length;
        this.crc = crc;
        this.data = Unpooled.wrappedBuffer((byte[])data);
    }

    private void initialize() {
        if (!this.isInitialized) {
            this.rebuildFunction.apply(this);
            this.isInitialized = true;
        }
    }

    public int getEstimatedLayoutSize() {
        return this.estimatedCompressedSize + 24 + 8;
    }

    @Override
    public int getLength() {
        this.initialize();
        return super.getLength();
    }

    @Override
    public int getSize() {
        this.initialize();
        return super.getSize();
    }

    @Override
    public long getCrc() {
        this.initialize();
        return super.getCrc();
    }

    @Override
    public ByteBuf getData() {
        this.initialize();
        return super.getData();
    }

    @Override
    public synchronized void copyDataTo(ByteBuf to) {
        this.initialize();
        super.copyDataTo(to);
    }
}

