/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.handle;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.spark.shuffle.handle.MutableShuffleHandleInfo;
import org.apache.spark.shuffle.handle.ShuffleHandleInfo;
import org.apache.spark.shuffle.handle.ShuffleHandleInfoBase;
import org.apache.spark.shuffle.handle.split.PartitionSplitInfo;
import org.apache.uniffle.client.PartitionDataReplicaRequirementTracking;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageAttemptShuffleHandleInfo
extends ShuffleHandleInfoBase {
    private static final long serialVersionUID = 0L;
    private static final Logger LOGGER = LoggerFactory.getLogger(StageAttemptShuffleHandleInfo.class);
    private ShuffleHandleInfo current;
    private LinkedList<ShuffleHandleInfo> historyHandles;

    public StageAttemptShuffleHandleInfo(int shuffleId, RemoteStorageInfo remoteStorage, ShuffleHandleInfo shuffleServerInfo) {
        super(shuffleId, remoteStorage);
        this.current = shuffleServerInfo;
        this.historyHandles = Lists.newLinkedList();
    }

    public StageAttemptShuffleHandleInfo(int shuffleId, RemoteStorageInfo remoteStorage, ShuffleHandleInfo currentShuffleServerInfo, LinkedList<ShuffleHandleInfo> historyHandles) {
        super(shuffleId, remoteStorage);
        this.current = currentShuffleServerInfo;
        this.historyHandles = historyHandles;
    }

    @Override
    public Set<ShuffleServerInfo> getServers() {
        return this.current.getServers();
    }

    @Override
    public Map<Integer, List<ShuffleServerInfo>> getAvailablePartitionServersForWriter(Map<Integer, List<ShuffleServerInfo>> exclusiveServers) {
        return this.current.getAvailablePartitionServersForWriter(exclusiveServers);
    }

    @Override
    public Map<Integer, List<ShuffleServerInfo>> getAllPartitionServersForReader() {
        return this.current.getAllPartitionServersForReader();
    }

    @Override
    public PartitionDataReplicaRequirementTracking createPartitionReplicaTracking() {
        return this.current.createPartitionReplicaTracking();
    }

    @Override
    public PartitionSplitInfo getPartitionSplitInfo(int partitionId) {
        return this.current.getPartitionSplitInfo(partitionId);
    }

    public void replaceCurrentShuffleHandleInfo(ShuffleHandleInfo shuffleHandleInfo) {
        this.historyHandles.add(this.current);
        this.current = shuffleHandleInfo;
    }

    public ShuffleHandleInfo getCurrent() {
        return this.current;
    }

    public LinkedList<ShuffleHandleInfo> getHistoryHandles() {
        return this.historyHandles;
    }

    public static RssProtos.StageAttemptShuffleHandleInfo toProto(StageAttemptShuffleHandleInfo handleInfo) {
        LinkedList<RssProtos.MutableShuffleHandleInfo> mutableShuffleHandleInfoLinkedList = Lists.newLinkedList();
        RssProtos.MutableShuffleHandleInfo currentMutableShuffleHandleInfo = MutableShuffleHandleInfo.toProto((MutableShuffleHandleInfo)handleInfo.getCurrent());
        for (ShuffleHandleInfo historyHandle : handleInfo.getHistoryHandles()) {
            mutableShuffleHandleInfoLinkedList.add(MutableShuffleHandleInfo.toProto((MutableShuffleHandleInfo)historyHandle));
        }
        RssProtos.StageAttemptShuffleHandleInfo handleProto = RssProtos.StageAttemptShuffleHandleInfo.newBuilder().setCurrentMutableShuffleHandleInfo(currentMutableShuffleHandleInfo).addAllHistoryMutableShuffleHandleInfo(mutableShuffleHandleInfoLinkedList).build();
        return handleProto;
    }

    public static StageAttemptShuffleHandleInfo fromProto(RssProtos.StageAttemptShuffleHandleInfo handleProto) {
        if (handleProto == null) {
            return null;
        }
        MutableShuffleHandleInfo mutableShuffleHandleInfo = MutableShuffleHandleInfo.fromProto(handleProto.getCurrentMutableShuffleHandleInfo());
        List<RssProtos.MutableShuffleHandleInfo> historyMutableShuffleHandleInfoList = handleProto.getHistoryMutableShuffleHandleInfoList();
        LinkedList<ShuffleHandleInfo> historyHandles = Lists.newLinkedList();
        for (RssProtos.MutableShuffleHandleInfo shuffleHandleInfo : historyMutableShuffleHandleInfoList) {
            historyHandles.add(MutableShuffleHandleInfo.fromProto(shuffleHandleInfo));
        }
        StageAttemptShuffleHandleInfo stageAttemptShuffleHandleInfo = new StageAttemptShuffleHandleInfo(mutableShuffleHandleInfo.shuffleId, mutableShuffleHandleInfo.remoteStorage, mutableShuffleHandleInfo, historyHandles);
        return stageAttemptShuffleHandleInfo;
    }
}

