/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.uniffle.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.uniffle.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadUtils.class);
    private static final ThreadMXBean THREAD_BEAN = ManagementFactory.getThreadMXBean();

    public static ThreadFactory getThreadFactory(String factoryName) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(factoryName + "-%d").build();
    }

    public static ThreadFactory getNettyThreadFactory(String threadPoolPrefix) {
        return new DefaultThreadFactory(threadPoolPrefix, true);
    }

    public static ScheduledExecutorService getDaemonSingleThreadScheduledExecutor(String factoryName) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, ThreadUtils.getThreadFactory(factoryName));
        executor.setRemoveOnCancelPolicy(true);
        return executor;
    }

    public static ExecutorService getDaemonFixedThreadPool(int threadNum, String factoryName) {
        return Executors.newFixedThreadPool(threadNum, ThreadUtils.getThreadFactory(factoryName));
    }

    public static ExecutorService getDaemonSingleThreadExecutor(String factoryName) {
        return Executors.newSingleThreadExecutor(ThreadUtils.getThreadFactory(factoryName));
    }

    public static ExecutorService getDaemonCachedThreadPool(String factoryName) {
        return Executors.newCachedThreadPool(ThreadUtils.getThreadFactory(factoryName));
    }

    public static void shutdownThreadPool(ExecutorService threadPool, int waitSec) throws InterruptedException {
        if (threadPool == null) {
            return;
        }
        threadPool.shutdown();
        if (!threadPool.awaitTermination(waitSec, TimeUnit.SECONDS)) {
            threadPool.shutdownNow();
            if (!threadPool.awaitTermination(waitSec, TimeUnit.SECONDS)) {
                LOGGER.warn("Thread pool don't stop gracefully.");
            }
        }
    }

    public static <T, R> List<R> executeTasks(ExecutorService executorService, Collection<T> items, Function<T, R> task, long timeoutMs, String taskMsg, String timeoutMsg, Function<Future<R>, R> futureHandler) {
        List callableList = items.stream().map(item -> () -> task.apply(item)).collect(Collectors.toList());
        try {
            List futures = executorService.invokeAll(callableList, timeoutMs, TimeUnit.MILLISECONDS);
            AtomicInteger cancelled = new AtomicInteger();
            List result = futures.stream().map(future -> {
                if (!future.isDone()) {
                    future.cancel(true);
                }
                if (future.isCancelled()) {
                    cancelled.incrementAndGet();
                }
                return future;
            }).map(futureHandler).collect(Collectors.toList());
            if (cancelled.get() > 0) {
                timeoutMsg = timeoutMsg != null ? " " + timeoutMsg : "";
                LOGGER.warn("Executing {} observed timeout of {}ms, {} out of {} tasks cancelled.{}", new Object[]{taskMsg, timeoutMs, cancelled.get(), items.size(), timeoutMsg});
            }
            return result;
        }
        catch (InterruptedException ie) {
            LOGGER.warn("Execute " + taskMsg + " is interrupted", (Throwable)ie);
            return Collections.emptyList();
        }
    }

    public static <T, R> List<R> executeTasks(ExecutorService executorService, Collection<T> items, Function<T, R> task, long timeoutMs, String taskMsg, Function<Future<R>, R> futureHandler) {
        return ThreadUtils.executeTasks(executorService, items, task, timeoutMs, taskMsg, null, futureHandler);
    }

    public static <T, R> List<R> executeTasks(ExecutorService executorService, Collection<T> items, Function<T, R> task, long timeoutMs, String taskMsg, String timeoutMsg) {
        return ThreadUtils.executeTasks(executorService, items, task, timeoutMs, taskMsg, timeoutMsg, future -> null);
    }

    public static <T, R> List<R> executeTasks(ExecutorService executorService, Collection<T> items, Function<T, R> task, long timeoutMs, String taskMsg) {
        return ThreadUtils.executeTasks(executorService, items, task, timeoutMs, taskMsg, (Future<R> future) -> null);
    }

    public static synchronized void printThreadInfo(StringBuilder builder, String title) {
        long[] threadIds;
        builder.append("Process Thread Dump: " + title + "\n");
        builder.append(THREAD_BEAN.getThreadCount() + " active threads\n");
        for (long id : threadIds = THREAD_BEAN.getAllThreadIds()) {
            ThreadInfo info = THREAD_BEAN.getThreadInfo(id, Integer.MAX_VALUE);
            if (info == null) continue;
            builder.append(info + "\n");
        }
    }
}

