/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.util;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uniffle.common.util.ByteUnit;
import org.apache.uniffle.shaded.com.google.common.collect.ImmutableMap;

public final class UnitConverter {
    private static final Map<String, ByteUnit> byteSuffixes = ImmutableMap.builder().put("b", ByteUnit.BYTE).put("k", ByteUnit.KiB).put("kb", ByteUnit.KiB).put("m", ByteUnit.MiB).put("mb", ByteUnit.MiB).put("g", ByteUnit.GiB).put("gb", ByteUnit.GiB).put("t", ByteUnit.TiB).put("tb", ByteUnit.TiB).put("p", ByteUnit.PiB).put("pb", ByteUnit.PiB).build();
    private static final Map<String, TimeUnit> timeSuffixes = ImmutableMap.builder().put("us", TimeUnit.MICROSECONDS).put("ms", TimeUnit.MILLISECONDS).put("s", TimeUnit.SECONDS).put("m", TimeUnit.MINUTES).put("min", TimeUnit.MINUTES).put("h", TimeUnit.HOURS).put("d", TimeUnit.DAYS).build();

    private UnitConverter() {
    }

    public static boolean isByteString(String str) {
        String strLower = str.toLowerCase();
        for (String key : byteSuffixes.keySet()) {
            if (!strLower.contains(key)) continue;
            return true;
        }
        return false;
    }

    public static long byteStringAs(String str, ByteUnit unit) {
        String lower = str.toLowerCase(Locale.ROOT).trim();
        try {
            Matcher m4 = Pattern.compile("([0-9]+)([a-z]+)?").matcher(lower);
            Matcher fractionMatcher = Pattern.compile("([0-9]+\\.[0-9]+)([a-z]+)?").matcher(lower);
            if (m4.matches()) {
                long val = Long.parseLong(m4.group(1));
                String suffix = m4.group(2);
                ByteUnit byteUnit = unit;
                if (suffix != null && (byteUnit = byteSuffixes.get(suffix)) == null) {
                    throw new NumberFormatException("Invalid suffix: \"" + suffix + "\"");
                }
                return unit.convertFrom(val, byteUnit);
            }
            if (fractionMatcher.matches()) {
                throw new NumberFormatException("Fractional values are not supported. Input was: " + fractionMatcher.group(1));
            }
            throw new NumberFormatException("Failed to parse byte string: " + str);
        }
        catch (NumberFormatException e) {
            String byteError = "Size must be specified as bytes (b), kibibytes (k), mebibytes (m), gibibytes (g), tebibytes (t), or pebibytes(p). E.g. 50b, 100k, or 250m.";
            throw new NumberFormatException(byteError + "\n" + e.getMessage());
        }
    }

    public static long byteStringAsBytes(String str) {
        return UnitConverter.byteStringAs(str, ByteUnit.BYTE);
    }

    public static long timeStringAs(String str, TimeUnit unit) {
        String lower = str.toLowerCase(Locale.ROOT).trim();
        try {
            Matcher m4 = Pattern.compile("(-?[0-9]+)([a-z]+)?").matcher(lower);
            if (!m4.matches()) {
                throw new NumberFormatException("Failed to parse time string: " + str);
            }
            long val = Long.parseLong(m4.group(1));
            String suffix = m4.group(2);
            TimeUnit timeUnit = unit;
            if (suffix != null && (timeUnit = timeSuffixes.get(suffix)) == null) {
                throw new NumberFormatException("Invalid suffix: \"" + suffix + "\"");
            }
            return unit.convert(val, timeUnit);
        }
        catch (NumberFormatException e) {
            String timeError = "Time must be specified as seconds (s), milliseconds (ms), microseconds (us), minutes (m or min), hour (h), or day (d). E.g. 50s, 100ms, or 250us.";
            throw new NumberFormatException(timeError + "\n" + e.getMessage());
        }
    }

    public static String formatSize(long bytes) {
        if (bytes < ByteUnit.KiB.getMultiplier()) {
            return bytes + "B";
        }
        if (bytes < ByteUnit.MiB.getMultiplier()) {
            return String.format("%.2fKiB", (double)bytes / (double)ByteUnit.KiB.getMultiplier());
        }
        if (bytes < ByteUnit.GiB.getMultiplier()) {
            return String.format("%.2fMiB", (double)bytes / (double)ByteUnit.MiB.getMultiplier());
        }
        if (bytes < ByteUnit.TiB.getMultiplier()) {
            return String.format("%.2fGiB", (double)bytes / (double)ByteUnit.GiB.getMultiplier());
        }
        if (bytes < ByteUnit.PiB.getMultiplier()) {
            return String.format("%.2fTiB", (double)bytes / (double)ByteUnit.TiB.getMultiplier());
        }
        return String.format("%.2fPiB", (double)bytes / (double)ByteUnit.PiB.getMultiplier());
    }
}

