/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shaded.io.prometheus.client.hotspot;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.uniffle.shaded.io.prometheus.client.Collector;
import org.apache.uniffle.shaded.io.prometheus.client.CounterMetricFamily;
import org.apache.uniffle.shaded.io.prometheus.client.GaugeMetricFamily;

public class ClassLoadingExports
extends Collector {
    private final ClassLoadingMXBean clBean;

    public ClassLoadingExports() {
        this(ManagementFactory.getClassLoadingMXBean());
    }

    public ClassLoadingExports(ClassLoadingMXBean clBean) {
        this.clBean = clBean;
    }

    void addClassLoadingMetrics(List<Collector.MetricFamilySamples> sampleFamilies) {
        sampleFamilies.add(new GaugeMetricFamily("jvm_classes_loaded", "The number of classes that are currently loaded in the JVM", this.clBean.getLoadedClassCount()));
        sampleFamilies.add(new CounterMetricFamily("jvm_classes_loaded_total", "The total number of classes that have been loaded since the JVM has started execution", this.clBean.getTotalLoadedClassCount()));
        sampleFamilies.add(new CounterMetricFamily("jvm_classes_unloaded_total", "The total number of classes that have been unloaded since the JVM has started execution", this.clBean.getUnloadedClassCount()));
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.addClassLoadingMetrics(mfs);
        return mfs;
    }
}

