/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.writer;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.spark.shuffle.RssSparkConfig;
import org.apache.spark.shuffle.writer.AddBlockEvent;
import org.apache.spark.shuffle.writer.DataPusher;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.impl.FailedBlockSendTracker;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverlappingCompressionDataPusher
extends DataPusher {
    private static final Logger LOG = LoggerFactory.getLogger(OverlappingCompressionDataPusher.class);
    private final ExecutorService compressionThreadPool;

    public OverlappingCompressionDataPusher(ShuffleWriteClient shuffleWriteClient, Map<String, Set<Long>> taskToSuccessBlockIds, Map<String, FailedBlockSendTracker> taskToFailedBlockSendTracker, Set<String> failedTaskIds, int threadPoolSize, int threadKeepAliveTime, int compressionThreads) {
        super(shuffleWriteClient, taskToSuccessBlockIds, taskToFailedBlockSendTracker, failedTaskIds, threadPoolSize, threadKeepAliveTime);
        if (compressionThreads <= 0) {
            throw new RssException("Invalid rss configuration of " + RssSparkConfig.RSS_WRITE_OVERLAPPING_COMPRESSION_THREADS_PER_VCORE.key() + ": " + compressionThreads);
        }
        this.compressionThreadPool = Executors.newFixedThreadPool(compressionThreads, ThreadUtils.getThreadFactory("compression-thread"));
    }

    @Override
    public CompletableFuture<Long> send(AddBlockEvent event) {
        return CompletableFuture.supplyAsync(() -> {
            event.getShuffleDataInfoList().forEach(shuffleDataInfo -> shuffleDataInfo.getData());
            return event;
        }, this.compressionThreadPool).thenCompose(processedEvent -> super.send((AddBlockEvent)processedEvent));
    }
}

