/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.record.reader;

import java.io.IOException;
import org.apache.uniffle.client.record.RecordBuffer;
import org.apache.uniffle.common.merger.Segment;

public class BufferedSegment<K, V>
extends Segment {
    private RecordBuffer<K, V> recordBuffer;
    private int index = -1;

    public BufferedSegment(RecordBuffer recordBuffer) {
        super(recordBuffer.getPartitionId());
        this.recordBuffer = recordBuffer;
    }

    @Override
    public boolean next() throws IOException {
        boolean hasNext;
        boolean bl = hasNext = this.index < this.recordBuffer.size() - 1;
        if (hasNext) {
            ++this.index;
        }
        return hasNext;
    }

    @Override
    public Object getCurrentKey() {
        return this.recordBuffer.getKey(this.index);
    }

    @Override
    public Object getCurrentValue() {
        return this.recordBuffer.getValue(this.index);
    }

    @Override
    public void close() throws IOException {
        if (this.recordBuffer != null) {
            this.recordBuffer.clear();
            this.recordBuffer = null;
        }
    }

    @Override
    public long getSize() {
        return -1L;
    }
}

