/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shaded.org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.uniffle.shaded.org.eclipse.jetty.util.AbstractTrie;
import org.apache.uniffle.shaded.org.eclipse.jetty.util.StringUtil;

public class ArrayTernaryTrie<V>
extends AbstractTrie<V> {
    private static int LO = 1;
    private static int EQ = 2;
    private static int HI = 3;
    private static final int ROW_SIZE = 4;
    private final char[] _tree;
    private final String[] _key;
    private final V[] _value;
    private char _rows;

    public ArrayTernaryTrie() {
        this(128);
    }

    public ArrayTernaryTrie(boolean insensitive) {
        this(insensitive, 128);
    }

    public ArrayTernaryTrie(int capacity) {
        this(true, capacity);
    }

    public ArrayTernaryTrie(boolean insensitive, int capacity) {
        super(insensitive);
        this._value = new Object[capacity];
        this._tree = new char[capacity * 4];
        this._key = new String[capacity];
    }

    public ArrayTernaryTrie(ArrayTernaryTrie<V> trie, double factor) {
        super(trie.isCaseInsensitive());
        int capacity = (int)((double)trie._value.length * factor);
        this._rows = trie._rows;
        this._value = Arrays.copyOf(trie._value, capacity);
        this._tree = Arrays.copyOf(trie._tree, capacity * 4);
        this._key = Arrays.copyOf(trie._key, capacity);
    }

    @Override
    public void clear() {
        this._rows = '\u0000';
        Arrays.fill(this._value, null);
        Arrays.fill(this._tree, '\u0000');
        Arrays.fill(this._key, null);
    }

    @Override
    public boolean put(String s2, V v) {
        char t2 = '\u0000';
        int limit = s2.length();
        int last = 0;
        for (int k = 0; k < limit; ++k) {
            int diff;
            char c = s2.charAt(k);
            if (this.isCaseInsensitive() && c < '\u0080') {
                c = StringUtil.lowercases[c];
            }
            do {
                char n;
                int row = 4 * t2;
                if (t2 == this._rows) {
                    this._rows = (char)(this._rows + '\u0001');
                    if (this._rows >= this._key.length) {
                        this._rows = (char)(this._rows - '\u0001');
                        return false;
                    }
                    this._tree[row] = c;
                }
                if ((diff = (n = this._tree[row]) - c) == 0) {
                    last = row + EQ;
                    t2 = this._tree[last];
                } else if (diff < 0) {
                    last = row + LO;
                    t2 = this._tree[last];
                } else {
                    last = row + HI;
                    t2 = this._tree[last];
                }
                if (t2 != '\u0000') continue;
                t2 = this._rows;
                this._tree[last] = t2;
            } while (diff != 0);
        }
        if (t2 == this._rows) {
            this._rows = (char)(this._rows + '\u0001');
            if (this._rows >= this._key.length) {
                this._rows = (char)(this._rows - '\u0001');
                return false;
            }
        }
        this._key[t2] = v == null ? null : s2;
        this._value[t2] = v;
        return true;
    }

    @Override
    public V get(String s2, int offset, int len) {
        int t2 = 0;
        int i = 0;
        block0: while (i < len) {
            int diff;
            int row;
            char c = s2.charAt(offset + i++);
            if (this.isCaseInsensitive() && c < '\u0080') {
                c = StringUtil.lowercases[c];
            }
            do {
                char n;
                if ((diff = (n = this._tree[row = 4 * t2]) - c) != 0) continue;
                t2 = this._tree[row + EQ];
                if (t2 != 0) continue block0;
                return null;
            } while ((t2 = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != 0);
            return null;
        }
        return this._value[t2];
    }

    @Override
    public V get(ByteBuffer b, int offset, int len) {
        int t2 = 0;
        offset += b.position();
        int i = 0;
        block0: while (i < len) {
            int diff;
            int row;
            byte c = (byte)(b.get(offset + i++) & 0x7F);
            if (this.isCaseInsensitive()) {
                c = (byte)StringUtil.lowercases[c];
            }
            do {
                char n;
                if ((diff = (n = this._tree[row = 4 * t2]) - c) != 0) continue;
                t2 = this._tree[row + EQ];
                if (t2 != 0) continue block0;
                return null;
            } while ((t2 = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != 0);
            return null;
        }
        return this._value[t2];
    }

    @Override
    public V getBest(String s2) {
        return this.getBest(0, s2, 0, s2.length());
    }

    @Override
    public V getBest(String s2, int offset, int length) {
        return this.getBest(0, s2, offset, length);
    }

    private V getBest(int t2, String s2, int offset, int len) {
        int node = t2;
        int end = offset + len;
        block0: while (offset < end) {
            int diff;
            int row;
            char c = s2.charAt(offset++);
            --len;
            if (this.isCaseInsensitive() && c < '\u0080') {
                c = StringUtil.lowercases[c];
            }
            do {
                char n;
                if ((diff = (n = this._tree[row = 4 * t2]) - c) != 0) continue;
                t2 = this._tree[row + EQ];
                if (t2 == 0) break block0;
                if (this._key[t2] == null) continue block0;
                node = t2;
                V better = this.getBest(t2, s2, offset, len);
                if (better == null) continue block0;
                return better;
            } while ((t2 = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != 0);
            break;
        }
        return this._value[node];
    }

    @Override
    public V getBest(ByteBuffer b, int offset, int len) {
        if (b.hasArray()) {
            return this.getBest(0, b.array(), b.arrayOffset() + b.position() + offset, len);
        }
        return this.getBest(0, b, offset, len);
    }

    private V getBest(int t2, byte[] b, int offset, int len) {
        int node = t2;
        int end = offset + len;
        block0: while (offset < end) {
            int diff;
            int row;
            byte c = (byte)(b[offset++] & 0x7F);
            --len;
            if (this.isCaseInsensitive()) {
                c = (byte)StringUtil.lowercases[c];
            }
            do {
                char n;
                if ((diff = (n = this._tree[row = 4 * t2]) - c) != 0) continue;
                t2 = this._tree[row + EQ];
                if (t2 == 0) break block0;
                if (this._key[t2] == null) continue block0;
                node = t2;
                V better = this.getBest(t2, b, offset, len);
                if (better == null) continue block0;
                return better;
            } while ((t2 = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != 0);
            break;
        }
        return this._value[node];
    }

    private V getBest(int t2, ByteBuffer b, int offset, int len) {
        int node = t2;
        int o = offset + b.position();
        block0: for (int i = 0; i < len; ++i) {
            int diff;
            int row;
            byte c = (byte)(b.get(o + i) & 0x7F);
            if (this.isCaseInsensitive()) {
                c = (byte)StringUtil.lowercases[c];
            }
            do {
                char n;
                if ((diff = (n = this._tree[row = 4 * t2]) - c) != 0) continue;
                t2 = this._tree[row + EQ];
                if (t2 == 0) break block0;
                if (this._key[t2] == null) continue block0;
                node = t2;
                V best = this.getBest(t2, b, offset + i + 1, len - i - 1);
                if (best == null) continue block0;
                return best;
            } while ((t2 = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != 0);
            break;
        }
        return this._value[node];
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int r = 0; r <= this._rows; ++r) {
            if (this._key[r] == null || this._value[r] == null) continue;
            buf.append(',');
            buf.append(this._key[r]);
            buf.append('=');
            buf.append(this._value[r].toString());
        }
        if (buf.length() == 0) {
            return "{}";
        }
        buf.setCharAt(0, '{');
        buf.append('}');
        return buf.toString();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        for (int r = 0; r <= this._rows; ++r) {
            if (this._key[r] == null || this._value[r] == null) continue;
            keys.add(this._key[r]);
        }
        return keys;
    }

    @Override
    public boolean isFull() {
        return this._rows + '\u0001' == this._key.length;
    }

    public static int hilo(int diff) {
        return 1 + (diff | Integer.MAX_VALUE) / 0x3FFFFFFF;
    }

    public void dump() {
        for (int r = 0; r < this._rows; ++r) {
            char c = this._tree[r * 4 + 0];
            System.err.printf("%4d [%s,%d,%d,%d] '%s':%s%n", r, c < ' ' || c > '\u007f' ? "" + c : "'" + c + "'", (int)this._tree[r * 4 + LO], (int)this._tree[r * 4 + EQ], (int)this._tree[r * 4 + HI], this._key[r], this._value[r]);
        }
    }
}

