/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shaded.org.roaringbitmap;

import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.uniffle.shaded.org.roaringbitmap.AppendableStorage;
import org.apache.uniffle.shaded.org.roaringbitmap.BitmapContainer;
import org.apache.uniffle.shaded.org.roaringbitmap.BitmapDataProvider;
import org.apache.uniffle.shaded.org.roaringbitmap.Container;
import org.apache.uniffle.shaded.org.roaringbitmap.RoaringBitmapWriter;
import org.apache.uniffle.shaded.org.roaringbitmap.Util;

public class ConstantMemoryContainerAppender<T extends BitmapDataProvider & AppendableStorage<Container>>
implements RoaringBitmapWriter<T> {
    private final boolean doPartialSort;
    private final boolean runCompress;
    private static final int WORD_COUNT = 1024;
    private final long[] bitmap;
    private final Supplier<T> newUnderlying;
    private T underlying;
    private boolean dirty = false;
    private int currentKey;

    ConstantMemoryContainerAppender(boolean doPartialSort, boolean runCompress, Supplier<T> newUnderlying) {
        this.newUnderlying = newUnderlying;
        this.underlying = (BitmapDataProvider)newUnderlying.get();
        this.doPartialSort = doPartialSort;
        this.runCompress = runCompress;
        this.bitmap = new long[1024];
    }

    @Override
    public T getUnderlying() {
        return this.underlying;
    }

    @Override
    public void add(int value) {
        char key = Util.highbits(value);
        if (key != this.currentKey) {
            if (key < this.currentKey) {
                this.underlying.add(value);
                return;
            }
            this.appendToUnderlying();
            this.currentKey = key;
        }
        char low = Util.lowbits(value);
        int n = low >>> 6;
        this.bitmap[n] = this.bitmap[n] | 1L << low;
        this.dirty = true;
    }

    @Override
    public void addMany(int ... values) {
        if (this.doPartialSort) {
            Util.partialRadixSort(values);
        }
        for (int value : values) {
            this.add(value);
        }
    }

    @Override
    public void add(long min2, long max) {
        this.appendToUnderlying();
        this.underlying.add(min2, max);
        int mark = (int)((max >>> 16) + 1L);
        if (this.currentKey < mark) {
            this.currentKey = mark;
        }
    }

    @Override
    public void flush() {
        this.currentKey += this.appendToUnderlying();
    }

    @Override
    public void reset() {
        this.currentKey = 0;
        this.underlying = (BitmapDataProvider)this.newUnderlying.get();
        this.dirty = false;
    }

    private Container chooseBestContainer() {
        Container container = new BitmapContainer(this.bitmap, -1).repairAfterLazy();
        if (this.runCompress) {
            container = container.runOptimize();
        }
        return container instanceof BitmapContainer ? container.clone() : container;
    }

    private int appendToUnderlying() {
        if (this.dirty) {
            assert (this.currentKey <= 65535);
            ((AppendableStorage)this.underlying).append((char)this.currentKey, this.chooseBestContainer());
            Arrays.fill(this.bitmap, 0L);
            this.dirty = false;
            return 1;
        }
        return 0;
    }
}

