/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shuffle;

import java.util.List;
import java.util.Map;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.shaded.org.apache.commons.collections4.CollectionUtils;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockIdManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockIdManager.class);
    private Map<Integer, Map<Integer, Roaring64NavigableMap>> blockIds = JavaUtils.newConcurrentMap();

    public void add(int shuffleId, int partitionId, List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Map partitionedBlockIds = this.blockIds.computeIfAbsent(shuffleId, k -> JavaUtils.newConcurrentMap());
        partitionedBlockIds.compute(partitionId, (id, bitmap) -> {
            Roaring64NavigableMap store = bitmap == null ? Roaring64NavigableMap.bitmapOf(new long[0]) : bitmap;
            ids.stream().forEach(x -> store.add((long)x));
            return store;
        });
    }

    public Roaring64NavigableMap get(int shuffleId, int partitionId) {
        Map<Integer, Roaring64NavigableMap> partitionedBlockIds = this.blockIds.get(shuffleId);
        if (partitionedBlockIds == null || partitionedBlockIds.isEmpty()) {
            return Roaring64NavigableMap.bitmapOf(new long[0]);
        }
        Roaring64NavigableMap idMap = partitionedBlockIds.get(partitionId);
        if (idMap == null || idMap.isEmpty()) {
            return Roaring64NavigableMap.bitmapOf(new long[0]);
        }
        return RssUtils.cloneBitMap(idMap);
    }

    public boolean remove(int shuffleId) {
        this.blockIds.remove(shuffleId);
        return true;
    }
}

