/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShuffleIndexResult;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.netty.buffer.MultiFileSegmentManagedBuffer;
import org.apache.uniffle.storage.handler.api.ServerReadHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeLocalFileServerReadHandler
implements ServerReadHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeLocalFileServerReadHandler.class);
    private final List<ServerReadHandler> handlers;

    public CompositeLocalFileServerReadHandler(List<ServerReadHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public ShuffleDataResult getShuffleData(long offset, int length) {
        return null;
    }

    @Override
    public ShuffleIndexResult getShuffleIndex() {
        if (this.handlers.size() == 0) {
            return null;
        }
        int[] storageIds = new int[this.handlers.size()];
        ArrayList<ManagedBuffer> managedBuffers = new ArrayList<ManagedBuffer>(this.handlers.size());
        String dataFileName = "";
        long length = 0L;
        for (int i = 0; i < this.handlers.size(); ++i) {
            ServerReadHandler handler = this.handlers.get(i);
            storageIds[i] = handler.getStorageId();
            ShuffleIndexResult result = handler.getShuffleIndex();
            length += result.getDataFileLen();
            managedBuffers.add(result.getManagedBuffer());
            if (i != 0) continue;
            dataFileName = result.getDataFileName();
        }
        MultiFileSegmentManagedBuffer mergedManagedBuffer = new MultiFileSegmentManagedBuffer(managedBuffers);
        return new ShuffleIndexResult((ManagedBuffer)mergedManagedBuffer, length, dataFileName, storageIds);
    }

    @Override
    public int getStorageId() {
        return 0;
    }
}

