/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.impl;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.FetchedInput;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputAllocator;
import org.apache.tez.runtime.library.common.shuffle.FetcherCallback;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.RssTezBypassWriter;
import org.apache.uniffle.client.api.ShuffleReadClient;
import org.apache.uniffle.client.response.CompressedShuffleBlock;
import org.apache.uniffle.common.compression.Codec;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.ByteBufferUtils;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssTezFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(RssTezFetcher.class);
    private final FetcherCallback fetcherCallback;
    private final FetchedInputAllocator inputManager;
    private long copyBlockCount = 0L;
    private volatile boolean stopped = false;
    private final ShuffleReadClient shuffleReadClient;
    Map<Integer, Roaring64NavigableMap> rssSuccessBlockIdBitmapMap;
    private int partitionId;
    private long readTime = 0L;
    private long decompressTime = 0L;
    private long serializeTime = 0L;
    private long waitTime = 0L;
    private long copyTime = 0L;
    private long unCompressionLength = 0L;
    private static int uniqueMapId = 0;
    private boolean hasPendingData = false;
    private long startWait;
    private int waitCount = 0;
    private byte[] uncompressedData = null;
    private Optional<Codec> codec;

    RssTezFetcher(FetcherCallback fetcherCallback, FetchedInputAllocator inputManager, ShuffleReadClient shuffleReadClient, Map<Integer, Roaring64NavigableMap> rssSuccessBlockIdBitmapMap, int partitionId, RssConf rssConf) {
        this.fetcherCallback = fetcherCallback;
        this.inputManager = inputManager;
        this.shuffleReadClient = shuffleReadClient;
        this.rssSuccessBlockIdBitmapMap = rssSuccessBlockIdBitmapMap;
        this.partitionId = partitionId;
        this.codec = Codec.newInstance(rssConf);
    }

    public void fetchAllRssBlocks() throws IOException {
        while (!this.stopped) {
            try {
                this.copyFromRssServer();
            }
            catch (Exception e) {
                LOG.error("Failed to fetchAllRssBlocks.", (Throwable)e);
                throw e;
            }
        }
    }

    @VisibleForTesting
    public void copyFromRssServer() throws IOException {
        CompressedShuffleBlock compressedBlock = null;
        Buffer compressedData = null;
        long blockStartFetch = 0L;
        if (!this.hasPendingData) {
            long startFetch = System.currentTimeMillis();
            blockStartFetch = System.currentTimeMillis();
            compressedBlock = (CompressedShuffleBlock)this.shuffleReadClient.readShuffleBlockData();
            if (compressedBlock != null) {
                compressedData = compressedBlock.getByteBuffer();
            }
            long fetchDuration = System.currentTimeMillis() - startFetch;
            this.readTime += fetchDuration;
        }
        if (!this.hasPendingData && compressedData != null) {
            if (this.codec.isPresent()) {
                long startDecompress = System.currentTimeMillis();
                int uncompressedLen = compressedBlock.getUncompressLength();
                ByteBuffer decompressedBuffer = ByteBuffer.allocate(uncompressedLen);
                this.codec.get().decompress((ByteBuffer)compressedData, uncompressedLen, decompressedBuffer, 0);
                this.uncompressedData = decompressedBuffer.array();
                this.unCompressionLength += (long)compressedBlock.getUncompressLength();
                long decompressDuration = System.currentTimeMillis() - startDecompress;
                this.decompressTime += decompressDuration;
            } else {
                this.uncompressedData = ByteBufferUtils.bufferToArray(compressedData);
                this.unCompressionLength += (long)this.uncompressedData.length;
            }
        }
        if (this.uncompressedData != null) {
            int compressedDataLength;
            long startSerialization = System.currentTimeMillis();
            int n = compressedDataLength = compressedData != null ? compressedData.capacity() : 0;
            if (this.issueMapOutputMerge(compressedDataLength, blockStartFetch)) {
                long serializationDuration = System.currentTimeMillis() - startSerialization;
                this.serializeTime += serializationDuration;
                if (this.hasPendingData) {
                    this.waitTime += System.currentTimeMillis() - this.startWait;
                }
            } else {
                LOG.info("UncompressedData is null");
                ++this.waitCount;
                this.startWait = System.currentTimeMillis();
                return;
            }
            this.hasPendingData = false;
            this.uncompressedData = null;
            ++this.copyBlockCount;
            this.copyTime = this.readTime + this.decompressTime + this.serializeTime + this.waitTime;
        } else {
            LOG.info("UncompressedData is null");
            this.shuffleReadClient.close();
            this.shuffleReadClient.checkProcessedBlockIds();
            this.shuffleReadClient.logStatics();
            LOG.info("Reduce task partition:" + this.partitionId + " read block cnt: " + this.copyBlockCount + " cost " + this.readTime + " ms to fetch and " + this.decompressTime + " ms to decompress with unCompressionLength[" + this.unCompressionLength + "] and " + this.serializeTime + " ms to serialize and " + this.waitTime + " ms to wait resource, total copy time: " + this.copyTime);
            LOG.info("Stop fetcher");
            this.stopFetch();
        }
    }

    private boolean issueMapOutputMerge(int compressedLength, long blockStartFetch) throws IOException {
        InputAttemptIdentifier uniqueInputAttemptIdentifier = this.getNextUniqueInputAttemptIdentifier();
        FetchedInput fetchedInput = null;
        fetchedInput = this.inputManager.allocate((long)this.uncompressedData.length, (long)compressedLength, uniqueInputAttemptIdentifier);
        try {
            RssTezBypassWriter.write(fetchedInput, this.uncompressedData);
            this.fetcherCallback.fetchSucceeded(null, uniqueInputAttemptIdentifier, fetchedInput, (long)compressedLength, this.unCompressionLength, System.currentTimeMillis() - blockStartFetch);
        }
        catch (Throwable t) {
            LOG.error("Failed to write fetchedInput.", t);
            throw new RssException("Partition: " + this.partitionId + " cannot write block to " + fetchedInput.getClass().getSimpleName() + " due to: " + t.getClass().getName());
        }
        return true;
    }

    private InputAttemptIdentifier getNextUniqueInputAttemptIdentifier() {
        return new InputAttemptIdentifier(uniqueMapId++, 0);
    }

    private void stopFetch() {
        this.stopped = true;
    }

    @VisibleForTesting
    public int getRetryCount() {
        return this.waitCount;
    }
}

