/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.netty.protocol.Decoders;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.RequestMessage;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.apache.uniffle.shaded.com.google.common.collect.Maps;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;

public class SendShuffleDataRequestV1
extends RequestMessage {
    private String appId;
    private int shuffleId;
    private int stageAttemptNumber;
    private long requireId;
    private Map<Integer, List<ShufflePartitionedBlock>> partitionToBlocks;
    private long timestamp;
    private int decodedLength;

    public SendShuffleDataRequestV1(long requestId) {
        super(requestId);
    }

    @Override
    public Message.Type type() {
        return Message.Type.SEND_SHUFFLE_DATA_REQUEST;
    }

    @Override
    public int encodedLength() {
        return -1;
    }

    @Override
    public void encode(ByteBuf buf) {
    }

    public void decodeShuffleData(ByteBuf byteBuf) {
        int startIndex = byteBuf.readerIndex();
        this.appId = ByteBufUtils.readLengthAndString(byteBuf);
        this.shuffleId = byteBuf.readInt();
        this.requireId = byteBuf.readLong();
        this.partitionToBlocks = this.decodePartitionData(byteBuf);
        this.timestamp = byteBuf.readLong();
        int endIndex = byteBuf.readerIndex();
        this.decodedLength += endIndex - startIndex;
    }

    public int getDecodedLength() {
        return this.decodedLength;
    }

    private Map<Integer, List<ShufflePartitionedBlock>> decodePartitionData(ByteBuf byteBuf) {
        HashMap<Integer, List<ShufflePartitionedBlock>> partitionToBlocks = Maps.newHashMap();
        int lengthOfPartitionData = byteBuf.readInt();
        for (int i = 0; i < lengthOfPartitionData; ++i) {
            int partitionId = byteBuf.readInt();
            int lengthOfShuffleBlocks = byteBuf.readInt();
            ArrayList<ShufflePartitionedBlock> shufflePartitionedBlocks = Lists.newArrayList();
            for (int j = 0; j < lengthOfShuffleBlocks; ++j) {
                try {
                    shufflePartitionedBlocks.add(Decoders.decodeShufflePartitionedBlockV1(byteBuf));
                    continue;
                }
                catch (Throwable t) {
                    shufflePartitionedBlocks.forEach(sbi -> sbi.getData().release());
                    if (!partitionToBlocks.isEmpty()) {
                        partitionToBlocks.forEach((integer, shuffleBlockInfos) -> shuffleBlockInfos.forEach(sbi -> sbi.getData().release()));
                    }
                    throw t;
                }
            }
            partitionToBlocks.put(partitionId, shufflePartitionedBlocks);
        }
        return partitionToBlocks;
    }

    public static SendShuffleDataRequestV1 decode(ByteBuf byteBuf) {
        int startIndex = byteBuf.readerIndex();
        long requestId = byteBuf.readLong();
        SendShuffleDataRequestV1 req = new SendShuffleDataRequestV1(requestId);
        req.decodeShuffleData(byteBuf);
        int endIndex = byteBuf.readerIndex();
        req.setDecodedLength(endIndex - startIndex);
        return req;
    }

    public String getAppId() {
        return this.appId;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public long getRequireId() {
        return this.requireId;
    }

    public void setRequireId(long requireId) {
        this.requireId = requireId;
    }

    public Map<Integer, List<ShufflePartitionedBlock>> getPartitionToBlocks() {
        return this.partitionToBlocks;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getStageAttemptNumber() {
        return this.stageAttemptNumber;
    }

    @Override
    public String getOperationType() {
        return "sendShuffleDataV1";
    }

    public void setDecodedLength(int decodedLength) {
        this.decodedLength = decodedLength;
    }
}

