/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer.writable;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.uniffle.common.serializer.DeserializationStream;
import org.apache.uniffle.common.serializer.SerInputStream;
import org.apache.uniffle.common.serializer.writable.WritableSerializerInstance;
import org.apache.uniffle.common.util.NettyUtils;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;
import org.apache.uniffle.shaded.io.netty.buffer.UnpooledByteBufAllocator;

public class BufferedRawWritableDeserializationStream<K extends Writable, V extends Writable>
extends DeserializationStream<ByteBuf, ByteBuf> {
    private static final int INIT_BUFFER_SIZE = 256;
    private static final int EOF_MARKER = -1;
    private SerInputStream inputStream;
    private DataInputStream dataIn;
    private ByteBuf currentKeyBuffer;
    private ByteBuf currentValueBuffer;

    public BufferedRawWritableDeserializationStream(WritableSerializerInstance instance, SerInputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public void init() {
        this.inputStream.init();
        this.dataIn = new DataInputStream(this.inputStream);
        UnpooledByteBufAllocator allocator = NettyUtils.getSharedUnpooledByteBufAllocator(true);
        this.currentKeyBuffer = allocator.heapBuffer(256);
        this.currentValueBuffer = allocator.heapBuffer(256);
    }

    @Override
    public boolean nextRecord() throws IOException {
        if (this.inputStream.available() <= 0) {
            return false;
        }
        int currentKeyLength = WritableUtils.readVInt((DataInput)this.dataIn);
        int currentValueLength = WritableUtils.readVInt((DataInput)this.dataIn);
        if (currentKeyLength == -1 && currentValueLength == -1) {
            return false;
        }
        this.currentKeyBuffer.clear();
        this.inputStream.transferTo(this.currentKeyBuffer, currentKeyLength);
        this.currentValueBuffer.clear();
        this.inputStream.transferTo(this.currentValueBuffer, currentValueLength);
        return true;
    }

    @Override
    public ByteBuf getCurrentKey() {
        return this.currentKeyBuffer;
    }

    @Override
    public ByteBuf getCurrentValue() {
        return this.currentValueBuffer;
    }

    @Override
    public void close() throws IOException {
        if (this.currentKeyBuffer != null) {
            this.currentKeyBuffer.release();
            this.currentKeyBuffer = null;
        }
        if (this.currentValueBuffer != null) {
            this.currentValueBuffer.release();
            this.currentValueBuffer = null;
        }
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        if (this.dataIn != null) {
            this.dataIn.close();
            this.dataIn = null;
        }
    }
}

