/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import org.apache.uniffle.common.exception.ExceedHugePartitionHardLimitException;
import org.apache.uniffle.server.ShuffleTaskInfo;
import org.apache.uniffle.server.ShuffleTaskManager;
import org.apache.uniffle.server.buffer.ShuffleBuffer;
import org.apache.uniffle.server.buffer.ShuffleBufferManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HugePartitionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HugePartitionUtils.class);

    public static boolean isHugePartition(ShuffleBufferManager shuffleBufferManager, long usedPartitionDataSize) {
        return usedPartitionDataSize > shuffleBufferManager.getHugePartitionSizeThreshold();
    }

    public static boolean isHugePartition(ShuffleTaskManager shuffleTaskManager, String appId, int shuffleId, int partitionId) {
        if (shuffleTaskManager == null) {
            return false;
        }
        ShuffleTaskInfo taskInfo = shuffleTaskManager.getShuffleTaskInfo(appId);
        return taskInfo != null && taskInfo.isHugePartition(shuffleId, partitionId);
    }

    public static boolean hasPartitionExceededHugeHardLimit(ShuffleBufferManager shuffleBufferManager, long usedPartitionDataSize) {
        return usedPartitionDataSize > shuffleBufferManager.getHugePartitionSizeHardLimit();
    }

    public static void markHugePartition(ShuffleBufferManager shuffleBufferManager, ShuffleTaskInfo shuffleTaskInfo, int shuffleId, int partitionId, long partitionSize) {
        if (HugePartitionUtils.isHugePartition(shuffleBufferManager, partitionSize)) {
            shuffleTaskInfo.markHugePartition(shuffleId, partitionId);
        }
    }

    public static void checkExceedPartitionHardLimit(String operation, ShuffleBufferManager shuffleBufferManager, long partitionSize, long increaseSize) {
        if (HugePartitionUtils.hasPartitionExceededHugeHardLimit(shuffleBufferManager, partitionSize)) {
            throw new ExceedHugePartitionHardLimitException(operation + ": Current partition size: " + partitionSize + " exceeded the huge hard limit size: " + shuffleBufferManager.getHugePartitionSizeHardLimit() + " if cache this shuffle data with size: " + increaseSize);
        }
    }

    public static boolean limitHugePartition(ShuffleBufferManager shuffleBufferManager, String appId, int shuffleId, int partitionId, long usedPartitionDataSize) {
        ShuffleBuffer buffer;
        long memoryUsed;
        if (usedPartitionDataSize > shuffleBufferManager.getHugePartitionSizeThreshold() && (memoryUsed = (buffer = shuffleBufferManager.getShuffleBufferEntry(appId, shuffleId, partitionId).getValue()).getInFlushSize() + buffer.getEncodedLength()) > shuffleBufferManager.getHugePartitionMemoryLimitSize()) {
            LOG.warn("AppId: {}, shuffleId: {}, partitionId: {}, memory used: {}, huge partition triggered memory limitation.", new Object[]{appId, shuffleId, partitionId, memoryUsed});
            return true;
        }
        return false;
    }

    public static boolean hasExceedPartitionSplitLimit(ShuffleBufferManager shuffleBufferManager, long usedPartitionDataSize) {
        return usedPartitionDataSize > shuffleBufferManager.getHugePartitionSplitLimit();
    }
}

