/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.uniffle.common.PartitionInfo;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.UnitConverter;
import org.apache.uniffle.server.ShuffleDetailInfo;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.ShuffleSpecification;
import org.apache.uniffle.server.block.ShuffleBlockIdManager;
import org.apache.uniffle.server.block.ShuffleBlockIdManagerFactory;
import org.apache.uniffle.shaded.guava.collect.Sets;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleTaskInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShuffleTaskInfo.class);
    private final String appId;
    private Long currentTimes;
    private Map<Integer, AtomicInteger> commitCounts;
    private Map<Integer, Object> commitLocks;
    private Map<Integer, Roaring64NavigableMap> cachedBlockIds;
    private AtomicReference<String> user;
    private final AtomicLong totalDataSize = new AtomicLong(0L);
    private final AtomicLong inMemoryDataSize = new AtomicLong(0L);
    private final AtomicLong onLocalFileNum = new AtomicLong(0L);
    private final AtomicLong onLocalFileDataSize = new AtomicLong(0L);
    private final AtomicLong onHadoopFileNum = new AtomicLong(0L);
    private final AtomicLong onHadoopDataSize = new AtomicLong(0L);
    private final PartitionInfo maxSizePartitionInfo = new PartitionInfo();
    private Map<Integer, Map<Integer, Long>> partitionDataSizes;
    private final Map<Integer, Set<Integer>> hugePartitionTags;
    private final AtomicBoolean existHugePartition;
    private final AtomicReference<ShuffleSpecification> specification;
    private final Map<Integer, Map<Integer, AtomicLong>> partitionBlockCounters;
    private final Map<Integer, ShuffleDetailInfo> shuffleDetailInfos;
    private final Map<Integer, Integer> latestStageAttemptNumbers;
    private Map<String, String> properties;
    private ShuffleBlockIdManager shuffleBlockIdManager;

    public ShuffleTaskInfo(String appId) {
        this.appId = appId;
        this.currentTimes = System.currentTimeMillis();
        this.commitCounts = JavaUtils.newConcurrentMap();
        this.commitLocks = JavaUtils.newConcurrentMap();
        this.cachedBlockIds = JavaUtils.newConcurrentMap();
        this.user = new AtomicReference();
        this.partitionDataSizes = JavaUtils.newConcurrentMap();
        this.hugePartitionTags = JavaUtils.newConcurrentMap();
        this.existHugePartition = new AtomicBoolean(false);
        this.specification = new AtomicReference();
        this.partitionBlockCounters = JavaUtils.newConcurrentMap();
        this.latestStageAttemptNumbers = JavaUtils.newConcurrentMap();
        this.shuffleDetailInfos = JavaUtils.newConcurrentMap();
    }

    public Long getCurrentTimes() {
        return this.currentTimes;
    }

    public void setCurrentTimes(Long currentTimes) {
        this.currentTimes = currentTimes;
    }

    public Map<Integer, AtomicInteger> getCommitCounts() {
        return this.commitCounts;
    }

    public Map<Integer, Object> getCommitLocks() {
        return this.commitLocks;
    }

    public Map<Integer, Roaring64NavigableMap> getCachedBlockIds() {
        return this.cachedBlockIds;
    }

    public String getUser() {
        return this.user.get();
    }

    public void setUser(String user) {
        this.user.set(user);
    }

    public int getMaxConcurrencyPerPartitionToWrite() {
        return this.specification.get().getMaxConcurrencyPerPartitionToWrite();
    }

    public ShuffleDataDistributionType getDataDistType() {
        return this.specification.get().getDistributionType();
    }

    public void setSpecification(ShuffleSpecification specification) {
        this.specification.set(specification);
    }

    public long addPartitionDataSize(int shuffleId, int partitionId, long delta) {
        this.totalDataSize.addAndGet(delta);
        this.inMemoryDataSize.addAndGet(delta);
        ShuffleDetailInfo shuffleDetailInfo = this.shuffleDetailInfos.computeIfAbsent(shuffleId, key -> new ShuffleDetailInfo(shuffleId, System.currentTimeMillis()));
        shuffleDetailInfo.incrDataSize(delta);
        this.partitionDataSizes.computeIfAbsent(shuffleId, key -> JavaUtils.newConcurrentMap());
        Map<Integer, Long> partitions = this.partitionDataSizes.get(shuffleId);
        partitions.computeIfAbsent(partitionId, k -> {
            shuffleDetailInfo.incrPartitionCount();
            return 0L;
        });
        return partitions.computeIfPresent(partitionId, (k, v) -> {
            long size = v + delta;
            if (size > this.maxSizePartitionInfo.getSize()) {
                this.maxSizePartitionInfo.update(partitionId, shuffleId, size, this.getBlockNumber(shuffleId, partitionId));
            }
            return size;
        });
    }

    public long getTotalDataSize() {
        return this.totalDataSize.get();
    }

    public long getInMemoryDataSize() {
        return this.inMemoryDataSize.get();
    }

    public long addOnLocalFileDataSize(long delta, boolean isNewlyCreated) {
        if (isNewlyCreated) {
            this.onLocalFileNum.incrementAndGet();
        }
        this.inMemoryDataSize.addAndGet(-delta);
        return this.onLocalFileDataSize.addAndGet(delta);
    }

    public long getOnLocalFileDataSize() {
        return this.onLocalFileDataSize.get();
    }

    public long addOnHadoopDataSize(long delta, boolean isNewlyCreated) {
        if (isNewlyCreated) {
            this.onHadoopDataSize.incrementAndGet();
        }
        this.inMemoryDataSize.addAndGet(-delta);
        return this.onHadoopDataSize.addAndGet(delta);
    }

    public long getOnHadoopDataSize() {
        return this.onHadoopDataSize.get();
    }

    public long getPartitionDataSize(int shuffleId, int partitionId) {
        Map<Integer, Long> partitions = this.partitionDataSizes.get(shuffleId);
        if (partitions == null) {
            return 0L;
        }
        Long size = partitions.get(partitionId);
        if (size == null) {
            return 0L;
        }
        return size;
    }

    public boolean hasHugePartition() {
        return this.existHugePartition.get();
    }

    public int getHugePartitionSize() {
        return this.hugePartitionTags.values().stream().map(x -> x.size()).reduce((x, y) -> x + y).orElse(0);
    }

    public void markHugePartition(int shuffleId, int partitionId) {
        Set partitions;
        boolean markedWithCAS;
        if (!this.existHugePartition.get() && (markedWithCAS = this.existHugePartition.compareAndSet(false, true))) {
            ShuffleServerMetrics.gaugeAppWithHugePartitionNum.inc();
            ShuffleServerMetrics.counterTotalAppWithHugePartitionNum.inc();
        }
        if ((partitions = this.hugePartitionTags.computeIfAbsent(shuffleId, key -> Sets.newConcurrentHashSet())).add(partitionId)) {
            ShuffleServerMetrics.counterTotalHugePartitionNum.inc();
            ShuffleServerMetrics.gaugeHugePartitionNum.inc();
            LOGGER.warn("Huge partition occurs, appId: {}, shuffleId: {}, partitionId: {}", new Object[]{this.appId, shuffleId, partitionId});
        }
    }

    public boolean isHugePartition(int shuffleId, int partitionId) {
        if (!this.existHugePartition.get()) {
            return false;
        }
        Set<Integer> partitions = this.hugePartitionTags.get(shuffleId);
        return partitions != null && partitions.contains(partitionId);
    }

    public Set<Integer> getShuffleIds() {
        return this.partitionDataSizes.keySet();
    }

    public Set<Integer> getPartitionIds(int shuffleId) {
        return this.partitionDataSizes.get(shuffleId).keySet();
    }

    public void incBlockNumber(int shuffleId, int partitionId, int delta) {
        long blockCount = this.partitionBlockCounters.computeIfAbsent(shuffleId, x -> JavaUtils.newConcurrentMap()).computeIfAbsent(partitionId, x -> new AtomicLong()).addAndGet(delta);
        if (this.maxSizePartitionInfo.isCurrentPartition(shuffleId, partitionId)) {
            this.maxSizePartitionInfo.setBlockCount(blockCount);
        }
        this.shuffleDetailInfos.computeIfAbsent(shuffleId, key -> new ShuffleDetailInfo(shuffleId, System.currentTimeMillis())).incrBlockCount(delta);
    }

    public long getBlockNumber(int shuffleId, int partitionId) {
        Map<Integer, AtomicLong> partitionBlockCounters = this.partitionBlockCounters.get(shuffleId);
        if (partitionBlockCounters == null) {
            return 0L;
        }
        AtomicLong counter = partitionBlockCounters.get(partitionId);
        if (counter == null) {
            return 0L;
        }
        return counter.get();
    }

    public Integer getLatestStageAttemptNumber(int shuffleId) {
        return this.latestStageAttemptNumbers.getOrDefault(shuffleId, 0);
    }

    public void refreshLatestStageAttemptNumber(int shuffleId, int stageAttemptNumber) {
        this.latestStageAttemptNumbers.put(shuffleId, stageAttemptNumber);
    }

    public PartitionInfo getMaxSizePartitionInfo() {
        return this.maxSizePartitionInfo;
    }

    public ShuffleDetailInfo getShuffleDetailInfo(int shuffleId) {
        return this.shuffleDetailInfos.get(shuffleId);
    }

    public long getPartitionNum() {
        return this.partitionDataSizes.values().stream().mapToLong(Map::size).sum();
    }

    public String toString() {
        return "ShuffleTaskInfo{appId='" + this.appId + '\'' + ", totalDataSize=" + UnitConverter.formatSize((long)this.totalDataSize.get()) + ", inMemoryDataSize=" + UnitConverter.formatSize((long)this.inMemoryDataSize.get()) + ", onLocalFileDataSize=" + UnitConverter.formatSize((long)this.onLocalFileDataSize.get()) + ", onHadoopDataSize=" + UnitConverter.formatSize((long)this.onHadoopDataSize.get()) + ", maxSizePartitionInfo=" + this.maxSizePartitionInfo + ", shuffleDetailInfo=" + this.shuffleDetailInfos + '}';
    }

    public void setProperties(Map<String, String> properties) {
        Map<String, String> filteredProperties = properties.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(".rss.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.properties = filteredProperties;
        LOGGER.info("{} set properties to {}", (Object)this.appId, filteredProperties);
        String keyName = RssClientConf.RSS_CLIENT_BLOCK_ID_MANAGER_CLASS.key();
        String className = properties.get(keyName);
        if (StringUtils.isEmpty((CharSequence)className)) {
            keyName = "spark." + RssClientConf.RSS_CLIENT_BLOCK_ID_MANAGER_CLASS.key();
            className = properties.get("spark." + RssClientConf.RSS_CLIENT_BLOCK_ID_MANAGER_CLASS.key());
        }
        if (StringUtils.isNotEmpty((CharSequence)className)) {
            this.shuffleBlockIdManager = ShuffleBlockIdManagerFactory.createShuffleBlockIdManager(className, keyName);
            LOGGER.info("{} use app configured ShuffleBlockIdManager to {}", (Object)this.appId, (Object)this.shuffleBlockIdManager);
        }
    }

    public ShuffleBlockIdManager getShuffleBlockIdManager() {
        return this.shuffleBlockIdManager;
    }

    public void setShuffleBlockIdManagerIfNeeded(ShuffleBlockIdManager shuffleBlockIdManager) {
        if (this.shuffleBlockIdManager == null) {
            this.shuffleBlockIdManager = shuffleBlockIdManager;
        }
    }
}

