/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.buffer.lab;

import java.util.LinkedList;
import java.util.List;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.buffer.lab.Chunk;
import org.apache.uniffle.server.buffer.lab.ChunkCreator;
import org.apache.uniffle.server.buffer.lab.LABShufflePartitionedBlock;

public class LAB {
    private Chunk currChunk;
    List<Integer> chunks = new LinkedList<Integer>();
    private final int maxAlloc;
    private final ChunkCreator chunkCreator = ChunkCreator.getInstance();

    public LAB() {
        this.maxAlloc = this.chunkCreator.getMaxAlloc();
    }

    public ShufflePartitionedBlock tryCopyBlockToChunk(ShufflePartitionedBlock block) {
        Chunk c;
        int allocOffset;
        int size = block.getDataLength();
        if (size > this.maxAlloc) {
            ShuffleServerMetrics.counterBlockNotOnLAB.inc();
            return block;
        }
        while ((allocOffset = (c = this.getOrMakeChunk()).getAllocOffset(size)) == -1) {
            this.currChunk = null;
        }
        c.getData().writeBytes(block.getData());
        ShuffleServerMetrics.counterBlockOnLAB.inc();
        return new LABShufflePartitionedBlock(block.getDataLength(), block.getUncompressLength(), block.getCrc(), block.getBlockId(), block.getTaskAttemptId(), c.getData().slice(allocOffset, size));
    }

    public void close() {
        this.recycleChunks();
    }

    private void recycleChunks() {
        this.chunkCreator.putBackChunks(this.chunks);
    }

    private Chunk getOrMakeChunk() {
        Chunk c = this.currChunk;
        if (c != null) {
            return c;
        }
        this.currChunk = c = this.chunkCreator.getChunk();
        this.chunks.add(c.getId());
        return c;
    }
}

