/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.merge;

import io.netty.buffer.ByteBuf;
import io.netty.util.IllegalReferenceCountException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.RawComparator;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShuffleIndexResult;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.ShufflePartitionedData;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.FileNotFoundException;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.merger.MergeState;
import org.apache.uniffle.common.merger.Merger;
import org.apache.uniffle.common.merger.Segment;
import org.apache.uniffle.common.merger.StreamedSegment;
import org.apache.uniffle.common.netty.buffer.FileSegmentManagedBuffer;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.netty.buffer.NettyManagedBuffer;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.serializer.SerInputStream;
import org.apache.uniffle.common.serializer.SerOutputStream;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.server.ShuffleDataReadEvent;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.buffer.ShuffleBuffer;
import org.apache.uniffle.server.buffer.ShuffleBufferWithSkipList;
import org.apache.uniffle.server.merge.BlockFlushFileReader;
import org.apache.uniffle.server.merge.MergeEvent;
import org.apache.uniffle.server.merge.MergeStatus;
import org.apache.uniffle.server.merge.MergedResult;
import org.apache.uniffle.server.merge.Shuffle;
import org.apache.uniffle.shaded.guava.collect.Range;
import org.apache.uniffle.storage.common.Storage;
import org.apache.uniffle.storage.handler.impl.LocalFileServerReadHandler;
import org.apache.uniffle.storage.request.CreateShuffleReadHandlerRequest;
import org.apache.uniffle.storage.util.StorageType;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Partition<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(Partition.class);
    private final Shuffle shuffle;
    private final int partitionId;
    private MergeState state = MergeState.INITED;
    private MergedResult result;
    private ShuffleMeta shuffleMeta = new ShuffleMeta();
    private final long initSleepTime;
    private final long maxSleepTime;
    private long sleepTime;
    private int ringBufferSize;
    private BlockFlushFileReader reader = null;

    public Partition(Shuffle shuffle, int partitionId) throws IOException {
        this.shuffle = shuffle;
        this.partitionId = partitionId;
        this.result = new MergedResult(shuffle.serverConf, this::cachedMergedBlock, shuffle.mergedBlockSize, this);
        this.initSleepTime = (Long)shuffle.serverConf.get(ShuffleServerConf.SERVER_MERGE_CACHE_MERGED_BLOCK_INIT_SLEEP_MS);
        this.maxSleepTime = (Long)shuffle.serverConf.get(ShuffleServerConf.SERVER_MERGE_CACHE_MERGED_BLOCK_MAX_SLEEP_MS);
        int tmpRingBufferSize = (Integer)shuffle.serverConf.get(ShuffleServerConf.SERVER_MERGE_BLOCK_RING_BUFFER_SIZE);
        this.ringBufferSize = Integer.highestOneBit(Math.min(32, Math.max(2, tmpRingBufferSize)) - 1 << 1);
        if (tmpRingBufferSize != this.ringBufferSize) {
            LOG.info("The ring buffer size will transient from {} to {}", (Object)tmpRingBufferSize, (Object)this.ringBufferSize);
        }
    }

    synchronized void startSortMerge(Roaring64NavigableMap expectedBlockIdMap) {
        if (this.getState() != MergeState.INITED) {
            LOG.warn("Partition is already merging, so ignore duplicate reports, partition is {}", (Object)this);
        } else if (!expectedBlockIdMap.isEmpty()) {
            this.setState(MergeState.MERGING);
            MergeEvent event = new MergeEvent(this.shuffle.appId, this.shuffle.shuffleId, this.partitionId, this.shuffle.kClass, this.shuffle.vClass, expectedBlockIdMap);
            if (!this.shuffle.eventHandler.handle(event)) {
                this.setState(MergeState.INTERNAL_ERROR);
            }
        } else {
            this.setState(MergeState.DONE);
        }
    }

    private ShufflePartitionedBlock getShufflePartitionedBlock(long blockId, boolean merged) {
        Map.Entry<Range<Integer>, ShuffleBuffer> entry = this.shuffle.shuffleServer.getShuffleBufferManager().getShuffleBufferEntry(merged ? this.shuffle.appId + "@RemoteMerge" : this.shuffle.appId, this.shuffle.shuffleId, this.partitionId);
        if (entry != null) {
            ShuffleBuffer shuffleBuffer = entry.getValue();
            return ((ShuffleBufferWithSkipList)shuffleBuffer).getBlock(blockId);
        }
        return null;
    }

    public boolean collectBlocks(Iterator<Long> blockIds, Map<Long, ByteBuf> cachedBlocks) {
        boolean allCached = true;
        while (blockIds.hasNext()) {
            long blockId = blockIds.next();
            ShufflePartitionedBlock block = this.getShufflePartitionedBlock(blockId, false);
            if (block == null) {
                allCached = false;
                continue;
            }
            try {
                ByteBuf byteBuf;
                if (block.isOnLAB()) {
                    byteBuf = ByteBufUtils.copy((ByteBuf)block.getData());
                    cachedBlocks.put(blockId, byteBuf);
                    continue;
                }
                byteBuf = block.getData().retain().duplicate();
                cachedBlocks.put(blockId, byteBuf.slice(0, block.getDataLength()));
            }
            catch (IllegalReferenceCountException irce) {
                allCached = false;
                LOG.warn("Can't read bytes from block in memory, maybe already been flushed!");
            }
        }
        return allCached;
    }

    BlockFlushFileReader createReader(RssConf rssConf) {
        LocalFileServerReadHandler handler = this.getLocalFileServerReadHandler(rssConf, this.shuffle.appId);
        return new BlockFlushFileReader(handler.getDataFileName(), handler.getIndexFileName(), this.ringBufferSize, this.shuffle.direct);
    }

    public boolean collectSegments(RssConf rssConf, Iterator<Long> blockIds, Class keyClass, Class valueClass, Map<Long, ByteBuf> cachedBlock, List<Segment> segments, BlockFlushFileReader reader) {
        while (blockIds.hasNext()) {
            long blockId = blockIds.next();
            if (cachedBlock.containsKey(blockId)) {
                ByteBuf byteBuf = cachedBlock.get(blockId);
                SerInputStream serInputStream = SerInputStream.newInputStream((ByteBuf)byteBuf);
                StreamedSegment segment = new StreamedSegment(rssConf, serInputStream, blockId, keyClass, valueClass, (long)byteBuf.readableBytes(), this.shuffle.comparator instanceof RawComparator);
                segments.add((Segment)segment);
                continue;
            }
            BlockFlushFileReader.BlockInputStream inputStream = reader.registerBlockInputStream(blockId);
            if (inputStream == null) {
                LOG.warn("Can not find any buffer or file for block {}", (Object)blockId);
                return false;
            }
            segments.add((Segment)new StreamedSegment(rssConf, (SerInputStream)inputStream, blockId, keyClass, valueClass, (long)inputStream.available(), this.shuffle.comparator instanceof RawComparator));
        }
        return true;
    }

    SerOutputStream createSerOutputStream(long totalBytes) {
        return this.result.getOutputStream(this.shuffle.direct, totalBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void merge(List<Segment> segments, SerOutputStream output, BlockFlushFileReader reader) {
        try {
            segments.forEach(segment -> segment.init());
            if (reader != null) {
                reader.start();
            }
            Merger.merge((RssConf)this.shuffle.serverConf, (SerOutputStream)output, segments, this.shuffle.kClass, this.shuffle.vClass, this.shuffle.comparator, (boolean)(this.shuffle.comparator instanceof RawComparator));
            this.setState(MergeState.DONE);
        }
        catch (Exception e) {
            LOG.info("Found exception when merge for {}, caused by", (Object)this, (Object)e);
            this.setState(MergeState.INTERNAL_ERROR);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ioe) {
                LOG.warn("Fail to close reader, caused by", (Object)this, (Object)ioe);
            }
            try {
                output.close();
            }
            catch (IOException ioe) {
                LOG.warn("Fail to close output, caused by ", (Throwable)ioe);
            }
            segments.forEach(segment -> {
                try {
                    segment.close();
                }
                catch (IOException ioe) {
                    LOG.warn("Fail to close segment, caused by ", (Throwable)ioe);
                }
            });
        }
    }

    public void setState(MergeState state) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Partition is {}, transient from {} to {}.", new Object[]{this, this.state.name(), state.name()});
        }
        this.state = state;
    }

    public MergeState getState() {
        return this.state;
    }

    public MergeStatus tryGetBlock(long blockId) {
        long size = -1L;
        MergeState currentState = this.state;
        if (!(currentState != MergeState.MERGING && currentState != MergeState.DONE || this.result.isOutOfBound(blockId))) {
            size = this.result.getBlockSize(blockId);
        }
        return new MergeStatus(currentState, size);
    }

    public void requireMemory(int requireSize) throws IOException {
        while (!this.shuffle.shuffleServer.getShuffleTaskManager().requireMemory(requireSize, false)) {
            try {
                LOG.debug("Can not allocate enough memory for {}, then will sleep {}ms", (Object)this, (Object)this.sleepTime);
                Thread.sleep(this.sleepTime);
                this.sleepTime = Math.min(this.maxSleepTime, this.sleepTime * 2L);
            }
            catch (InterruptedException ex) {
                LOG.warn("Found InterruptedException when sleep to wait require buffer {}", (Object)this);
                throw new IOException(ex);
            }
        }
    }

    public void releaseMemory(int requireSize) {
        this.shuffle.shuffleServer.getShuffleTaskManager().releaseMemory(requireSize, false, false);
    }

    private boolean cachedMergedBlock(ByteBuf byteBuf, long blockId, int length) {
        String appId = this.shuffle.appId + "@RemoteMerge";
        ShufflePartitionedBlock spb = new ShufflePartitionedBlock(length, length, -1L, blockId, -1L, byteBuf.retain());
        ShufflePartitionedData spd = new ShufflePartitionedData(this.partitionId, new ShufflePartitionedBlock[]{spb});
        StatusCode ret = this.shuffle.shuffleServer.getShuffleTaskManager().cacheShuffleData(appId, this.shuffle.shuffleId, true, spd);
        if (ret == StatusCode.SUCCESS) {
            this.shuffle.shuffleServer.getShuffleTaskManager().updateCachedBlockIds(appId, this.shuffle.shuffleId, spd.getPartitionId(), spd.getBlockList());
            this.sleepTime = this.initSleepTime;
            return true;
        }
        String shuffleDataInfo = "appId[" + appId + "], shuffleId[" + this.shuffle.shuffleId + "], partitionId[" + spd.getPartitionId() + "]";
        LOG.warn("Error happened when shuffleEngine.write for {}, statusCode={}", (Object)shuffleDataInfo, (Object)ret);
        byteBuf.release();
        return false;
    }

    public ShuffleDataResult getShuffleData(long blockId) throws IOException {
        NettyManagedBuffer managedBuffer = this.getMergedBlockBufferInMemory(blockId);
        if (managedBuffer != null) {
            return new ShuffleDataResult((ManagedBuffer)managedBuffer);
        }
        managedBuffer = this.getMergedBlockBufferInFile(this.shuffle.serverConf, blockId);
        return new ShuffleDataResult((ManagedBuffer)managedBuffer);
    }

    private NettyManagedBuffer getMergedBlockBufferInMemory(long blockId) {
        try {
            ShufflePartitionedBlock block = this.getShufflePartitionedBlock(blockId, true);
            if (block != null) {
                ByteBuf byteBuf = block.getData().retain();
                return new NettyManagedBuffer(byteBuf.duplicate());
            }
            return null;
        }
        catch (IllegalReferenceCountException e) {
            LOG.warn("Get ByteBuf from memory failed, cased by", (Throwable)e);
            return null;
        }
    }

    private synchronized ManagedBuffer getMergedBlockBufferInFile(RssConf rssConf, long blockId) {
        ShuffleMeta.Segment segment;
        String appId = this.shuffle.appId + "@RemoteMerge";
        if (!this.shuffleMeta.getSegments().containsKey(blockId)) {
            this.reloadShuffleMeta(rssConf, appId);
        }
        if ((segment = this.shuffleMeta.getSegments().get(blockId)) != null) {
            return new FileSegmentManagedBuffer(new File(this.shuffleMeta.getDataFileName()), segment.getOffset(), segment.getLength());
        }
        throw new RssException("Can not find block for blockId " + blockId);
    }

    private synchronized void reloadShuffleMeta(RssConf rssConf, String appId) {
        ShuffleIndexResult indexResult = this.loadShuffleIndexResult(rssConf, appId);
        this.shuffleMeta.setDataFileName(indexResult.getDataFileName());
        ByteBuffer indexData = indexResult.getIndexData();
        HashMap<Long, ShuffleMeta.Segment> segments = new HashMap<Long, ShuffleMeta.Segment>();
        while (indexData.hasRemaining()) {
            long offset = indexData.getLong();
            int length = indexData.getInt();
            int uncompressLength = indexData.getInt();
            long crc = indexData.getLong();
            long blockId = indexData.getLong();
            long taskAttemptId = indexData.getLong();
            segments.put(blockId, new ShuffleMeta.Segment(offset, length));
        }
        this.shuffleMeta.getSegments().clear();
        this.shuffleMeta.getSegments().putAll(segments);
    }

    private ShuffleIndexResult loadShuffleIndexResult(RssConf rssConf, String appId) {
        CreateShuffleReadHandlerRequest request = new CreateShuffleReadHandlerRequest();
        request.setAppId(appId);
        request.setShuffleId(this.shuffle.shuffleId);
        request.setPartitionId(this.partitionId);
        request.setPartitionNumPerRange(1);
        request.setPartitionNum(Integer.MAX_VALUE);
        request.setStorageType(StorageType.LOCALFILE.name());
        request.setRssBaseConf((RssBaseConf)rssConf);
        Storage storage = this.shuffle.shuffleServer.getStorageManager().selectStorage(new ShuffleDataReadEvent(appId, this.shuffle.shuffleId, this.partitionId, this.partitionId));
        if (storage == null) {
            throw new FileNotFoundException("No such data in current storage manager.");
        }
        ShuffleIndexResult index = storage.getOrCreateReadHandler(request).getShuffleIndex();
        return index;
    }

    private LocalFileServerReadHandler getLocalFileServerReadHandler(RssConf rssConf, String appId) {
        CreateShuffleReadHandlerRequest request = new CreateShuffleReadHandlerRequest();
        request.setAppId(appId);
        request.setShuffleId(this.shuffle.shuffleId);
        request.setPartitionId(this.partitionId);
        request.setPartitionNumPerRange(1);
        request.setPartitionNum(Integer.MAX_VALUE);
        request.setStorageType(StorageType.LOCALFILE.name());
        request.setRssBaseConf((RssBaseConf)rssConf);
        Storage storage = this.shuffle.shuffleServer.getStorageManager().selectStorage(new ShuffleDataReadEvent(appId, this.shuffle.shuffleId, this.partitionId, this.partitionId));
        if (storage == null) {
            throw new FileNotFoundException("No such data in current storage manager.");
        }
        return (LocalFileServerReadHandler)storage.getOrCreateReadHandler(request);
    }

    void cleanup() {
        try {
            this.shuffleMeta.clear();
        }
        catch (Exception e) {
            LOG.warn("Partition {} clean up failed, caused by {}", (Object)this, (Object)e);
        }
    }

    public String toString() {
        return "Partition{appId=" + this.shuffle.appId + ", shuffle=" + this.shuffle.shuffleId + ", partitionId=" + this.partitionId + ", state=" + this.state + '}';
    }

    public static class ShuffleMeta {
        private String dataFileName;
        private Map<Long, Segment> segments = new HashMap<Long, Segment>();

        public void setDataFileName(String dataFileName) {
            this.dataFileName = dataFileName;
        }

        public String getDataFileName() {
            return this.dataFileName;
        }

        public Map<Long, Segment> getSegments() {
            return this.segments;
        }

        public void clear() {
            this.segments.clear();
        }

        public static class Segment {
            private long offset;
            private int length;

            public Segment(long offset, int length) {
                this.offset = offset;
                this.length = length;
            }

            public long getOffset() {
                return this.offset;
            }

            public int getLength() {
                return this.length;
            }
        }
    }
}

