/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.storage;

import org.apache.commons.lang3.StringUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.storage.LocalStorageManager;

public class LocalStorageManagerFactory {
    public static LocalStorageManager get(ShuffleServerConf conf) {
        String className = (String)conf.get(ShuffleServerConf.SERVER_LOCAL_STORAGE_MANAGER_CLASS);
        if (StringUtils.isEmpty((CharSequence)className)) {
            throw new IllegalStateException("Configuration error: " + ShuffleServerConf.SERVER_LOCAL_STORAGE_MANAGER_CLASS.toString() + " should not set to empty");
        }
        try {
            return (LocalStorageManager)RssUtils.getConstructor((String)className, (Class[])new Class[]{ShuffleServerConf.class}).newInstance(new Object[]{conf});
        }
        catch (Exception e) {
            throw new IllegalStateException("Configuration error: " + ShuffleServerConf.SERVER_LOCAL_STORAGE_MANAGER_CLASS.toString() + " is failed to create instance of " + className, e);
        }
    }
}

