/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.storage;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleDataReadEvent;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.storage.LocalStorageManager;
import org.apache.uniffle.storage.common.CompositeReadingViewStorage;
import org.apache.uniffle.storage.common.LocalStorage;
import org.apache.uniffle.storage.common.Storage;
import org.apache.uniffle.storage.util.ShuffleStorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPartLocalStorageManager
extends LocalStorageManager {
    private static final Logger LOG = LoggerFactory.getLogger(MultiPartLocalStorageManager.class);
    private final Map<Integer, LocalStorage> idToStorages = new ConcurrentSkipListMap<Integer, LocalStorage>();
    private final CompositeReadingViewStorage compositeStorage;

    public MultiPartLocalStorageManager(ShuffleServerConf conf) {
        super(conf);
        for (LocalStorage storage : this.getStorages()) {
            this.idToStorages.put(storage.getId(), storage);
        }
        this.compositeStorage = new CompositeReadingViewStorage(this.getStorages());
    }

    @Override
    public Storage selectStorage(ShuffleDataFlushEvent event) {
        List candidates;
        if (this.getStorages().size() == 1) {
            if (event.getUnderStorage() == null) {
                event.setUnderStorage((Storage)this.getStorages().get(0));
            }
            return (Storage)this.getStorages().get(0);
        }
        String appId = event.getAppId();
        int shuffleId = event.getShuffleId();
        int partitionId = event.getStartPartition();
        LocalStorage storage = this.getStorages().get((int)(event.getEventId() % (long)this.getStorages().size()));
        if (storage != null) {
            if (storage.isCorrupted()) {
                if (storage.containsWriteHandler(appId, shuffleId, partitionId)) {
                    LOG.error("LocalStorage: {} is corrupted. Switching another storage for event: {}, some data will be lost", (Object)storage.getBasePath(), (Object)event);
                }
            } else {
                if (event.getUnderStorage() == null) {
                    event.setUnderStorage((Storage)storage);
                }
                return storage;
            }
        }
        if ((candidates = this.getStorages().stream().filter(x -> x.canWrite() && !x.isCorrupted()).collect(Collectors.toList())).size() == 0) {
            return null;
        }
        LocalStorage selectedStorage = (LocalStorage)candidates.get(ShuffleStorageUtils.getStorageIndex((int)candidates.size(), (String)appId, (int)shuffleId, (int)partitionId));
        if (storage == null || storage.isCorrupted() || event.getUnderStorage() == null) {
            event.setUnderStorage((Storage)selectedStorage);
            return selectedStorage;
        }
        return storage;
    }

    @Override
    public Storage selectStorage(ShuffleDataReadEvent event) {
        if (this.getStorages().size() == 1) {
            return (Storage)this.getStorages().get(0);
        }
        int storageId = event.getStorageId();
        return (Storage)this.idToStorages.get(storageId);
    }

    @Override
    public Storage selectStorageById(ShuffleDataReadEvent event) {
        return this.compositeStorage;
    }
}

