/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.uniffle.common.exception.FileNotFoundException;
import org.apache.uniffle.storage.common.AbstractStorage;
import org.apache.uniffle.storage.common.LocalStorage;
import org.apache.uniffle.storage.common.StorageReadMetrics;
import org.apache.uniffle.storage.common.StorageWriteMetrics;
import org.apache.uniffle.storage.handler.api.ServerReadHandler;
import org.apache.uniffle.storage.handler.api.ShuffleWriteHandler;
import org.apache.uniffle.storage.handler.impl.CompositeLocalFileServerReadHandler;
import org.apache.uniffle.storage.request.CreateShuffleReadHandlerRequest;
import org.apache.uniffle.storage.request.CreateShuffleWriteHandlerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeReadingViewStorage
extends AbstractStorage {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeReadingViewStorage.class);
    private final List<LocalStorage> localStorages;

    public CompositeReadingViewStorage(List<LocalStorage> localStorages) {
        this.localStorages = localStorages;
    }

    @Override
    ShuffleWriteHandler newWriteHandler(CreateShuffleWriteHandlerRequest request) {
        return null;
    }

    @Override
    public ServerReadHandler getOrCreateReadHandler(CreateShuffleReadHandlerRequest request) {
        return this.newReadHandler(request);
    }

    @Override
    protected ServerReadHandler newReadHandler(CreateShuffleReadHandlerRequest request) {
        ArrayList<ServerReadHandler> handlers = new ArrayList<ServerReadHandler>();
        for (LocalStorage storage : this.localStorages) {
            try {
                handlers.add(storage.getOrCreateReadHandler(request));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception e) {
                LOG.error("Failed to create read handler for storage: " + storage, (Throwable)e);
            }
        }
        return new CompositeLocalFileServerReadHandler(handlers);
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public void updateWriteMetrics(StorageWriteMetrics metrics) {
    }

    @Override
    public void updateReadMetrics(StorageReadMetrics metrics) {
    }

    @Override
    public void createMetadataIfNotExist(String shuffleKey) {
    }

    @Override
    public String getStoragePath() {
        return null;
    }

    @Override
    public String getStorageHost() {
        return null;
    }
}

