// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

#[cfg(unix)]
pub mod details {
    use log::info;
    use signal_hook::{consts::TERM_SIGNALS, iterator::Signals};

    pub fn wait_for_signal() {
        let mut sigs = Signals::new(TERM_SIGNALS).expect("Failed to register signal handlers");

        for signal in &mut sigs {
            if TERM_SIGNALS.contains(&signal) {
                info!("Received signal {}, stopping server...", signal);
                break;
            }
        }
    }

    pub fn graceful_wait_for_signal(tx: tokio::sync::broadcast::Sender<()>) {
        let mut sigs = Signals::new(TERM_SIGNALS).expect("Failed to register signal handlers");

        for signal in &mut sigs {
            if TERM_SIGNALS.contains(&signal) {
                info!("Received signal {}, stopping server...", signal);
                let _ = tx.send(());
                break;
            }
        }
    }
}

#[cfg(not(unix))]
pub mod details {
    use std::thread;
    use std::time::Duration;

    // todo: this should be handled elegantly.
    pub fn wait_for_signal() {
        while 1 {
            thread::sleep(Duration::from_millis(20));
        }
    }
}
