/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.strategy.storage;

import java.util.Comparator;
import java.util.Map;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.strategy.storage.AbstractSelectStorageStrategy;
import org.apache.uniffle.coordinator.strategy.storage.RankValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowestIOSampleCostSelectStorageStrategy
extends AbstractSelectStorageStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(LowestIOSampleCostSelectStorageStrategy.class);
    private final Map<String, RemoteStorageInfo> appIdToRemoteStorageInfo;
    private final Map<String, RemoteStorageInfo> availableRemoteStorageInfo;

    public LowestIOSampleCostSelectStorageStrategy(Map<String, RankValue> remoteStoragePathRankValue, Map<String, RemoteStorageInfo> appIdToRemoteStorageInfo, Map<String, RemoteStorageInfo> availableRemoteStorageInfo, CoordinatorConf conf) {
        super(remoteStoragePathRankValue, conf);
        this.appIdToRemoteStorageInfo = appIdToRemoteStorageInfo;
        this.availableRemoteStorageInfo = availableRemoteStorageInfo;
    }

    @Override
    public Comparator<Map.Entry<String, RankValue>> getComparator() {
        return (x, y) -> {
            long yReadAndWriteTime;
            long xReadAndWriteTime = ((RankValue)x.getValue()).getCostTime().get();
            if (xReadAndWriteTime > (yReadAndWriteTime = ((RankValue)y.getValue()).getCostTime().get())) {
                return 1;
            }
            if (xReadAndWriteTime < yReadAndWriteTime) {
                return -1;
            }
            return Integer.compare(((RankValue)x.getValue()).getAppNum().get(), ((RankValue)y.getValue()).getAppNum().get());
        };
    }

    @Override
    public synchronized RemoteStorageInfo pickStorage(String appId) {
        LOG.info("The sorted remote path list is: {}", (Object)this.uris);
        for (Map.Entry uri : this.uris) {
            String storagePath = (String)uri.getKey();
            if (!this.availableRemoteStorageInfo.containsKey(storagePath)) continue;
            return this.appIdToRemoteStorageInfo.computeIfAbsent(appId, x -> this.availableRemoteStorageInfo.get(storagePath));
        }
        LOG.warn("No remote storage is available, we will default to the first.");
        return this.availableRemoteStorageInfo.values().iterator().next();
    }

    @Override
    public int readAndWriteTimes(CoordinatorConf conf) {
        return conf.getInteger(CoordinatorConf.COORDINATOR_REMOTE_STORAGE_SCHEDULE_ACCESS_TIMES);
    }
}

