/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.buffer;

import io.netty.util.internal.PlatformDependent;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShufflePartitionedData;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.NettyUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleFlushManager;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.ShuffleTaskManager;
import org.apache.uniffle.server.buffer.ShuffleBuffer;
import org.apache.uniffle.shaded.guava.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.guava.collect.Lists;
import org.apache.uniffle.shaded.guava.collect.Maps;
import org.apache.uniffle.shaded.guava.collect.Range;
import org.apache.uniffle.shaded.guava.collect.RangeMap;
import org.apache.uniffle.shaded.guava.collect.Sets;
import org.apache.uniffle.shaded.guava.collect.TreeRangeMap;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleBufferManager {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleBufferManager.class);
    private ShuffleTaskManager shuffleTaskManager;
    private final ShuffleFlushManager shuffleFlushManager;
    private long capacity;
    private long readCapacity;
    private long highWaterMark;
    private long lowWaterMark;
    private boolean bufferFlushEnabled;
    private long bufferFlushThreshold;
    private long shuffleFlushThreshold;
    private long hugePartitionSizeThreshold;
    private long hugePartitionMemoryLimitSize;
    protected long bufferSize = 0L;
    protected AtomicLong preAllocatedSize = new AtomicLong(0L);
    protected AtomicLong inFlushSize = new AtomicLong(0L);
    protected AtomicLong usedMemory = new AtomicLong(0L);
    private AtomicLong readDataMemory = new AtomicLong(0L);
    protected Map<String, Map<Integer, RangeMap<Integer, ShuffleBuffer>>> bufferPool;
    protected Map<String, Map<Integer, AtomicLong>> shuffleSizeMap = JavaUtils.newConcurrentMap();

    public ShuffleBufferManager(ShuffleServerConf conf, ShuffleFlushManager shuffleFlushManager, boolean nettyServerEnabled) {
        long heapSize = Runtime.getRuntime().maxMemory();
        this.capacity = conf.getSizeAsBytes(ShuffleServerConf.SERVER_BUFFER_CAPACITY);
        if (this.capacity < 0L) {
            this.capacity = nettyServerEnabled ? (long)((double)NettyUtils.getMaxDirectMemory() * conf.getDouble(ShuffleServerConf.SERVER_BUFFER_CAPACITY_RATIO)) : (long)((double)heapSize * conf.getDouble(ShuffleServerConf.SERVER_BUFFER_CAPACITY_RATIO));
        }
        this.readCapacity = conf.getSizeAsBytes(ShuffleServerConf.SERVER_READ_BUFFER_CAPACITY);
        if (this.readCapacity < 0L) {
            this.readCapacity = nettyServerEnabled ? (long)((double)NettyUtils.getMaxDirectMemory() * conf.getDouble(ShuffleServerConf.SERVER_READ_BUFFER_CAPACITY_RATIO)) : (long)((double)heapSize * conf.getDouble(ShuffleServerConf.SERVER_READ_BUFFER_CAPACITY_RATIO));
        }
        LOG.info("Init shuffle buffer manager with capacity: {}, read buffer capacity: {}.", (Object)this.capacity, (Object)this.readCapacity);
        this.shuffleFlushManager = shuffleFlushManager;
        this.bufferPool = new ConcurrentHashMap<String, Map<Integer, RangeMap<Integer, ShuffleBuffer>>>();
        this.highWaterMark = (long)((double)this.capacity / 100.0 * (Double)conf.get(ShuffleServerConf.SERVER_MEMORY_SHUFFLE_HIGHWATERMARK_PERCENTAGE));
        this.lowWaterMark = (long)((double)this.capacity / 100.0 * (Double)conf.get(ShuffleServerConf.SERVER_MEMORY_SHUFFLE_LOWWATERMARK_PERCENTAGE));
        this.bufferFlushEnabled = conf.getBoolean(ShuffleServerConf.SINGLE_BUFFER_FLUSH_ENABLED);
        this.bufferFlushThreshold = conf.getSizeAsBytes(ShuffleServerConf.SINGLE_BUFFER_FLUSH_THRESHOLD);
        this.shuffleFlushThreshold = conf.getSizeAsBytes(ShuffleServerConf.SERVER_SHUFFLE_FLUSH_THRESHOLD);
        this.hugePartitionSizeThreshold = conf.getSizeAsBytes(ShuffleServerConf.HUGE_PARTITION_SIZE_THRESHOLD);
        this.hugePartitionMemoryLimitSize = Math.round((double)this.capacity * (Double)conf.get(ShuffleServerConf.HUGE_PARTITION_MEMORY_USAGE_LIMITATION_RATIO));
    }

    public void setShuffleTaskManager(ShuffleTaskManager taskManager) {
        this.shuffleTaskManager = taskManager;
    }

    public StatusCode registerBuffer(String appId, int shuffleId, int startPartition, int endPartition) {
        this.bufferPool.computeIfAbsent(appId, key -> JavaUtils.newConcurrentMap());
        Map<Integer, RangeMap<Integer, ShuffleBuffer>> shuffleIdToBuffers = this.bufferPool.get(appId);
        shuffleIdToBuffers.computeIfAbsent(shuffleId, key -> TreeRangeMap.create());
        RangeMap<Integer, ShuffleBuffer> bufferRangeMap = shuffleIdToBuffers.get(shuffleId);
        if (bufferRangeMap.get(startPartition) == null) {
            ShuffleServerMetrics.counterTotalPartitionNum.inc();
            ShuffleServerMetrics.gaugeTotalPartitionNum.inc();
            bufferRangeMap.put(Range.closed(startPartition, endPartition), new ShuffleBuffer(this.bufferSize));
        } else {
            LOG.warn("Already register for appId[" + appId + "], shuffleId[" + shuffleId + "], startPartition[" + startPartition + "], endPartition[" + endPartition + "]");
        }
        return StatusCode.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusCode cacheShuffleData(String appId, int shuffleId, boolean isPreAllocated, ShufflePartitionedData spd) {
        if (!isPreAllocated && this.isFull()) {
            LOG.warn("Got unexpected data, can't cache it because the space is full");
            return StatusCode.NO_BUFFER;
        }
        Map.Entry<Range<Integer>, ShuffleBuffer> entry = this.getShuffleBufferEntry(appId, shuffleId, spd.getPartitionId());
        if (entry == null) {
            return StatusCode.NO_REGISTER;
        }
        ShuffleBuffer buffer = entry.getValue();
        long size = buffer.append(spd);
        if (!isPreAllocated) {
            this.updateUsedMemory(size);
        }
        this.updateShuffleSize(appId, shuffleId, size);
        ShuffleBufferManager shuffleBufferManager = this;
        synchronized (shuffleBufferManager) {
            this.flushSingleBufferIfNecessary(buffer, appId, shuffleId, spd.getPartitionId(), entry.getKey().lowerEndpoint(), entry.getKey().upperEndpoint());
            this.flushIfNecessary();
        }
        return StatusCode.SUCCESS;
    }

    private void updateShuffleSize(String appId, int shuffleId, long size) {
        this.shuffleSizeMap.computeIfAbsent(appId, key -> JavaUtils.newConcurrentMap());
        Map<Integer, AtomicLong> shuffleIdToSize = this.shuffleSizeMap.get(appId);
        shuffleIdToSize.computeIfAbsent(shuffleId, key -> new AtomicLong(0L));
        shuffleIdToSize.get(shuffleId).addAndGet(size);
    }

    public Map.Entry<Range<Integer>, ShuffleBuffer> getShuffleBufferEntry(String appId, int shuffleId, int partitionId) {
        Map<Integer, RangeMap<Integer, ShuffleBuffer>> shuffleIdToBuffers = this.bufferPool.get(appId);
        if (shuffleIdToBuffers == null) {
            return null;
        }
        RangeMap<Integer, ShuffleBuffer> rangeToBuffers = shuffleIdToBuffers.get(shuffleId);
        if (rangeToBuffers == null) {
            return null;
        }
        Map.Entry<Range<Integer>, ShuffleBuffer> entry = rangeToBuffers.getEntry(partitionId);
        if (entry == null) {
            return null;
        }
        return entry;
    }

    public ShuffleDataResult getShuffleData(String appId, int shuffleId, int partitionId, long blockId, int readBufferSize) {
        return this.getShuffleData(appId, shuffleId, partitionId, blockId, readBufferSize, null);
    }

    public ShuffleDataResult getShuffleData(String appId, int shuffleId, int partitionId, long blockId, int readBufferSize, Roaring64NavigableMap expectedTaskIds) {
        Map.Entry<Range<Integer>, ShuffleBuffer> entry = this.getShuffleBufferEntry(appId, shuffleId, partitionId);
        if (entry == null) {
            return null;
        }
        ShuffleBuffer buffer = entry.getValue();
        if (buffer == null) {
            return null;
        }
        return buffer.getShuffleData(blockId, readBufferSize, expectedTaskIds);
    }

    void flushSingleBufferIfNecessary(ShuffleBuffer buffer, String appId, int shuffleId, int partitionId, int startPartition, int endPartition) {
        boolean isHugePartition = this.isHugePartition(appId, shuffleId, partitionId);
        if ((isHugePartition || this.bufferFlushEnabled) && buffer.getSize() > this.bufferFlushThreshold) {
            this.flushBuffer(buffer, appId, shuffleId, startPartition, endPartition, isHugePartition);
            return;
        }
    }

    public void flushIfNecessary() {
        if (this.usedMemory.get() - this.preAllocatedSize.get() - this.inFlushSize.get() > this.highWaterMark) {
            LOG.info("Start to flush with usedMemory[{}], preAllocatedSize[{}], inFlushSize[{}]", new Object[]{this.usedMemory.get(), this.preAllocatedSize.get(), this.inFlushSize.get()});
            Map<String, Set<Integer>> pickedShuffle = this.pickFlushedShuffle();
            this.flush(pickedShuffle);
        }
    }

    public synchronized void commitShuffleTask(String appId, int shuffleId) {
        RangeMap<Integer, ShuffleBuffer> buffers = this.bufferPool.get(appId).get(shuffleId);
        for (Map.Entry<Range<Integer>, ShuffleBuffer> entry : buffers.asMapOfRanges().entrySet()) {
            ShuffleBuffer buffer = entry.getValue();
            Range<Integer> range = entry.getKey();
            this.flushBuffer(buffer, appId, shuffleId, range.lowerEndpoint(), range.upperEndpoint(), this.isHugePartition(appId, shuffleId, range.lowerEndpoint()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushBuffer(ShuffleBuffer buffer, String appId, int shuffleId, int startPartition, int endPartition, boolean isHugePartition) {
        ReentrantReadWriteLock.ReadLock readLock = this.shuffleTaskManager.getAppReadLock(appId);
        readLock.lock();
        try {
            if (!((Map)this.bufferPool.getOrDefault(appId, new HashMap())).containsKey(shuffleId)) {
                LOG.info("Shuffle[{}] for app[{}] has already been removed, no need to flush the buffer", (Object)shuffleId, (Object)appId);
                return;
            }
            ShuffleDataFlushEvent event = buffer.toFlushEvent(appId, shuffleId, startPartition, endPartition, () -> ((Map)this.bufferPool.getOrDefault(appId, new HashMap())).containsKey(shuffleId), this.shuffleFlushManager.getDataDistributionType(appId));
            if (event != null) {
                event.addCleanupCallback(() -> this.releaseMemory(event.getSize(), true, false));
                this.updateShuffleSize(appId, shuffleId, -event.getSize());
                this.inFlushSize.addAndGet(event.getSize());
                if (isHugePartition) {
                    event.markOwnedByHugePartition();
                }
                ShuffleServerMetrics.gaugeInFlushBufferSize.set((double)this.inFlushSize.get());
                this.shuffleFlushManager.addToFlushQueue(event);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    public void removeBuffer(String appId) {
        Map<Integer, RangeMap<Integer, ShuffleBuffer>> shuffleIdToBuffers = this.bufferPool.get(appId);
        if (shuffleIdToBuffers == null) {
            return;
        }
        this.removeBufferByShuffleId(appId, shuffleIdToBuffers.keySet());
        this.shuffleSizeMap.remove(appId);
        this.bufferPool.remove(appId);
    }

    public synchronized boolean requireMemory(long size, boolean isPreAllocated) {
        if (this.capacity - this.usedMemory.get() >= size) {
            this.usedMemory.addAndGet(size);
            ShuffleServerMetrics.gaugeUsedBufferSize.set((double)this.usedMemory.get());
            if (isPreAllocated) {
                this.requirePreAllocatedSize(size);
            }
            if (LOG.isDebugEnabled()) {
                long usedDirectMemory = PlatformDependent.usedDirectMemory();
                long usedHeapMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                LOG.debug("Require memory succeeded with " + size + " bytes, usedMemory[" + this.usedMemory.get() + "] include preAllocation[" + this.preAllocatedSize.get() + "], inFlushSize[" + this.inFlushSize.get() + "], usedDirectMemory[" + usedDirectMemory + "], usedHeapMemory[" + usedHeapMemory + "]");
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Require memory failed with " + size + " bytes, usedMemory[" + this.usedMemory.get() + "] include preAllocation[" + this.preAllocatedSize.get() + "], inFlushSize[" + this.inFlushSize.get() + "]");
        }
        return false;
    }

    public void releaseMemory(long size, boolean isReleaseFlushMemory, boolean isReleasePreAllocation) {
        if (this.usedMemory.get() >= size) {
            this.usedMemory.addAndGet(-size);
        } else {
            LOG.warn("Current allocated memory[" + this.usedMemory.get() + "] is less than released[" + size + "], set allocated memory to 0");
            this.usedMemory.set(0L);
        }
        ShuffleServerMetrics.gaugeUsedBufferSize.set((double)this.usedMemory.get());
        if (isReleaseFlushMemory) {
            this.releaseFlushMemory(size);
        }
        if (isReleasePreAllocation) {
            this.releasePreAllocatedSize(size);
        }
    }

    private void releaseFlushMemory(long size) {
        if (this.inFlushSize.get() >= size) {
            this.inFlushSize.addAndGet(-size);
        } else {
            LOG.warn("Current in flush memory[" + this.inFlushSize.get() + "] is less than released[" + size + "], set in flush memory to 0");
            this.inFlushSize.set(0L);
        }
        ShuffleServerMetrics.gaugeInFlushBufferSize.set((double)this.inFlushSize.get());
    }

    public boolean requireReadMemory(long size) {
        long currentReadDataMemory;
        long newReadDataMemory;
        ShuffleServerMetrics.counterTotalRequireReadMemoryNum.inc();
        boolean isSuccessful = false;
        while ((newReadDataMemory = (currentReadDataMemory = this.readDataMemory.get()) + size) < this.readCapacity) {
            if (!this.readDataMemory.compareAndSet(currentReadDataMemory, newReadDataMemory)) continue;
            ShuffleServerMetrics.gaugeReadBufferUsedSize.inc((double)size);
            isSuccessful = true;
            break;
        }
        if (!isSuccessful) {
            LOG.error("Can't require[" + size + "] for read data, current[" + this.readDataMemory.get() + "], capacity[" + this.readCapacity + "]");
            ShuffleServerMetrics.counterTotalRequireReadMemoryRetryNum.inc();
            ShuffleServerMetrics.counterTotalRequireReadMemoryFailedNum.inc();
        }
        return isSuccessful;
    }

    public void releaseReadMemory(long size) {
        if (this.readDataMemory.get() >= size) {
            this.readDataMemory.addAndGet(-size);
            ShuffleServerMetrics.gaugeReadBufferUsedSize.dec((double)size);
        } else {
            LOG.warn("Current read memory[" + this.readDataMemory.get() + "] is less than released[" + size + "], set read memory to 0");
            this.readDataMemory.set(0L);
            ShuffleServerMetrics.gaugeReadBufferUsedSize.set(0.0);
        }
    }

    public synchronized void flush(Map<String, Set<Integer>> requiredFlush) {
        for (Map.Entry<String, Map<Integer, RangeMap<Integer, ShuffleBuffer>>> appIdToBuffers : this.bufferPool.entrySet()) {
            String appId = appIdToBuffers.getKey();
            if (!requiredFlush.containsKey(appId)) continue;
            for (Map.Entry<Integer, RangeMap<Integer, ShuffleBuffer>> shuffleIdToBuffers : appIdToBuffers.getValue().entrySet()) {
                int shuffleId = shuffleIdToBuffers.getKey();
                Set<Integer> requiredShuffleId = requiredFlush.get(appId);
                if (requiredShuffleId == null || !requiredShuffleId.contains(shuffleId)) continue;
                for (Map.Entry<Range<Integer>, ShuffleBuffer> rangeEntry : shuffleIdToBuffers.getValue().asMapOfRanges().entrySet()) {
                    Range<Integer> range = rangeEntry.getKey();
                    this.flushBuffer(rangeEntry.getValue(), appId, shuffleId, range.lowerEndpoint(), range.upperEndpoint(), this.isHugePartition(appId, shuffleId, range.lowerEndpoint()));
                }
            }
        }
    }

    public void updateUsedMemory(long delta) {
        this.usedMemory.addAndGet(delta);
        ShuffleServerMetrics.gaugeUsedBufferSize.set((double)this.usedMemory.get());
    }

    void requirePreAllocatedSize(long delta) {
        this.preAllocatedSize.addAndGet(delta);
        ShuffleServerMetrics.gaugeAllocatedBufferSize.set((double)this.preAllocatedSize.get());
    }

    public void releasePreAllocatedSize(long delta) {
        if (this.preAllocatedSize.get() >= delta) {
            this.preAllocatedSize.addAndGet(-delta);
        } else {
            LOG.warn("Current pre-allocated memory[" + this.preAllocatedSize.get() + "] is less than released[" + delta + "], set pre-allocated memory to 0");
            this.preAllocatedSize.set(0L);
        }
        ShuffleServerMetrics.gaugeAllocatedBufferSize.set((double)this.preAllocatedSize.get());
    }

    boolean isFull() {
        return this.usedMemory.get() >= this.capacity;
    }

    @VisibleForTesting
    public Map<String, Map<Integer, RangeMap<Integer, ShuffleBuffer>>> getBufferPool() {
        return this.bufferPool;
    }

    @VisibleForTesting
    public ShuffleBuffer getShuffleBuffer(String appId, int shuffleId, int partitionId) {
        return this.getShuffleBufferEntry(appId, shuffleId, partitionId).getValue();
    }

    public long getUsedMemory() {
        return this.usedMemory.get();
    }

    public long getInFlushSize() {
        return this.inFlushSize.get();
    }

    public long getCapacity() {
        return this.capacity;
    }

    @VisibleForTesting
    public long getReadCapacity() {
        return this.readCapacity;
    }

    @VisibleForTesting
    public void resetSize() {
        this.usedMemory = new AtomicLong(0L);
        this.preAllocatedSize = new AtomicLong(0L);
        this.inFlushSize = new AtomicLong(0L);
    }

    @VisibleForTesting
    public Map<String, Map<Integer, AtomicLong>> getShuffleSizeMap() {
        return this.shuffleSizeMap;
    }

    public long getPreAllocatedSize() {
        return this.preAllocatedSize.get();
    }

    private Map<String, Set<Integer>> pickFlushedShuffle() {
        List<Map.Entry<String, AtomicLong>> sizeList = this.generateSizeList();
        sizeList.sort((entry1, entry2) -> {
            if (entry1 == null && entry2 == null) {
                return 0;
            }
            if (entry1 == null) {
                return 1;
            }
            if (entry2 == null) {
                return -1;
            }
            if (((AtomicLong)entry1.getValue()).get() > ((AtomicLong)entry2.getValue()).get()) {
                return -1;
            }
            if (((AtomicLong)entry1.getValue()).get() == ((AtomicLong)entry2.getValue()).get()) {
                return 0;
            }
            return 1;
        });
        HashMap<String, Set<Integer>> pickedShuffle = Maps.newHashMap();
        long expectedFlushSize = this.highWaterMark - this.lowWaterMark;
        long atLeastFlushSizeIgnoreThreshold = expectedFlushSize >>> 1;
        long pickedFlushSize = 0L;
        int printIndex = 0;
        int printIgnoreIndex = 0;
        int printMax = 10;
        for (Map.Entry<String, AtomicLong> entry : sizeList) {
            long size = entry.getValue().get();
            String appIdShuffleIdKey = entry.getKey();
            if (size > this.shuffleFlushThreshold || pickedFlushSize <= atLeastFlushSizeIgnoreThreshold) {
                pickedFlushSize += size;
                this.addPickedShuffle(appIdShuffleIdKey, pickedShuffle);
                if (printIndex < printMax) {
                    LOG.info("Pick application_shuffleId[{}] with {} bytes", (Object)appIdShuffleIdKey, (Object)size);
                    ++printIndex;
                }
                if (pickedFlushSize <= expectedFlushSize) continue;
                LOG.info("Finish flush pick with {} bytes", (Object)pickedFlushSize);
                break;
            }
            if (printIgnoreIndex >= printMax) break;
            LOG.info("Ignore application_shuffleId[{}] with {} bytes", (Object)appIdShuffleIdKey, (Object)size);
            ++printIgnoreIndex;
        }
        return pickedShuffle;
    }

    private List<Map.Entry<String, AtomicLong>> generateSizeList() {
        HashMap<String, AtomicLong> sizeMap = Maps.newHashMap();
        for (Map.Entry<String, Map<Integer, AtomicLong>> appEntry : this.shuffleSizeMap.entrySet()) {
            String appId = appEntry.getKey();
            for (Map.Entry<Integer, AtomicLong> shuffleEntry : appEntry.getValue().entrySet()) {
                Integer shuffleId = shuffleEntry.getKey();
                sizeMap.put(RssUtils.generateShuffleKey((String)appId, (int)shuffleId), shuffleEntry.getValue());
            }
        }
        return Lists.newArrayList(sizeMap.entrySet());
    }

    private void addPickedShuffle(String shuffleIdKey, Map<String, Set<Integer>> pickedShuffle) {
        String[] splits = shuffleIdKey.split("/");
        String appId = splits[0];
        Integer shuffleId = Integer.parseInt(splits[1]);
        pickedShuffle.computeIfAbsent(appId, key -> Sets.newHashSet());
        Set<Integer> shuffleIdSet = pickedShuffle.get(appId);
        shuffleIdSet.add(shuffleId);
    }

    public void removeBufferByShuffleId(String appId, Collection<Integer> shuffleIds) {
        Map<Integer, RangeMap<Integer, ShuffleBuffer>> shuffleIdToBuffers = this.bufferPool.get(appId);
        if (shuffleIdToBuffers == null) {
            return;
        }
        Map<Integer, AtomicLong> shuffleIdToSizeMap = this.shuffleSizeMap.get(appId);
        for (int shuffleId : shuffleIds) {
            long size = 0L;
            RangeMap<Integer, ShuffleBuffer> bufferRangeMap = shuffleIdToBuffers.remove(shuffleId);
            if (bufferRangeMap == null) continue;
            Collection<ShuffleBuffer> buffers = bufferRangeMap.asMapOfRanges().values();
            if (buffers != null) {
                for (ShuffleBuffer buffer : buffers) {
                    buffer.getBlocks().forEach(spb -> spb.getData().release());
                    ShuffleServerMetrics.gaugeTotalPartitionNum.dec();
                    size += buffer.getSize();
                }
            }
            this.releaseMemory(size, false, false);
            if (shuffleIdToSizeMap == null) continue;
            shuffleIdToSizeMap.remove(shuffleId);
        }
    }

    boolean isHugePartition(String appId, int shuffleId, int partitionId) {
        return this.shuffleTaskManager != null && this.shuffleTaskManager.getPartitionDataSize(appId, shuffleId, partitionId) > this.hugePartitionSizeThreshold;
    }

    public boolean isHugePartition(long usedPartitionDataSize) {
        return usedPartitionDataSize > this.hugePartitionSizeThreshold;
    }

    public boolean limitHugePartition(String appId, int shuffleId, int partitionId, long usedPartitionDataSize) {
        long memoryUsed;
        if (usedPartitionDataSize > this.hugePartitionSizeThreshold && (memoryUsed = this.getShuffleBufferEntry(appId, shuffleId, partitionId).getValue().getSize()) > this.hugePartitionMemoryLimitSize) {
            LOG.warn("AppId: {}, shuffleId: {}, partitionId: {}, memory used: {}, huge partition triggered memory limitation.", new Object[]{appId, shuffleId, partitionId, memoryUsed});
            return true;
        }
        return false;
    }
}

