/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.segment;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.ShuffleDataSegment;
import org.apache.uniffle.common.ShuffleIndexResult;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.segment.SegmentSplitter;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalOrderSegmentSplitter
implements SegmentSplitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalOrderSegmentSplitter.class);
    private Roaring64NavigableMap expectTaskIds;
    private int readBufferSize;

    public LocalOrderSegmentSplitter(Roaring64NavigableMap expectTaskIds, int readBufferSize) {
        this.expectTaskIds = expectTaskIds;
        this.readBufferSize = readBufferSize;
    }

    @Override
    public List<ShuffleDataSegment> split(ShuffleIndexResult shuffleIndexResult) {
        if (shuffleIndexResult == null || shuffleIndexResult.isEmpty()) {
            return Lists.newArrayList();
        }
        ByteBuffer indexData = shuffleIndexResult.getIndexData();
        long dataFileLen = shuffleIndexResult.getDataFileLen();
        ArrayList<BufferSegment> bufferSegments = Lists.newArrayList();
        ArrayList<ShuffleDataSegment> dataFileSegments = Lists.newArrayList();
        int bufferOffset = 0;
        long fileOffset = -1L;
        long totalLen = 0L;
        long lastExpectedBlockIndex = -1L;
        ArrayList<Long> indexTaskIds = new ArrayList<Long>();
        int index = 0;
        while (indexData.hasRemaining()) {
            try {
                boolean conditionOfLimitedBufferSize;
                long offset = indexData.getLong();
                int length = indexData.getInt();
                int uncompressLength = indexData.getInt();
                long crc = indexData.getLong();
                long blockId = indexData.getLong();
                long taskAttemptId = indexData.getLong();
                indexTaskIds.add(taskAttemptId);
                if (dataFileLen != -1L && (totalLen += (long)length) > dataFileLen) {
                    LOGGER.info("Abort inconsistent data, the data length: {}(bytes) recorded in index file is greater than the real data file length: {}(bytes). Block id: {}. This should not happen. This may happen when the data is flushing, please ignore.", new Object[]{totalLen, dataFileLen, blockId});
                    break;
                }
                boolean conditionOfDiscontinuousBlocks = lastExpectedBlockIndex != -1L && bufferSegments.size() > 0 && this.expectTaskIds.contains(taskAttemptId) && (long)index - lastExpectedBlockIndex != 1L;
                boolean bl = conditionOfLimitedBufferSize = bufferOffset >= this.readBufferSize;
                if (conditionOfDiscontinuousBlocks || conditionOfLimitedBufferSize) {
                    ShuffleDataSegment sds = new ShuffleDataSegment(fileOffset, bufferOffset, bufferSegments);
                    dataFileSegments.add(sds);
                    bufferSegments = Lists.newArrayList();
                    bufferOffset = 0;
                    fileOffset = -1L;
                }
                if (this.expectTaskIds.contains(taskAttemptId)) {
                    if (fileOffset == -1L) {
                        fileOffset = offset;
                    }
                    bufferSegments.add(new BufferSegment(blockId, bufferOffset, length, uncompressLength, crc, taskAttemptId));
                    bufferOffset += length;
                    lastExpectedBlockIndex = index;
                }
                ++index;
            }
            catch (BufferUnderflowException ue) {
                throw new RssException("Read index data under flow", ue);
            }
        }
        if (bufferOffset > 0) {
            ShuffleDataSegment sds = new ShuffleDataSegment(fileOffset, bufferOffset, bufferSegments);
            dataFileSegments.add(sds);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Index file task-ids sequence: {}, expected task-ids: {}", indexTaskIds, this.getExpectedTaskIds(this.expectTaskIds));
        }
        return dataFileSegments;
    }

    private List<Long> getExpectedTaskIds(Roaring64NavigableMap expectTaskIds) {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        expectTaskIds.forEach(value -> taskIds.add(value));
        return taskIds;
    }
}

