/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

final class IDContext {
    private static final int INITIAL_MATCH_SIZE = 16;
    private int[] fElementIDTable = new int[16];
    private int fIDDepth = 0;
    private int fIDScope = 0;
    private int fElementScope = -1;
    private int fElementDepth = 0;
    private final int fTableSize = 101;
    private final Entry[] fBuckets = new Entry[101];
    private int fNum = 0;

    IDContext() {
    }

    void clear() {
        if (this.fNum > 0) {
            for (int i = 0; i < 101; ++i) {
                this.fBuckets[i] = null;
            }
        }
        this.fNum = 0;
        this.fIDDepth = 0;
        this.fElementDepth = 0;
        this.fIDScope = -1;
        this.fElementScope = -1;
    }

    void setCurrentScopeToParent() {
        if (this.fElementScope > 0) {
            this.fIDScope = this.fElementIDTable[--this.fElementScope];
        } else {
            this.fIDScope = -1;
            this.fElementScope = -1;
        }
    }

    void popContext() {
        --this.fElementDepth;
    }

    void pushContext() {
        if (this.fElementDepth == this.fElementIDTable.length) {
            this.resizeElementDepthIDTable();
        }
        this.fElementScope = this.fElementDepth++;
        this.fIDScope = 0;
        this.fElementIDTable[this.fElementScope] = 0;
    }

    private void resizeElementDepthIDTable() {
        int n = this.fElementDepth << 1;
        int[] nArray = new int[n];
        System.arraycopy(this.fElementIDTable, 0, nArray, 0, this.fElementDepth);
        this.fElementIDTable = nArray;
    }

    boolean isDeclared(String string) {
        int n = this.get(string);
        if (n == -1) {
            return this.fIDScope == -1;
        }
        return n != this.fIDScope;
    }

    boolean containsID(String string) {
        int n = (string.hashCode() & Integer.MAX_VALUE) % 101;
        Entry entry = this.fBuckets[n];
        while (entry != null) {
            if (string.equals(entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    private int get(String string) {
        int n = (string.hashCode() & Integer.MAX_VALUE) % 101;
        Entry entry = this.fBuckets[n];
        while (entry != null) {
            if (string.equals(entry.key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return -1;
    }

    void add(String string) {
        int n = (string.hashCode() & Integer.MAX_VALUE) % 101;
        Entry entry = this.search(string, n);
        if (entry == null) {
            if (this.fElementIDTable[this.fElementScope] == 0) {
                this.fIDScope = ++this.fIDDepth;
                this.fElementIDTable[this.fElementScope] = this.fIDDepth;
            }
            this.fBuckets[n] = entry = new Entry(string, this.fIDScope, this.fBuckets[n]);
            ++this.fNum;
        }
    }

    private Entry search(String string, int n) {
        Entry entry = this.fBuckets[n];
        while (entry != null) {
            if (string.equals(entry.key)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    private static final class Entry {
        public String key;
        public int value;
        public Entry next;

        public Entry() {
            this.key = null;
            this.value = -1;
            this.next = null;
        }

        public Entry(String string, int n, Entry entry) {
            this.key = string;
            this.value = n;
            this.next = entry;
        }
    }
}

