/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.regex.Matcher;
import org.eclipse.wst.xml.xpath2.processor.regex.Pattern;

public abstract class AbstractRegExFunction
extends Function {
    private static final String validflags = "smix";

    public AbstractRegExFunction(QName name, int arity) {
        super(name, arity);
    }

    public AbstractRegExFunction(QName name, int min_arity, int max_arity) {
        super(name, min_arity, max_arity);
    }

    protected static String trfPatternStrForSubtraction(String pattern) {
        String transformedPatternStr = pattern;
        int indx1 = transformedPatternStr.indexOf("-[");
        if (indx1 != -1) {
            String subsPrev = transformedPatternStr.substring(0, indx1);
            String subsAfter = transformedPatternStr.substring(indx1 + 2);
            if (subsPrev.indexOf("[") != -1 && subsAfter.indexOf("]]") != -1) {
                transformedPatternStr = transformedPatternStr.replaceAll("\\-\\[", "&&[^");
            }
        }
        return transformedPatternStr;
    }

    protected static Matcher regex(String pattern, String flags, String src) {
        Matcher matcher = AbstractRegExFunction.compileAndExecute(pattern, flags, src);
        return matcher;
    }

    protected static boolean isFlagStrValid(String flags) {
        boolean flagStrValid = true;
        if (flags.length() > 0) {
            int idx = 0;
            while (idx < flags.length()) {
                if (validflags.indexOf(flags.charAt(idx)) == -1) {
                    flagStrValid = false;
                    break;
                }
                ++idx;
            }
        }
        return flagStrValid;
    }

    private static Matcher compileAndExecute(String pattern, String flags, String src) {
        int flag = 1;
        if (flags != null) {
            if (flags.indexOf("m") >= 0) {
                flag |= 8;
            }
            if (flags.indexOf("s") >= 0) {
                flag |= 0x20;
            }
            if (flags.indexOf("i") >= 0) {
                flag |= 2;
            }
            if (flags.indexOf("x") >= 0) {
                flag |= 4;
            }
        }
        Pattern p = Pattern.compile(pattern, flag);
        return p.matcher(src);
    }
}

