Engine.LoadLibrary("rmgen");
Engine.LoadLibrary("rmgen-common");

function* GenerateMap()
{
	const tPrimary = "temp_grass_long";
	const tGrass = ["temp_grass", "temp_grass", "temp_grass_d"];
	const tGrassPForest = "temp_plants_bog";
	const tGrassDForest = "temp_plants_bog";
	const tGrassA = "temp_grass_plants";
	const tGrassB = "temp_plants_bog";
	const tGrassC = "temp_mud_a";
	const tRoad = "temp_road";
	const tRoadWild = "temp_road_overgrown";
	const tGrassPatchBlend = "temp_grass_long_b";
	const tGrassPatch = ["temp_grass_d", "temp_grass_clovers"];
	const tShore = "temp_plants_bog";
	const tWater = "temp_mud_a";

	const oBeech = "gaia/tree/euro_beech";
	const oOak = "gaia/tree/oak";
	const oBerryBush = "gaia/fruit/berry_01";
	const oDeer = "gaia/fauna_deer";
	const oRabbit = "gaia/fauna_rabbit";
	const oStoneLarge = "gaia/rock/temperate_large";
	const oStoneSmall = "gaia/rock/temperate_small";
	const oMetalLarge = "gaia/ore/temperate_large";

	const aGrass = "actor|props/flora/grass_soft_small_tall.xml";
	const aGrassShort = "actor|props/flora/grass_soft_large.xml";
	const aRockLarge = "actor|geology/stone_granite_med.xml";
	const aRockMedium = "actor|geology/stone_granite_med.xml";
	const aReeds = "actor|props/flora/reeds_pond_lush_a.xml";
	const aLillies = "actor|props/flora/water_lillies.xml";
	const aBushMedium = "actor|props/flora/bush_medit_me.xml";
	const aBushSmall = "actor|props/flora/bush_medit_sm.xml";

	const pForestB = [tGrassDForest + TERRAIN_SEPARATOR + oBeech, tGrassDForest];
	const pForestO = [tGrassPForest + TERRAIN_SEPARATOR + oOak, tGrassPForest];
	const pForestR = [
		tGrassDForest + TERRAIN_SEPARATOR + oBeech,
		tGrassDForest,
		tGrassDForest + TERRAIN_SEPARATOR + oOak,
		tGrassDForest,
		tGrassDForest,
		tGrassDForest
	];

	const heightSeaGround = -4;
	const heightShallows = -2;
	const heightLand = 3;
	const heightOffsetBump = 2;

	globalThis.g_Map = new RandomMap(heightLand, tPrimary);

	const numPlayers = getNumPlayers();
	const mapSize = g_Map.getSize();
	const mapCenter = g_Map.getCenter();
	const mapBounds = g_Map.getBounds();

	const clPlayer = g_Map.createTileClass();
	const clHill = g_Map.createTileClass();
	const clForest = g_Map.createTileClass();
	const clWater = g_Map.createTileClass();
	const clDirt = g_Map.createTileClass();
	const clRock = g_Map.createTileClass();
	const clMetal = g_Map.createTileClass();
	const clFood = g_Map.createTileClass();
	const clBaseResource = g_Map.createTileClass();
	const clShallow = g_Map.createTileClass();

	const shallowWidth = scaleByMapSize(8, 12);

	const startAngle = randomAngle();

	placePlayerBases({
		"PlayerPlacement": playerPlacementRiver(startAngle + Math.PI / 2, fractionToTiles(0.5)),
		// PlayerTileClass marked below
		"BaseResourceClass": clBaseResource,
		"Walls": "towers",
		"CityPatch": {
			"outerTerrain": tRoadWild,
			"innerTerrain": tRoad,
			"painters": [
				new TileClassPainter(clPlayer)
			]
		},
		"StartingAnimal": {
		},
		"Berries": {
			"template": oBerryBush
		},
		"Mines": {
			"types": [
				{ "template": oMetalLarge },
				{ "template": oStoneLarge }
			]
		},
		"Trees": {
			"template": oOak,
			"count": 3
		},
		"Decoratives": {
			"template": aGrassShort
		}
	});
	yield 20;

	const riverPositions = [
		new Vector2D(mapBounds.left + 1, mapCenter.y),
		new Vector2D(mapBounds.right - 1, mapCenter.y)
	].map(v => v.rotateAround(startAngle, mapCenter));

	g_Map.log("Creating the main river");
	createArea(
		new PathPlacer(riverPositions[0], riverPositions[1], scaleByMapSize(10, 20), 0.5,
			scaleByMapSize(0.5, 2), 0.1, 0.01),
		new SmoothElevationPainter(ELEVATION_SET, heightSeaGround, 4),
		avoidClasses(clPlayer, 4));
	yield 25;

	g_Map.log("Creating small puddles at the map border to ensure players being separated");
	for (const riverPosition of riverPositions)
		createArea(
			new ClumpPlacer(diskArea(scaleByMapSize(5, 10)), 0.95, 0.6, Infinity, riverPosition),
			new SmoothElevationPainter(ELEVATION_SET, heightSeaGround, 2),
			avoidClasses(clPlayer, 8));
	yield 30;

	g_Map.log("Creating the shallows of the main river");
	for (let i = 0; i <= randIntInclusive(3, scaleByMapSize(4, 6)); ++i)
	{
		const location = fractionToTiles(randFloat(0.15, 0.85));
		createPassage({
			"start": new Vector2D(location, mapBounds.top).rotateAround(startAngle, mapCenter),
			"end": new Vector2D(location, mapBounds.bottom).rotateAround(startAngle, mapCenter),
			"startWidth": shallowWidth,
			"endWidth": shallowWidth,
			"smoothWidth": 2,
			"startHeight": heightShallows,
			"endHeight": heightShallows,
			"constraints": new HeightConstraint(-Infinity, heightShallows),
			"tileClass": clShallow
		});
	}
	yield 35;

	createTributaryRivers(
		startAngle,
		randIntInclusive(9, scaleByMapSize(13, 21)),
		scaleByMapSize(10, 20),
		heightSeaGround,
		[-6, -1.5],
		Math.PI / 5,
		clWater,
		clShallow,
		avoidClasses(clPlayer, 3, clBaseResource, 4));

	yield 40;

	paintTerrainBasedOnHeight(-5, 1, 1, tWater);
	paintTerrainBasedOnHeight(1, 2, 1, pForestR);
	paintTileClassBasedOnHeight(-6, 0.5, 1, clWater);

	yield 50;

	g_Map.log("Creating bumps");
	createAreas(
		new ClumpPlacer(scaleByMapSize(20, 50), 0.3, 0.06, Infinity),
		new SmoothElevationPainter(ELEVATION_MODIFY, heightOffsetBump, 2),
		avoidClasses(clWater, 2, clPlayer, 15),
		scaleByMapSize(100, 200)
	);
	yield 55;

	const [forestTrees, stragglerTrees] = getTreeCounts(500, 2500, 0.7);
	createForests(
		[tGrass, tGrassDForest, tGrassPForest, pForestB, pForestO],
		avoidClasses(clPlayer, 15, clWater, 3, clForest, 16, clHill, 1),
		clForest,
		forestTrees);
	yield 70;

	g_Map.log("Creating dirt patches");
	for (const size of [scaleByMapSize(3, 6), scaleByMapSize(5, 10), scaleByMapSize(8, 21)])
		createAreas(
			new ChainPlacer(1, Math.floor(scaleByMapSize(3, 5)), size, 0.5),
			[
				new LayeredPainter([[tGrass, tGrassA], tGrassB, [tGrassB, tGrassC]], [1, 1]),
				new TileClassPainter(clDirt)
			],
			avoidClasses(clWater, 1, clForest, 0, clHill, 0, clDirt, 5, clPlayer, 6),
			scaleByMapSize(15, 45)
		);

	g_Map.log("Creating grass patches");
	for (const size of [scaleByMapSize(2, 4), scaleByMapSize(3, 7), scaleByMapSize(5, 15)])
		createAreas(
			new ChainPlacer(1, Math.floor(scaleByMapSize(3, 5)), size, 0.5),
			new LayeredPainter([tGrassPatchBlend, tGrassPatch], [1]),
			avoidClasses(clWater, 1, clForest, 0, clHill, 0, clDirt, 5, clPlayer, 6),
			scaleByMapSize(15, 45)
		);
	yield 80;

	g_Map.log("Creating stone mines");
	let group = new SimpleGroup(
		[
			new SimpleObject(oStoneSmall, 0, 2, 0, 4, 0, 2 * Math.PI, 1),
			new SimpleObject(oStoneLarge, 1, 1, 0, 4, 0, 2 * Math.PI, 4)
		], true, clRock);
	createObjectGroupsDeprecated(group, 0,
		[avoidClasses(clWater, 0, clForest, 1, clPlayer, 15, clRock, 10, clHill, 1)],
		scaleByMapSize(4, 16), 100
	);

	g_Map.log("Creating small stone quarries");
	group = new SimpleGroup([new SimpleObject(oStoneSmall, 2, 5, 1, 3)], true, clRock);
	createObjectGroupsDeprecated(group, 0,
		[avoidClasses(clWater, 0, clForest, 1, clPlayer, 15, clRock, 10, clHill, 1)],
		scaleByMapSize(4, 16), 100
	);

	g_Map.log("Creating metal mines");
	group = new SimpleGroup([new SimpleObject(oMetalLarge, 1, 1, 0, 4)], true, clMetal);
	createObjectGroupsDeprecated(group, 0,
		[avoidClasses(clWater, 0, clForest, 1, clPlayer, 15, clMetal, 10, clRock, 5, clHill, 1)],
		scaleByMapSize(4, 16), 100
	);

	yield 86;

	g_Map.log("Creating small decorative rocks");
	group = new SimpleGroup(
		[new SimpleObject(aRockMedium, 1, 3, 0, 1)],
		true
	);
	createObjectGroupsDeprecated(
		group, 0,
		avoidClasses(clWater, 0, clForest, 0, clPlayer, 0, clHill, 0),
		scaleByMapSize(16, 262), 50
	);

	g_Map.log("Creating large decorative rocks");
	group = new SimpleGroup(
		[new SimpleObject(aRockLarge, 1, 2, 0, 1), new SimpleObject(aRockMedium, 1, 3, 0, 2)],
		true
	);
	createObjectGroupsDeprecated(
		group, 0,
		avoidClasses(clWater, 0, clForest, 0, clPlayer, 0, clHill, 0),
		scaleByMapSize(8, 131), 50
	);

	g_Map.log("Creating deer");
	group = new SimpleGroup(
		[new SimpleObject(oDeer, 5, 7, 0, 4)],
		true, clFood
	);
	createObjectGroupsDeprecated(group, 0,
		avoidClasses(clWater, 0, clForest, 0, clPlayer, 15, clHill, 1, clFood, 20),
		3 * numPlayers, 50
	);

	g_Map.log("Creating rabbits");
	group = new SimpleGroup(
		[new SimpleObject(oRabbit, 2, 3, 0, 2)],
		true, clFood
	);
	createObjectGroupsDeprecated(group, 0,
		avoidClasses(clWater, 0, clForest, 0, clPlayer, 15, clHill, 1, clFood, 20),
		3 * numPlayers, 50
	);

	g_Map.log("Creating berry bush");
	group = new SimpleGroup(
		[new SimpleObject(oBerryBush, 5, 7, 0, 4)],
		true, clFood
	);
	createObjectGroupsDeprecated(group, 0,
		avoidClasses(clWater, 3, clForest, 0, clPlayer, 15, clHill, 1, clFood, 10),
		randIntInclusive(1, 4) * numPlayers + 2, 50
	);

	createStragglerTrees(
		[oOak, oBeech],
		avoidClasses(clWater, 1, clForest, 7, clHill, 1, clPlayer, 5, clMetal, 6, clRock, 6),
		clForest,
		stragglerTrees);

	g_Map.log("Creating small grass tufts");
	group = new SimpleGroup(
		[new SimpleObject(aGrassShort, 1, 2, 0, 1, -Math.PI / 8, Math.PI / 8)]
	);
	createObjectGroupsDeprecated(group, 0,
		avoidClasses(clWater, 2, clHill, 2, clPlayer, 2, clDirt, 0),
		scaleByMapSize(13, 200)
	);

	g_Map.log("Creating large grass tufts");
	group = new SimpleGroup(
		[
			new SimpleObject(aGrass, 2, 4, 0, 1.8, -Math.PI / 8, Math.PI / 8),
			new SimpleObject(aGrassShort, 3, 6, 1.2, 2.5, -Math.PI / 8, Math.PI / 8)
		]
	);
	createObjectGroupsDeprecated(group, 0,
		avoidClasses(clWater, 3, clHill, 2, clPlayer, 2, clDirt, 1, clForest, 0),
		scaleByMapSize(13, 200)
	);

	g_Map.log("Creating bushes");
	group = new SimpleGroup(
		[new SimpleObject(aBushMedium, 1, 2, 0, 2), new SimpleObject(aBushSmall, 2, 4, 0, 2)]
	);
	createObjectGroupsDeprecated(group, 0,
		avoidClasses(clWater, 1, clHill, 1, clPlayer, 1, clDirt, 1),
		scaleByMapSize(13, 200), 50
	);

	g_Map.log("Creating shallow flora");
	group = new SimpleGroup(
		[new SimpleObject(aLillies, 1, 2, 0, 2), new SimpleObject(aReeds, 2, 4, 0, 2)]
	);
	createObjectGroupsDeprecated(group, 0,
		stayClasses(clShallow, 1),
		60 * scaleByMapSize(13, 200), 80
	);

	placePlayersNomad(clPlayer,
		avoidClasses(clWater, 4, clForest, 1, clMetal, 4, clRock, 4, clHill, 4, clFood, 2));

	setSkySet("cirrus");
	setWaterColor(0.1, 0.212, 0.422);
	setWaterTint(0.3, 0.1, 0.949);
	setWaterWaviness(3.0);
	setWaterType("lake");
	setWaterMurkiness(0.80);

	return g_Map;
}
