﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanrooms/CleanRooms_EXPORTS.h>
#include <aws/cleanrooms/model/ConfiguredTableAssociationAnalysisRuleType.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CleanRooms {
namespace Model {

/**
 * <p>A configured table association links a configured table to a
 * collaboration.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ConfiguredTableAssociation">AWS
 * API Reference</a></p>
 */
class ConfiguredTableAssociation {
 public:
  AWS_CLEANROOMS_API ConfiguredTableAssociation() = default;
  AWS_CLEANROOMS_API ConfiguredTableAssociation(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLEANROOMS_API ConfiguredTableAssociation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLEANROOMS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The unique ARN for the configured table association.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  ConfiguredTableAssociation& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ID for the configured table association.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  ConfiguredTableAssociation& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ID for the configured table that the association refers to.</p>
   */
  inline const Aws::String& GetConfiguredTableId() const { return m_configuredTableId; }
  inline bool ConfiguredTableIdHasBeenSet() const { return m_configuredTableIdHasBeenSet; }
  template <typename ConfiguredTableIdT = Aws::String>
  void SetConfiguredTableId(ConfiguredTableIdT&& value) {
    m_configuredTableIdHasBeenSet = true;
    m_configuredTableId = std::forward<ConfiguredTableIdT>(value);
  }
  template <typename ConfiguredTableIdT = Aws::String>
  ConfiguredTableAssociation& WithConfiguredTableId(ConfiguredTableIdT&& value) {
    SetConfiguredTableId(std::forward<ConfiguredTableIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ARN for the configured table that the association refers to.</p>
   */
  inline const Aws::String& GetConfiguredTableArn() const { return m_configuredTableArn; }
  inline bool ConfiguredTableArnHasBeenSet() const { return m_configuredTableArnHasBeenSet; }
  template <typename ConfiguredTableArnT = Aws::String>
  void SetConfiguredTableArn(ConfiguredTableArnT&& value) {
    m_configuredTableArnHasBeenSet = true;
    m_configuredTableArn = std::forward<ConfiguredTableArnT>(value);
  }
  template <typename ConfiguredTableArnT = Aws::String>
  ConfiguredTableAssociation& WithConfiguredTableArn(ConfiguredTableArnT&& value) {
    SetConfiguredTableArn(std::forward<ConfiguredTableArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ID for the membership this configured table association belongs
   * to.</p>
   */
  inline const Aws::String& GetMembershipId() const { return m_membershipId; }
  inline bool MembershipIdHasBeenSet() const { return m_membershipIdHasBeenSet; }
  template <typename MembershipIdT = Aws::String>
  void SetMembershipId(MembershipIdT&& value) {
    m_membershipIdHasBeenSet = true;
    m_membershipId = std::forward<MembershipIdT>(value);
  }
  template <typename MembershipIdT = Aws::String>
  ConfiguredTableAssociation& WithMembershipId(MembershipIdT&& value) {
    SetMembershipId(std::forward<MembershipIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ARN for the membership this configured table association belongs
   * to.</p>
   */
  inline const Aws::String& GetMembershipArn() const { return m_membershipArn; }
  inline bool MembershipArnHasBeenSet() const { return m_membershipArnHasBeenSet; }
  template <typename MembershipArnT = Aws::String>
  void SetMembershipArn(MembershipArnT&& value) {
    m_membershipArnHasBeenSet = true;
    m_membershipArn = std::forward<MembershipArnT>(value);
  }
  template <typename MembershipArnT = Aws::String>
  ConfiguredTableAssociation& WithMembershipArn(MembershipArnT&& value) {
    SetMembershipArn(std::forward<MembershipArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The service will assume this role to access catalog metadata and query the
   * table.</p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  inline bool RoleArnHasBeenSet() const { return m_roleArnHasBeenSet; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  ConfiguredTableAssociation& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the configured table association, in lowercase. The table is
   * identified by this name when running protected queries against the underlying
   * data.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  ConfiguredTableAssociation& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description of the configured table association.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  ConfiguredTableAssociation& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The analysis rule types for the configured table association.</p>
   */
  inline const Aws::Vector<ConfiguredTableAssociationAnalysisRuleType>& GetAnalysisRuleTypes() const { return m_analysisRuleTypes; }
  inline bool AnalysisRuleTypesHasBeenSet() const { return m_analysisRuleTypesHasBeenSet; }
  template <typename AnalysisRuleTypesT = Aws::Vector<ConfiguredTableAssociationAnalysisRuleType>>
  void SetAnalysisRuleTypes(AnalysisRuleTypesT&& value) {
    m_analysisRuleTypesHasBeenSet = true;
    m_analysisRuleTypes = std::forward<AnalysisRuleTypesT>(value);
  }
  template <typename AnalysisRuleTypesT = Aws::Vector<ConfiguredTableAssociationAnalysisRuleType>>
  ConfiguredTableAssociation& WithAnalysisRuleTypes(AnalysisRuleTypesT&& value) {
    SetAnalysisRuleTypes(std::forward<AnalysisRuleTypesT>(value));
    return *this;
  }
  inline ConfiguredTableAssociation& AddAnalysisRuleTypes(ConfiguredTableAssociationAnalysisRuleType value) {
    m_analysisRuleTypesHasBeenSet = true;
    m_analysisRuleTypes.push_back(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the configured table association was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreateTime() const { return m_createTime; }
  inline bool CreateTimeHasBeenSet() const { return m_createTimeHasBeenSet; }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  void SetCreateTime(CreateTimeT&& value) {
    m_createTimeHasBeenSet = true;
    m_createTime = std::forward<CreateTimeT>(value);
  }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  ConfiguredTableAssociation& WithCreateTime(CreateTimeT&& value) {
    SetCreateTime(std::forward<CreateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the configured table association was last updated.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdateTime() const { return m_updateTime; }
  inline bool UpdateTimeHasBeenSet() const { return m_updateTimeHasBeenSet; }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  void SetUpdateTime(UpdateTimeT&& value) {
    m_updateTimeHasBeenSet = true;
    m_updateTime = std::forward<UpdateTimeT>(value);
  }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  ConfiguredTableAssociation& WithUpdateTime(UpdateTimeT&& value) {
    SetUpdateTime(std::forward<UpdateTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::String m_id;

  Aws::String m_configuredTableId;

  Aws::String m_configuredTableArn;

  Aws::String m_membershipId;

  Aws::String m_membershipArn;

  Aws::String m_roleArn;

  Aws::String m_name;

  Aws::String m_description;

  Aws::Vector<ConfiguredTableAssociationAnalysisRuleType> m_analysisRuleTypes;

  Aws::Utils::DateTime m_createTime{};

  Aws::Utils::DateTime m_updateTime{};
  bool m_arnHasBeenSet = false;
  bool m_idHasBeenSet = false;
  bool m_configuredTableIdHasBeenSet = false;
  bool m_configuredTableArnHasBeenSet = false;
  bool m_membershipIdHasBeenSet = false;
  bool m_membershipArnHasBeenSet = false;
  bool m_roleArnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_analysisRuleTypesHasBeenSet = false;
  bool m_createTimeHasBeenSet = false;
  bool m_updateTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace CleanRooms
}  // namespace Aws
