---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token EasyPost test API key'
---

## Description

The response body contains content that matches the pattern of an EasyPost test API key was identified. Test API keys are used for functionality testing. A malicious actor with access to this key can only use limited functionality of the EasyPost service.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke the identified API token:

- Sign in to your account and go to the settings page <https://www.easypost.com/account/settings>
- Under the "Test API Keys", select the "Status" checkbox to disable the key
- In the "Are you sure you want to disable this key?" dialog, select "Disable"
- In the "Status" checkbox area, select the trash can icon to delete the key

For information on revoking and handling API Key Management, please [see their documentation](https://docs.easypost.com/docs/authentication#api-key-management).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.37 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
