/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import tim.prune.data.Timestamp;

public class PointReference
implements Comparable<PointReference> {
    private final int _originalIndex;
    private final String _name;
    private final Timestamp _timestamp;
    private final int _desiredIndex;

    public PointReference(int n, String string, Timestamp timestamp) {
        this._originalIndex = n;
        this._name = string;
        this._timestamp = timestamp;
        this._desiredIndex = 0;
    }

    public PointReference(int n, int n2) {
        this._originalIndex = n;
        this._name = null;
        this._timestamp = null;
        this._desiredIndex = n2;
    }

    public int getIndex() {
        return this._originalIndex;
    }

    @Override
    public int compareTo(PointReference pointReference) {
        int n = this._desiredIndex - pointReference._desiredIndex;
        if (n == 0 && (n = this.compareNames(pointReference)) == 0 && (n = this.compareTimes(pointReference)) == 0) {
            n = this._originalIndex - pointReference._originalIndex;
        }
        return n;
    }

    private int compareNames(PointReference pointReference) {
        if (this._name == null && pointReference._name == null) {
            return 0;
        }
        if (this._name == null || pointReference._name == null) {
            return this._name == null ? 1 : -1;
        }
        return this._name.compareTo(pointReference._name);
    }

    private int compareTimes(PointReference pointReference) {
        if (this._timestamp == null && pointReference._timestamp == null) {
            return 0;
        }
        if (this._timestamp == null || pointReference._timestamp == null) {
            return this._timestamp == null ? 1 : -1;
        }
        long l = this._timestamp.getMillisecondsSince(pointReference._timestamp);
        return Long.compare(l, 0L);
    }
}

