/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.action.mappings;

import org.aesh.readline.InputProcessor;
import org.aesh.readline.ReadlineFlag;
import org.aesh.readline.action.Action;
import org.aesh.readline.action.mappings.DeleteChar;
import org.aesh.readline.terminal.Key;
import org.aesh.terminal.utils.Config;

public class EndOfFile
implements Action {
    private int EOFCounter = 0;
    private int ignoreEOFSize = -1;

    @Override
    public String name() {
        return "eof";
    }

    @Override
    public void accept(InputProcessor inputProcessor) {
        if (this.ignoreEOFSize < 0) {
            this.ignoreEOFSize = inputProcessor.flags().getOrDefault((Object)ReadlineFlag.IGNORE_EOF, 0);
        }
        if (inputProcessor.buffer().buffer().length() > 0) {
            new DeleteChar().accept(inputProcessor);
        } else {
            if (this.EOFCounter > 0 && inputProcessor.editMode().prevKey() != null && inputProcessor.editMode().prevKey().getCodePointAt(0) != Key.CTRL_D.getFirstValue()) {
                this.EOFCounter = 0;
            }
            if (this.ignoreEOFSize > this.EOFCounter) {
                ++this.EOFCounter;
            } else {
                inputProcessor.connection().write(Config.getLineSeparator());
                inputProcessor.connection().close();
                inputProcessor.finish(null);
            }
        }
    }
}

