require 'spec_helper'

RSpec.describe Msf::Exploit::Remote::HTTP::FlaskUnsign::Session do
  let(:secret) { 'CHANGEME' }
  describe '.decode' do
    it 'returns a hash' do
      expect(Msf::Exploit::Remote::HTTP::FlaskUnsign::Session.decode('eyJoZWxsbyI6IndvcmxkIn0.XDtqeQ.1qsBdjyRJLokwRzJdzXMVCSyRTA')).to eql({ 'hello' => 'world' })
    end

    # derived from logged in session from Apache Supserset
    it 'returns a hash from complex dict' do
      expected = {
        "_fresh" => true,
        "_id" => "8d59ff5d8869fbb273c1a32f29cd1e58941794de1bfbc172b5bc4050a2d0d2e14bbc68eb66c84de2fbd902930feb61daf05ae9b6f8b4748187c87713a114ff9f",
        "csrf_token" => "29c40f8f619b57b08b3e64bca1f76be68e8391c1",
        "locale" => "en",
        "user_id" => "1"
      }
      expect(Msf::Exploit::Remote::HTTP::FlaskUnsign::Session.decode('.eJwlj0GKAzEMBP-i8xwsW7alfGawZIkNGTYwk5yW_D2GvTZdVPcf7HH69QO31_n2Dfb7hBvwrBJRJ3OTUM29GI6SI4tN9MpC2IWmo4Ya9qxVjVJNI880syOpWmPX1oxXLYdOSVlKipXhHJHqcNEWrNSJkbtx71gGIkVIwAZ2nbG_ng__XXuWl1JwNBStXRNr8UZqA6M39aXiImi4uONp4_DFLHCD9-Xn_yWEzxfWdkQs.ZKXFig.tOBl4_CxT7zWg3EaZZNce7NP4rc')).to eql(expected)
    end
  end

  describe '.sign' do
    it 'returns a cookie string' do
      @freezed_time = Time.utc(2023, 7, 10, 12, 0, 0)
      allow(Time).to receive(:now).and_return(@freezed_time)
      expect(Msf::Exploit::Remote::HTTP::FlaskUnsign::Session.sign({ 'hello' => 'world' }, secret)).to eql('eyJoZWxsbyI6IndvcmxkIn0.ZKvywA.s78heXzx4hJKO55wwu5X7RiS164')
    end
  end

  describe '.valid?' do
    it 'verifies a signed cookie' do
      expect(Msf::Exploit::Remote::HTTP::FlaskUnsign::Session.valid?('eyJoZWxsbyI6IndvcmxkIn0.ZKvywA.s78heXzx4hJKO55wwu5X7RiS164', secret)).to be true
    end

    it 'does not verify an invalid signed cookie' do
      expect(Msf::Exploit::Remote::HTTP::FlaskUnsign::Session.valid?('eyJoZWxsbyI6IndvcmxkIn0.ZKvywA.s78heXzx4hJKO55wwu5X7RiS163', secret)).to be false
    end
  end
end
