/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.CheckedFunction;
import io.jsonwebtoken.impl.lang.RequiredParameterReader;
import io.jsonwebtoken.impl.security.AbstractFamilyJwkFactory;
import io.jsonwebtoken.impl.security.DefaultRsaPublicJwk;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.security.RsaPublicJwk;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;

class RsaPublicJwkFactory
extends AbstractFamilyJwkFactory<RSAPublicKey, RsaPublicJwk> {
    static final RsaPublicJwkFactory INSTANCE = new RsaPublicJwkFactory();

    RsaPublicJwkFactory() {
        super("RSA", RSAPublicKey.class, DefaultRsaPublicJwk.PARAMS);
    }

    @Override
    protected RsaPublicJwk createJwkFromKey(JwkContext<RSAPublicKey> ctx) {
        RSAPublicKey key = ctx.getKey();
        ctx.put(DefaultRsaPublicJwk.MODULUS.getId(), DefaultRsaPublicJwk.MODULUS.applyTo(key.getModulus()));
        ctx.put(DefaultRsaPublicJwk.PUBLIC_EXPONENT.getId(), DefaultRsaPublicJwk.PUBLIC_EXPONENT.applyTo(key.getPublicExponent()));
        return new DefaultRsaPublicJwk(ctx);
    }

    @Override
    protected RsaPublicJwk createJwkFromValues(JwkContext<RSAPublicKey> ctx) {
        RequiredParameterReader reader = new RequiredParameterReader(ctx);
        BigInteger modulus = reader.get(DefaultRsaPublicJwk.MODULUS);
        BigInteger publicExponent = reader.get(DefaultRsaPublicJwk.PUBLIC_EXPONENT);
        final RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, publicExponent);
        RSAPublicKey key = this.generateKey(ctx, new CheckedFunction<KeyFactory, RSAPublicKey>(){

            @Override
            public RSAPublicKey apply(KeyFactory keyFactory) throws Exception {
                return (RSAPublicKey)keyFactory.generatePublic(spec);
            }
        });
        ctx.setKey(key);
        return new DefaultRsaPublicJwk(ctx);
    }
}

