/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p1cycles;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class GreedyCycleBreaker
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> INTERMEDIATE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.REVERSED_EDGE_RESTORER);
    private int[] indeg;
    private int[] outdeg;
    private int[] mark;
    private final LinkedList<LNode> sources = Lists.newLinkedList();
    private final LinkedList<LNode> sinks = Lists.newLinkedList();
    private Random random;

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIGURATION;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Greedy cycle removal", 1.0f);
        nodes = layeredGraph.getLayerlessNodes();
        unprocessedNodeCount = nodes.size();
        this.indeg = new int[unprocessedNodeCount];
        this.outdeg = new int[unprocessedNodeCount];
        this.mark = new int[unprocessedNodeCount];
        index = 0;
        for (LNode node : nodes) {
            node.id = index;
            for (LPort port : node.getPorts()) {
                for (LEdge edge : port.getIncomingEdges()) {
                    if (edge.getSource().getNode() == node) continue;
                    priority = edge.getProperty(LayeredOptions.PRIORITY_DIRECTION);
                    v0 = index;
                    this.indeg[v0] = this.indeg[v0] + (priority > 0 ? priority + 1 : 1);
                }
                for (LEdge edge : port.getOutgoingEdges()) {
                    if (edge.getTarget().getNode() == node) continue;
                    priority = edge.getProperty(LayeredOptions.PRIORITY_DIRECTION);
                    v1 = index;
                    this.outdeg[v1] = this.outdeg[v1] + (priority > 0 ? priority + 1 : 1);
                }
            }
            if (this.outdeg[index] == 0) {
                this.sinks.add(node);
            } else if (this.indeg[index] == 0) {
                this.sources.add(node);
            }
            ++index;
        }
        nextRight = -1;
        nextLeft = 1;
        maxNodes = Lists.newArrayList();
        this.random = layeredGraph.getProperty(InternalProperties.RANDOM);
        ** GOTO lbl67
        {
            sink = this.sinks.removeFirst();
            this.mark[sink.id] = nextRight--;
            this.updateNeighbors(sink);
            --unprocessedNodeCount;
            do {
                if (!this.sinks.isEmpty()) continue block4;
                while (!this.sources.isEmpty()) {
                    source = this.sources.removeFirst();
                    this.mark[source.id] = nextLeft++;
                    this.updateNeighbors(source);
                    --unprocessedNodeCount;
                }
                if (unprocessedNodeCount <= 0) continue;
                maxOutflow = -2147483648;
                for (LNode node : nodes) {
                    if (this.mark[node.id] != 0 || (outflow = this.outdeg[node.id] - this.indeg[node.id]) < maxOutflow) continue;
                    if (outflow > maxOutflow) {
                        maxNodes.clear();
                        maxOutflow = outflow;
                    }
                    maxNodes.add(node);
                }
                if (!GreedyCycleBreaker.$assertionsDisabled && maxOutflow <= -2147483648) {
                    throw new AssertionError();
                }
                maxNode = this.chooseNodeWithMaxOutflow(maxNodes);
                this.mark[maxNode.id] = nextLeft++;
                this.updateNeighbors(maxNode);
                --unprocessedNodeCount;
lbl67:
                // 3 sources

            } while (unprocessedNodeCount > 0);
        }
        shiftBase = nodes.size() + 1;
        index = 0;
        while (index < nodes.size()) {
            if (this.mark[index] < 0) {
                v2 = index;
                this.mark[v2] = this.mark[v2] + shiftBase;
            }
            ++index;
        }
        for (LNode node : nodes) {
            var16_24 = ports = LGraphUtil.toPortArray(node.getPorts());
            var15_23 = ports.length;
            var14_22 = 0;
            while (var14_22 < var15_23) {
                port = var16_24[var14_22];
                var21_29 = outgoingEdges = LGraphUtil.toEdgeArray(port.getOutgoingEdges());
                var20_28 = outgoingEdges.length;
                var19_27 = 0;
                while (var19_27 < var20_28) {
                    edge = var21_29[var19_27];
                    targetIx = edge.getTarget().getNode().id;
                    if (this.mark[node.id] > this.mark[targetIx]) {
                        edge.reverse(layeredGraph, true);
                        layeredGraph.setProperty(InternalProperties.CYCLIC, (Object)true);
                    }
                    ++var19_27;
                }
                ++var14_22;
            }
        }
        this.dispose();
        monitor.done();
    }

    protected LNode chooseNodeWithMaxOutflow(List<LNode> nodes) {
        return nodes.get(this.random.nextInt(nodes.size()));
    }

    private void dispose() {
        this.indeg = null;
        this.outdeg = null;
        this.mark = null;
        this.sources.clear();
        this.sinks.clear();
    }

    private void updateNeighbors(LNode node) {
        for (LPort port : node.getPorts()) {
            for (LEdge edge : port.getConnectedEdges()) {
                int index;
                LPort connectedPort = edge.getSource() == port ? edge.getTarget() : edge.getSource();
                LNode endpoint = connectedPort.getNode();
                if (node == endpoint) continue;
                int priority = edge.getProperty(LayeredOptions.PRIORITY_DIRECTION);
                if (priority < 0) {
                    priority = 0;
                }
                if (this.mark[index = endpoint.id] != 0) continue;
                if (edge.getTarget() == connectedPort) {
                    int n = index;
                    this.indeg[n] = this.indeg[n] - (priority + 1);
                    if (this.indeg[index] > 0 || this.outdeg[index] <= 0) continue;
                    this.sources.add(endpoint);
                    continue;
                }
                int n = index;
                this.outdeg[n] = this.outdeg[n] - (priority + 1);
                if (this.outdeg[index] > 0 || this.indeg[index] <= 0) continue;
                this.sinks.add(endpoint);
            }
        }
    }
}

