/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ast;

import com.oracle.graal.python.builtins.modules.ast.AstState;
import com.oracle.graal.python.builtins.modules.ast.Obj2SstBase;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.pegparser.sst.AliasTy;
import com.oracle.graal.python.pegparser.sst.ArgTy;
import com.oracle.graal.python.pegparser.sst.ArgumentsTy;
import com.oracle.graal.python.pegparser.sst.BoolOpTy;
import com.oracle.graal.python.pegparser.sst.CmpOpTy;
import com.oracle.graal.python.pegparser.sst.ComprehensionTy;
import com.oracle.graal.python.pegparser.sst.ConstantValue;
import com.oracle.graal.python.pegparser.sst.ExceptHandlerTy;
import com.oracle.graal.python.pegparser.sst.ExprContextTy;
import com.oracle.graal.python.pegparser.sst.ExprTy;
import com.oracle.graal.python.pegparser.sst.KeywordTy;
import com.oracle.graal.python.pegparser.sst.MatchCaseTy;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.pegparser.sst.OperatorTy;
import com.oracle.graal.python.pegparser.sst.PatternTy;
import com.oracle.graal.python.pegparser.sst.StmtTy;
import com.oracle.graal.python.pegparser.sst.TypeIgnoreTy;
import com.oracle.graal.python.pegparser.sst.TypeParamTy;
import com.oracle.graal.python.pegparser.sst.UnaryOpTy;
import com.oracle.graal.python.pegparser.sst.WithItemTy;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import com.oracle.truffle.api.nodes.Node;

final class Obj2Sst
extends Obj2SstBase {
    Obj2Sst(Node node, AstState state) {
        super(node, state);
    }

    ModTy obj2ModTy(Object obj) {
        if (obj == PNone.NONE) {
            return null;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsModule)) {
            return this.obj2Module(obj);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsInteractive)) {
            return this.obj2Interactive(obj);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsExpression)) {
            return this.obj2Expression(obj);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsFunctionType)) {
            return this.obj2FunctionType(obj);
        }
        throw this.unexpectedNodeType(AstState.T_T_MOD, obj);
    }

    ModTy.Module obj2Module(Object obj) {
        StmtTy[] body = this.lookupAndConvertSequence(obj, AstState.T_F_BODY, AstState.T_C_MODULE, this::obj2StmtTy, StmtTy[]::new);
        TypeIgnoreTy[] typeIgnores = this.lookupAndConvertSequence(obj, AstState.T_F_TYPE_IGNORES, AstState.T_C_MODULE, this::obj2TypeIgnoreTy, TypeIgnoreTy[]::new);
        SourceRange sourceRange = SourceRange.ARTIFICIAL_RANGE;
        return new ModTy.Module(body, typeIgnores, sourceRange);
    }

    ModTy.Interactive obj2Interactive(Object obj) {
        StmtTy[] body = this.lookupAndConvertSequence(obj, AstState.T_F_BODY, AstState.T_C_INTERACTIVE, this::obj2StmtTy, StmtTy[]::new);
        SourceRange sourceRange = SourceRange.ARTIFICIAL_RANGE;
        return new ModTy.Interactive(body, sourceRange);
    }

    ModTy.Expression obj2Expression(Object obj) {
        ExprTy body = this.lookupAndConvert(obj, AstState.T_F_BODY, AstState.T_C_EXPRESSION, this::obj2ExprTy, true);
        SourceRange sourceRange = SourceRange.ARTIFICIAL_RANGE;
        return new ModTy.Expression(body, sourceRange);
    }

    ModTy.FunctionType obj2FunctionType(Object obj) {
        ExprTy[] argTypes = this.lookupAndConvertSequence(obj, AstState.T_F_ARGTYPES, AstState.T_C_FUNCTIONTYPE, this::obj2ExprTy, ExprTy[]::new);
        ExprTy returns = this.lookupAndConvert(obj, AstState.T_F_RETURNS, AstState.T_C_FUNCTIONTYPE, this::obj2ExprTy, true);
        SourceRange sourceRange = SourceRange.ARTIFICIAL_RANGE;
        return new ModTy.FunctionType(argTypes, returns, sourceRange);
    }

    StmtTy obj2StmtTy(Object obj) {
        if (obj == PNone.NONE) {
            return null;
        }
        int lineNo = this.lookupAndConvertInt(obj, AstState.T_F_LINENO, AstState.T_T_STMT);
        int colOffset = this.lookupAndConvertInt(obj, AstState.T_F_COL_OFFSET, AstState.T_T_STMT);
        int endLineno = this.lookupAndConvertIntOpt(obj, AstState.T_F_END_LINENO, AstState.T_T_STMT, lineNo);
        int endColOffset = this.lookupAndConvertIntOpt(obj, AstState.T_F_END_COL_OFFSET, AstState.T_T_STMT, colOffset);
        SourceRange sourceRange = new SourceRange(lineNo, colOffset, endLineno, endColOffset);
        if (Obj2Sst.isInstanceOf(obj, this.state.clsFunctionDef)) {
            return this.obj2FunctionDef(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsAsyncFunctionDef)) {
            return this.obj2AsyncFunctionDef(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsClassDef)) {
            return this.obj2ClassDef(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsReturn)) {
            return this.obj2Return(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsDelete)) {
            return this.obj2Delete(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsAssign)) {
            return this.obj2Assign(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsTypeAlias)) {
            return this.obj2TypeAlias(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsAugAssign)) {
            return this.obj2AugAssign(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsAnnAssign)) {
            return this.obj2AnnAssign(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsFor)) {
            return this.obj2For(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsAsyncFor)) {
            return this.obj2AsyncFor(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsWhile)) {
            return this.obj2While(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsIf)) {
            return this.obj2If(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsWith)) {
            return this.obj2With(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsAsyncWith)) {
            return this.obj2AsyncWith(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsMatch)) {
            return this.obj2Match(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsRaise)) {
            return this.obj2Raise(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsTry)) {
            return this.obj2Try(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsTryStar)) {
            return this.obj2TryStar(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsAssert)) {
            return this.obj2Assert(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsImport)) {
            return this.obj2Import(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsImportFrom)) {
            return this.obj2ImportFrom(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsGlobal)) {
            return this.obj2Global(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsNonlocal)) {
            return this.obj2Nonlocal(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsExpr)) {
            return this.obj2Expr(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsPass)) {
            return this.obj2Pass(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsBreak)) {
            return this.obj2Break(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsContinue)) {
            return this.obj2Continue(obj, sourceRange);
        }
        throw this.unexpectedNodeType(AstState.T_T_STMT, obj);
    }

    StmtTy.FunctionDef obj2FunctionDef(Object obj, SourceRange sourceRange) {
        String name = this.lookupAndConvert(obj, AstState.T_F_NAME, AstState.T_C_FUNCTIONDEF, this::obj2identifier, true);
        ArgumentsTy args = this.lookupAndConvert(obj, AstState.T_F_ARGS, AstState.T_C_FUNCTIONDEF, this::obj2ArgumentsTy, true);
        StmtTy[] body = this.lookupAndConvertSequence(obj, AstState.T_F_BODY, AstState.T_C_FUNCTIONDEF, this::obj2StmtTy, StmtTy[]::new);
        ExprTy[] decoratorList = this.lookupAndConvertSequence(obj, AstState.T_F_DECORATOR_LIST, AstState.T_C_FUNCTIONDEF, this::obj2ExprTy, ExprTy[]::new);
        ExprTy returns = this.lookupAndConvert(obj, AstState.T_F_RETURNS, AstState.T_C_FUNCTIONDEF, this::obj2ExprTy, false);
        Object typeComment = this.lookupAndConvert(obj, AstState.T_F_TYPE_COMMENT, AstState.T_C_FUNCTIONDEF, this::obj2string, false);
        TypeParamTy[] typeParams = this.lookupAndConvertSequence(obj, AstState.T_F_TYPE_PARAMS, AstState.T_C_FUNCTIONDEF, this::obj2TypeParamTy, TypeParamTy[]::new);
        return new StmtTy.FunctionDef(name, args, body, decoratorList, returns, typeComment, typeParams, sourceRange);
    }

    StmtTy.AsyncFunctionDef obj2AsyncFunctionDef(Object obj, SourceRange sourceRange) {
        String name = this.lookupAndConvert(obj, AstState.T_F_NAME, AstState.T_C_ASYNCFUNCTIONDEF, this::obj2identifier, true);
        ArgumentsTy args = this.lookupAndConvert(obj, AstState.T_F_ARGS, AstState.T_C_ASYNCFUNCTIONDEF, this::obj2ArgumentsTy, true);
        StmtTy[] body = this.lookupAndConvertSequence(obj, AstState.T_F_BODY, AstState.T_C_ASYNCFUNCTIONDEF, this::obj2StmtTy, StmtTy[]::new);
        ExprTy[] decoratorList = this.lookupAndConvertSequence(obj, AstState.T_F_DECORATOR_LIST, AstState.T_C_ASYNCFUNCTIONDEF, this::obj2ExprTy, ExprTy[]::new);
        ExprTy returns = this.lookupAndConvert(obj, AstState.T_F_RETURNS, AstState.T_C_ASYNCFUNCTIONDEF, this::obj2ExprTy, false);
        Object typeComment = this.lookupAndConvert(obj, AstState.T_F_TYPE_COMMENT, AstState.T_C_ASYNCFUNCTIONDEF, this::obj2string, false);
        TypeParamTy[] typeParams = this.lookupAndConvertSequence(obj, AstState.T_F_TYPE_PARAMS, AstState.T_C_ASYNCFUNCTIONDEF, this::obj2TypeParamTy, TypeParamTy[]::new);
        return new StmtTy.AsyncFunctionDef(name, args, body, decoratorList, returns, typeComment, typeParams, sourceRange);
    }

    StmtTy.ClassDef obj2ClassDef(Object obj, SourceRange sourceRange) {
        String name = this.lookupAndConvert(obj, AstState.T_F_NAME, AstState.T_C_CLASSDEF, this::obj2identifier, true);
        ExprTy[] bases = this.lookupAndConvertSequence(obj, AstState.T_F_BASES, AstState.T_C_CLASSDEF, this::obj2ExprTy, ExprTy[]::new);
        KeywordTy[] keywords = this.lookupAndConvertSequence(obj, AstState.T_F_KEYWORDS, AstState.T_C_CLASSDEF, this::obj2KeywordTy, KeywordTy[]::new);
        StmtTy[] body = this.lookupAndConvertSequence(obj, AstState.T_F_BODY, AstState.T_C_CLASSDEF, this::obj2StmtTy, StmtTy[]::new);
        ExprTy[] decoratorList = this.lookupAndConvertSequence(obj, AstState.T_F_DECORATOR_LIST, AstState.T_C_CLASSDEF, this::obj2ExprTy, ExprTy[]::new);
        TypeParamTy[] typeParams = this.lookupAndConvertSequence(obj, AstState.T_F_TYPE_PARAMS, AstState.T_C_CLASSDEF, this::obj2TypeParamTy, TypeParamTy[]::new);
        return new StmtTy.ClassDef(name, bases, keywords, body, decoratorList, typeParams, sourceRange);
    }

    StmtTy.Return obj2Return(Object obj, SourceRange sourceRange) {
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_RETURN, this::obj2ExprTy, false);
        return new StmtTy.Return(value, sourceRange);
    }

    StmtTy.Delete obj2Delete(Object obj, SourceRange sourceRange) {
        ExprTy[] targets = this.lookupAndConvertSequence(obj, AstState.T_F_TARGETS, AstState.T_C_DELETE, this::obj2ExprTy, ExprTy[]::new);
        return new StmtTy.Delete(targets, sourceRange);
    }

    StmtTy.Assign obj2Assign(Object obj, SourceRange sourceRange) {
        ExprTy[] targets = this.lookupAndConvertSequence(obj, AstState.T_F_TARGETS, AstState.T_C_ASSIGN, this::obj2ExprTy, ExprTy[]::new);
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_ASSIGN, this::obj2ExprTy, true);
        Object typeComment = this.lookupAndConvert(obj, AstState.T_F_TYPE_COMMENT, AstState.T_C_ASSIGN, this::obj2string, false);
        return new StmtTy.Assign(targets, value, typeComment, sourceRange);
    }

    StmtTy.TypeAlias obj2TypeAlias(Object obj, SourceRange sourceRange) {
        ExprTy name = this.lookupAndConvert(obj, AstState.T_F_NAME, AstState.T_C_TYPEALIAS, this::obj2ExprTy, true);
        TypeParamTy[] typeParams = this.lookupAndConvertSequence(obj, AstState.T_F_TYPE_PARAMS, AstState.T_C_TYPEALIAS, this::obj2TypeParamTy, TypeParamTy[]::new);
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_TYPEALIAS, this::obj2ExprTy, true);
        return new StmtTy.TypeAlias(name, typeParams, value, sourceRange);
    }

    StmtTy.AugAssign obj2AugAssign(Object obj, SourceRange sourceRange) {
        ExprTy target = this.lookupAndConvert(obj, AstState.T_F_TARGET, AstState.T_C_AUGASSIGN, this::obj2ExprTy, true);
        OperatorTy op = this.lookupAndConvert(obj, AstState.T_F_OP, AstState.T_C_AUGASSIGN, this::obj2OperatorTy, true);
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_AUGASSIGN, this::obj2ExprTy, true);
        return new StmtTy.AugAssign(target, op, value, sourceRange);
    }

    StmtTy.AnnAssign obj2AnnAssign(Object obj, SourceRange sourceRange) {
        ExprTy target = this.lookupAndConvert(obj, AstState.T_F_TARGET, AstState.T_C_ANNASSIGN, this::obj2ExprTy, true);
        ExprTy annotation = this.lookupAndConvert(obj, AstState.T_F_ANNOTATION, AstState.T_C_ANNASSIGN, this::obj2ExprTy, true);
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_ANNASSIGN, this::obj2ExprTy, false);
        boolean isSimple = this.lookupAndConvertBoolean(obj, AstState.T_F_SIMPLE, AstState.T_C_ANNASSIGN);
        return new StmtTy.AnnAssign(target, annotation, value, isSimple, sourceRange);
    }

    StmtTy.For obj2For(Object obj, SourceRange sourceRange) {
        ExprTy target = this.lookupAndConvert(obj, AstState.T_F_TARGET, AstState.T_C_FOR, this::obj2ExprTy, true);
        ExprTy iter = this.lookupAndConvert(obj, AstState.T_F_ITER, AstState.T_C_FOR, this::obj2ExprTy, true);
        StmtTy[] body = this.lookupAndConvertSequence(obj, AstState.T_F_BODY, AstState.T_C_FOR, this::obj2StmtTy, StmtTy[]::new);
        StmtTy[] orElse = this.lookupAndConvertSequence(obj, AstState.T_F_ORELSE, AstState.T_C_FOR, this::obj2StmtTy, StmtTy[]::new);
        Object typeComment = this.lookupAndConvert(obj, AstState.T_F_TYPE_COMMENT, AstState.T_C_FOR, this::obj2string, false);
        return new StmtTy.For(target, iter, body, orElse, typeComment, sourceRange);
    }

    StmtTy.AsyncFor obj2AsyncFor(Object obj, SourceRange sourceRange) {
        ExprTy target = this.lookupAndConvert(obj, AstState.T_F_TARGET, AstState.T_C_ASYNCFOR, this::obj2ExprTy, true);
        ExprTy iter = this.lookupAndConvert(obj, AstState.T_F_ITER, AstState.T_C_ASYNCFOR, this::obj2ExprTy, true);
        StmtTy[] body = this.lookupAndConvertSequence(obj, AstState.T_F_BODY, AstState.T_C_ASYNCFOR, this::obj2StmtTy, StmtTy[]::new);
        StmtTy[] orElse = this.lookupAndConvertSequence(obj, AstState.T_F_ORELSE, AstState.T_C_ASYNCFOR, this::obj2StmtTy, StmtTy[]::new);
        Object typeComment = this.lookupAndConvert(obj, AstState.T_F_TYPE_COMMENT, AstState.T_C_ASYNCFOR, this::obj2string, false);
        return new StmtTy.AsyncFor(target, iter, body, orElse, typeComment, sourceRange);
    }

    StmtTy.While obj2While(Object obj, SourceRange sourceRange) {
        ExprTy test = this.lookupAndConvert(obj, AstState.T_F_TEST, AstState.T_C_WHILE, this::obj2ExprTy, true);
        StmtTy[] body = this.lookupAndConvertSequence(obj, AstState.T_F_BODY, AstState.T_C_WHILE, this::obj2StmtTy, StmtTy[]::new);
        StmtTy[] orElse = this.lookupAndConvertSequence(obj, AstState.T_F_ORELSE, AstState.T_C_WHILE, this::obj2StmtTy, StmtTy[]::new);
        return new StmtTy.While(test, body, orElse, sourceRange);
    }

    StmtTy.If obj2If(Object obj, SourceRange sourceRange) {
        ExprTy test = this.lookupAndConvert(obj, AstState.T_F_TEST, AstState.T_C_IF, this::obj2ExprTy, true);
        StmtTy[] body = this.lookupAndConvertSequence(obj, AstState.T_F_BODY, AstState.T_C_IF, this::obj2StmtTy, StmtTy[]::new);
        StmtTy[] orElse = this.lookupAndConvertSequence(obj, AstState.T_F_ORELSE, AstState.T_C_IF, this::obj2StmtTy, StmtTy[]::new);
        return new StmtTy.If(test, body, orElse, sourceRange);
    }

    StmtTy.With obj2With(Object obj, SourceRange sourceRange) {
        WithItemTy[] items = this.lookupAndConvertSequence(obj, AstState.T_F_ITEMS, AstState.T_C_WITH, this::obj2WithItemTy, WithItemTy[]::new);
        StmtTy[] body = this.lookupAndConvertSequence(obj, AstState.T_F_BODY, AstState.T_C_WITH, this::obj2StmtTy, StmtTy[]::new);
        Object typeComment = this.lookupAndConvert(obj, AstState.T_F_TYPE_COMMENT, AstState.T_C_WITH, this::obj2string, false);
        return new StmtTy.With(items, body, typeComment, sourceRange);
    }

    StmtTy.AsyncWith obj2AsyncWith(Object obj, SourceRange sourceRange) {
        WithItemTy[] items = this.lookupAndConvertSequence(obj, AstState.T_F_ITEMS, AstState.T_C_ASYNCWITH, this::obj2WithItemTy, WithItemTy[]::new);
        StmtTy[] body = this.lookupAndConvertSequence(obj, AstState.T_F_BODY, AstState.T_C_ASYNCWITH, this::obj2StmtTy, StmtTy[]::new);
        Object typeComment = this.lookupAndConvert(obj, AstState.T_F_TYPE_COMMENT, AstState.T_C_ASYNCWITH, this::obj2string, false);
        return new StmtTy.AsyncWith(items, body, typeComment, sourceRange);
    }

    StmtTy.Match obj2Match(Object obj, SourceRange sourceRange) {
        ExprTy subject = this.lookupAndConvert(obj, AstState.T_F_SUBJECT, AstState.T_C_MATCH, this::obj2ExprTy, true);
        MatchCaseTy[] cases = this.lookupAndConvertSequence(obj, AstState.T_F_CASES, AstState.T_C_MATCH, this::obj2MatchCaseTy, MatchCaseTy[]::new);
        return new StmtTy.Match(subject, cases, sourceRange);
    }

    StmtTy.Raise obj2Raise(Object obj, SourceRange sourceRange) {
        ExprTy exc = this.lookupAndConvert(obj, AstState.T_F_EXC, AstState.T_C_RAISE, this::obj2ExprTy, false);
        ExprTy cause = this.lookupAndConvert(obj, AstState.T_F_CAUSE, AstState.T_C_RAISE, this::obj2ExprTy, false);
        return new StmtTy.Raise(exc, cause, sourceRange);
    }

    StmtTy.Try obj2Try(Object obj, SourceRange sourceRange) {
        StmtTy[] body = this.lookupAndConvertSequence(obj, AstState.T_F_BODY, AstState.T_C_TRY, this::obj2StmtTy, StmtTy[]::new);
        ExceptHandlerTy[] handlers = this.lookupAndConvertSequence(obj, AstState.T_F_HANDLERS, AstState.T_C_TRY, this::obj2ExceptHandlerTy, ExceptHandlerTy[]::new);
        StmtTy[] orElse = this.lookupAndConvertSequence(obj, AstState.T_F_ORELSE, AstState.T_C_TRY, this::obj2StmtTy, StmtTy[]::new);
        StmtTy[] finalBody = this.lookupAndConvertSequence(obj, AstState.T_F_FINALBODY, AstState.T_C_TRY, this::obj2StmtTy, StmtTy[]::new);
        return new StmtTy.Try(body, handlers, orElse, finalBody, sourceRange);
    }

    StmtTy.TryStar obj2TryStar(Object obj, SourceRange sourceRange) {
        StmtTy[] body = this.lookupAndConvertSequence(obj, AstState.T_F_BODY, AstState.T_C_TRYSTAR, this::obj2StmtTy, StmtTy[]::new);
        ExceptHandlerTy[] handlers = this.lookupAndConvertSequence(obj, AstState.T_F_HANDLERS, AstState.T_C_TRYSTAR, this::obj2ExceptHandlerTy, ExceptHandlerTy[]::new);
        StmtTy[] orElse = this.lookupAndConvertSequence(obj, AstState.T_F_ORELSE, AstState.T_C_TRYSTAR, this::obj2StmtTy, StmtTy[]::new);
        StmtTy[] finalBody = this.lookupAndConvertSequence(obj, AstState.T_F_FINALBODY, AstState.T_C_TRYSTAR, this::obj2StmtTy, StmtTy[]::new);
        return new StmtTy.TryStar(body, handlers, orElse, finalBody, sourceRange);
    }

    StmtTy.Assert obj2Assert(Object obj, SourceRange sourceRange) {
        ExprTy test = this.lookupAndConvert(obj, AstState.T_F_TEST, AstState.T_C_ASSERT, this::obj2ExprTy, true);
        ExprTy msg = this.lookupAndConvert(obj, AstState.T_F_MSG, AstState.T_C_ASSERT, this::obj2ExprTy, false);
        return new StmtTy.Assert(test, msg, sourceRange);
    }

    StmtTy.Import obj2Import(Object obj, SourceRange sourceRange) {
        AliasTy[] names = this.lookupAndConvertSequence(obj, AstState.T_F_NAMES, AstState.T_C_IMPORT, this::obj2AliasTy, AliasTy[]::new);
        return new StmtTy.Import(names, sourceRange);
    }

    StmtTy.ImportFrom obj2ImportFrom(Object obj, SourceRange sourceRange) {
        String module = this.lookupAndConvert(obj, AstState.T_F_MODULE, AstState.T_C_IMPORTFROM, this::obj2identifier, false);
        AliasTy[] names = this.lookupAndConvertSequence(obj, AstState.T_F_NAMES, AstState.T_C_IMPORTFROM, this::obj2AliasTy, AliasTy[]::new);
        int level = this.lookupAndConvertIntOpt(obj, AstState.T_F_LEVEL, AstState.T_C_IMPORTFROM, 0);
        return new StmtTy.ImportFrom(module, names, level, sourceRange);
    }

    StmtTy.Global obj2Global(Object obj, SourceRange sourceRange) {
        String[] names = this.lookupAndConvertSequence(obj, AstState.T_F_NAMES, AstState.T_C_GLOBAL, this::obj2identifier, String[]::new);
        return new StmtTy.Global(names, sourceRange);
    }

    StmtTy.Nonlocal obj2Nonlocal(Object obj, SourceRange sourceRange) {
        String[] names = this.lookupAndConvertSequence(obj, AstState.T_F_NAMES, AstState.T_C_NONLOCAL, this::obj2identifier, String[]::new);
        return new StmtTy.Nonlocal(names, sourceRange);
    }

    StmtTy.Expr obj2Expr(Object obj, SourceRange sourceRange) {
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_EXPR, this::obj2ExprTy, true);
        return new StmtTy.Expr(value, sourceRange);
    }

    StmtTy.Pass obj2Pass(Object obj, SourceRange sourceRange) {
        return new StmtTy.Pass(sourceRange);
    }

    StmtTy.Break obj2Break(Object obj, SourceRange sourceRange) {
        return new StmtTy.Break(sourceRange);
    }

    StmtTy.Continue obj2Continue(Object obj, SourceRange sourceRange) {
        return new StmtTy.Continue(sourceRange);
    }

    ExprTy obj2ExprTy(Object obj) {
        if (obj == PNone.NONE) {
            return null;
        }
        int lineNo = this.lookupAndConvertInt(obj, AstState.T_F_LINENO, AstState.T_T_EXPR);
        int colOffset = this.lookupAndConvertInt(obj, AstState.T_F_COL_OFFSET, AstState.T_T_EXPR);
        int endLineno = this.lookupAndConvertIntOpt(obj, AstState.T_F_END_LINENO, AstState.T_T_EXPR, lineNo);
        int endColOffset = this.lookupAndConvertIntOpt(obj, AstState.T_F_END_COL_OFFSET, AstState.T_T_EXPR, colOffset);
        SourceRange sourceRange = new SourceRange(lineNo, colOffset, endLineno, endColOffset);
        if (Obj2Sst.isInstanceOf(obj, this.state.clsBoolOp)) {
            return this.obj2BoolOp(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsNamedExpr)) {
            return this.obj2NamedExpr(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsBinOp)) {
            return this.obj2BinOp(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsUnaryOp)) {
            return this.obj2UnaryOp(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsLambda)) {
            return this.obj2Lambda(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsIfExp)) {
            return this.obj2IfExp(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsDict)) {
            return this.obj2Dict(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsSet)) {
            return this.obj2Set(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsListComp)) {
            return this.obj2ListComp(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsSetComp)) {
            return this.obj2SetComp(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsDictComp)) {
            return this.obj2DictComp(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsGeneratorExp)) {
            return this.obj2GeneratorExp(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsAwait)) {
            return this.obj2Await(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsYield)) {
            return this.obj2Yield(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsYieldFrom)) {
            return this.obj2YieldFrom(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsCompare)) {
            return this.obj2Compare(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsCall)) {
            return this.obj2Call(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsFormattedValue)) {
            return this.obj2FormattedValue(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsJoinedStr)) {
            return this.obj2JoinedStr(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsConstant)) {
            return this.obj2Constant(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsAttribute)) {
            return this.obj2Attribute(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsSubscript)) {
            return this.obj2Subscript(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsStarred)) {
            return this.obj2Starred(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsName)) {
            return this.obj2Name(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsList)) {
            return this.obj2List(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsTuple)) {
            return this.obj2Tuple(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsSlice)) {
            return this.obj2Slice(obj, sourceRange);
        }
        throw this.unexpectedNodeType(AstState.T_T_EXPR, obj);
    }

    ExprTy.BoolOp obj2BoolOp(Object obj, SourceRange sourceRange) {
        BoolOpTy op = this.lookupAndConvert(obj, AstState.T_F_OP, AstState.T_C_BOOLOP, this::obj2BoolOpTy, true);
        ExprTy[] values = this.lookupAndConvertSequence(obj, AstState.T_F_VALUES, AstState.T_C_BOOLOP, this::obj2ExprTy, ExprTy[]::new);
        return new ExprTy.BoolOp(op, values, sourceRange);
    }

    ExprTy.NamedExpr obj2NamedExpr(Object obj, SourceRange sourceRange) {
        ExprTy target = this.lookupAndConvert(obj, AstState.T_F_TARGET, AstState.T_C_NAMEDEXPR, this::obj2ExprTy, true);
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_NAMEDEXPR, this::obj2ExprTy, true);
        return new ExprTy.NamedExpr(target, value, sourceRange);
    }

    ExprTy.BinOp obj2BinOp(Object obj, SourceRange sourceRange) {
        ExprTy left = this.lookupAndConvert(obj, AstState.T_F_LEFT, AstState.T_C_BINOP, this::obj2ExprTy, true);
        OperatorTy op = this.lookupAndConvert(obj, AstState.T_F_OP, AstState.T_C_BINOP, this::obj2OperatorTy, true);
        ExprTy right = this.lookupAndConvert(obj, AstState.T_F_RIGHT, AstState.T_C_BINOP, this::obj2ExprTy, true);
        return new ExprTy.BinOp(left, op, right, sourceRange);
    }

    ExprTy.UnaryOp obj2UnaryOp(Object obj, SourceRange sourceRange) {
        UnaryOpTy op = this.lookupAndConvert(obj, AstState.T_F_OP, AstState.T_C_UNARYOP, this::obj2UnaryOpTy, true);
        ExprTy operand = this.lookupAndConvert(obj, AstState.T_F_OPERAND, AstState.T_C_UNARYOP, this::obj2ExprTy, true);
        return new ExprTy.UnaryOp(op, operand, sourceRange);
    }

    ExprTy.Lambda obj2Lambda(Object obj, SourceRange sourceRange) {
        ArgumentsTy args = this.lookupAndConvert(obj, AstState.T_F_ARGS, AstState.T_C_LAMBDA, this::obj2ArgumentsTy, true);
        ExprTy body = this.lookupAndConvert(obj, AstState.T_F_BODY, AstState.T_C_LAMBDA, this::obj2ExprTy, true);
        return new ExprTy.Lambda(args, body, sourceRange);
    }

    ExprTy.IfExp obj2IfExp(Object obj, SourceRange sourceRange) {
        ExprTy test = this.lookupAndConvert(obj, AstState.T_F_TEST, AstState.T_C_IFEXP, this::obj2ExprTy, true);
        ExprTy body = this.lookupAndConvert(obj, AstState.T_F_BODY, AstState.T_C_IFEXP, this::obj2ExprTy, true);
        ExprTy orElse = this.lookupAndConvert(obj, AstState.T_F_ORELSE, AstState.T_C_IFEXP, this::obj2ExprTy, true);
        return new ExprTy.IfExp(test, body, orElse, sourceRange);
    }

    ExprTy.Dict obj2Dict(Object obj, SourceRange sourceRange) {
        ExprTy[] keys = this.lookupAndConvertSequence(obj, AstState.T_F_KEYS, AstState.T_C_DICT, this::obj2ExprTy, ExprTy[]::new);
        ExprTy[] values = this.lookupAndConvertSequence(obj, AstState.T_F_VALUES, AstState.T_C_DICT, this::obj2ExprTy, ExprTy[]::new);
        return new ExprTy.Dict(keys, values, sourceRange);
    }

    ExprTy.Set obj2Set(Object obj, SourceRange sourceRange) {
        ExprTy[] elements = this.lookupAndConvertSequence(obj, AstState.T_F_ELTS, AstState.T_C_SET, this::obj2ExprTy, ExprTy[]::new);
        return new ExprTy.Set(elements, sourceRange);
    }

    ExprTy.ListComp obj2ListComp(Object obj, SourceRange sourceRange) {
        ExprTy element = this.lookupAndConvert(obj, AstState.T_F_ELT, AstState.T_C_LISTCOMP, this::obj2ExprTy, true);
        ComprehensionTy[] generators = this.lookupAndConvertSequence(obj, AstState.T_F_GENERATORS, AstState.T_C_LISTCOMP, this::obj2ComprehensionTy, ComprehensionTy[]::new);
        return new ExprTy.ListComp(element, generators, sourceRange);
    }

    ExprTy.SetComp obj2SetComp(Object obj, SourceRange sourceRange) {
        ExprTy element = this.lookupAndConvert(obj, AstState.T_F_ELT, AstState.T_C_SETCOMP, this::obj2ExprTy, true);
        ComprehensionTy[] generators = this.lookupAndConvertSequence(obj, AstState.T_F_GENERATORS, AstState.T_C_SETCOMP, this::obj2ComprehensionTy, ComprehensionTy[]::new);
        return new ExprTy.SetComp(element, generators, sourceRange);
    }

    ExprTy.DictComp obj2DictComp(Object obj, SourceRange sourceRange) {
        ExprTy key = this.lookupAndConvert(obj, AstState.T_F_KEY, AstState.T_C_DICTCOMP, this::obj2ExprTy, true);
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_DICTCOMP, this::obj2ExprTy, true);
        ComprehensionTy[] generators = this.lookupAndConvertSequence(obj, AstState.T_F_GENERATORS, AstState.T_C_DICTCOMP, this::obj2ComprehensionTy, ComprehensionTy[]::new);
        return new ExprTy.DictComp(key, value, generators, sourceRange);
    }

    ExprTy.GeneratorExp obj2GeneratorExp(Object obj, SourceRange sourceRange) {
        ExprTy element = this.lookupAndConvert(obj, AstState.T_F_ELT, AstState.T_C_GENERATOREXP, this::obj2ExprTy, true);
        ComprehensionTy[] generators = this.lookupAndConvertSequence(obj, AstState.T_F_GENERATORS, AstState.T_C_GENERATOREXP, this::obj2ComprehensionTy, ComprehensionTy[]::new);
        return new ExprTy.GeneratorExp(element, generators, sourceRange);
    }

    ExprTy.Await obj2Await(Object obj, SourceRange sourceRange) {
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_AWAIT, this::obj2ExprTy, true);
        return new ExprTy.Await(value, sourceRange);
    }

    ExprTy.Yield obj2Yield(Object obj, SourceRange sourceRange) {
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_YIELD, this::obj2ExprTy, false);
        return new ExprTy.Yield(value, sourceRange);
    }

    ExprTy.YieldFrom obj2YieldFrom(Object obj, SourceRange sourceRange) {
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_YIELDFROM, this::obj2ExprTy, true);
        return new ExprTy.YieldFrom(value, sourceRange);
    }

    ExprTy.Compare obj2Compare(Object obj, SourceRange sourceRange) {
        ExprTy left = this.lookupAndConvert(obj, AstState.T_F_LEFT, AstState.T_C_COMPARE, this::obj2ExprTy, true);
        CmpOpTy[] ops = this.lookupAndConvertSequence(obj, AstState.T_F_OPS, AstState.T_C_COMPARE, this::obj2CmpOpTy, CmpOpTy[]::new);
        ExprTy[] comparators = this.lookupAndConvertSequence(obj, AstState.T_F_COMPARATORS, AstState.T_C_COMPARE, this::obj2ExprTy, ExprTy[]::new);
        return new ExprTy.Compare(left, ops, comparators, sourceRange);
    }

    ExprTy.Call obj2Call(Object obj, SourceRange sourceRange) {
        ExprTy func = this.lookupAndConvert(obj, AstState.T_F_FUNC, AstState.T_C_CALL, this::obj2ExprTy, true);
        ExprTy[] args = this.lookupAndConvertSequence(obj, AstState.T_F_ARGS, AstState.T_C_CALL, this::obj2ExprTy, ExprTy[]::new);
        KeywordTy[] keywords = this.lookupAndConvertSequence(obj, AstState.T_F_KEYWORDS, AstState.T_C_CALL, this::obj2KeywordTy, KeywordTy[]::new);
        return new ExprTy.Call(func, args, keywords, sourceRange);
    }

    ExprTy.FormattedValue obj2FormattedValue(Object obj, SourceRange sourceRange) {
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_FORMATTEDVALUE, this::obj2ExprTy, true);
        int conversion = this.lookupAndConvertInt(obj, AstState.T_F_CONVERSION, AstState.T_C_FORMATTEDVALUE);
        ExprTy formatSpec = this.lookupAndConvert(obj, AstState.T_F_FORMAT_SPEC, AstState.T_C_FORMATTEDVALUE, this::obj2ExprTy, false);
        return new ExprTy.FormattedValue(value, conversion, formatSpec, sourceRange);
    }

    ExprTy.JoinedStr obj2JoinedStr(Object obj, SourceRange sourceRange) {
        ExprTy[] values = this.lookupAndConvertSequence(obj, AstState.T_F_VALUES, AstState.T_C_JOINEDSTR, this::obj2ExprTy, ExprTy[]::new);
        return new ExprTy.JoinedStr(values, sourceRange);
    }

    ExprTy.Constant obj2Constant(Object obj, SourceRange sourceRange) {
        ConstantValue value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_CONSTANT, this::obj2ConstantValue, true);
        Object kind = this.lookupAndConvert(obj, AstState.T_F_KIND, AstState.T_C_CONSTANT, this::obj2string, false);
        return new ExprTy.Constant(value, kind, sourceRange);
    }

    ExprTy.Attribute obj2Attribute(Object obj, SourceRange sourceRange) {
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_ATTRIBUTE, this::obj2ExprTy, true);
        String attr = this.lookupAndConvert(obj, AstState.T_F_ATTR, AstState.T_C_ATTRIBUTE, this::obj2identifier, true);
        ExprContextTy context = this.lookupAndConvert(obj, AstState.T_F_CTX, AstState.T_C_ATTRIBUTE, this::obj2ExprContextTy, true);
        return new ExprTy.Attribute(value, attr, context, sourceRange);
    }

    ExprTy.Subscript obj2Subscript(Object obj, SourceRange sourceRange) {
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_SUBSCRIPT, this::obj2ExprTy, true);
        ExprTy slice = this.lookupAndConvert(obj, AstState.T_F_SLICE, AstState.T_C_SUBSCRIPT, this::obj2ExprTy, true);
        ExprContextTy context = this.lookupAndConvert(obj, AstState.T_F_CTX, AstState.T_C_SUBSCRIPT, this::obj2ExprContextTy, true);
        return new ExprTy.Subscript(value, slice, context, sourceRange);
    }

    ExprTy.Starred obj2Starred(Object obj, SourceRange sourceRange) {
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_STARRED, this::obj2ExprTy, true);
        ExprContextTy context = this.lookupAndConvert(obj, AstState.T_F_CTX, AstState.T_C_STARRED, this::obj2ExprContextTy, true);
        return new ExprTy.Starred(value, context, sourceRange);
    }

    ExprTy.Name obj2Name(Object obj, SourceRange sourceRange) {
        String id = this.lookupAndConvert(obj, AstState.T_F_ID, AstState.T_C_NAME, this::obj2identifier, true);
        ExprContextTy context = this.lookupAndConvert(obj, AstState.T_F_CTX, AstState.T_C_NAME, this::obj2ExprContextTy, true);
        return new ExprTy.Name(id, context, sourceRange);
    }

    ExprTy.List obj2List(Object obj, SourceRange sourceRange) {
        ExprTy[] elements = this.lookupAndConvertSequence(obj, AstState.T_F_ELTS, AstState.T_C_LIST, this::obj2ExprTy, ExprTy[]::new);
        ExprContextTy context = this.lookupAndConvert(obj, AstState.T_F_CTX, AstState.T_C_LIST, this::obj2ExprContextTy, true);
        return new ExprTy.List(elements, context, sourceRange);
    }

    ExprTy.Tuple obj2Tuple(Object obj, SourceRange sourceRange) {
        ExprTy[] elements = this.lookupAndConvertSequence(obj, AstState.T_F_ELTS, AstState.T_C_TUPLE, this::obj2ExprTy, ExprTy[]::new);
        ExprContextTy context = this.lookupAndConvert(obj, AstState.T_F_CTX, AstState.T_C_TUPLE, this::obj2ExprContextTy, true);
        return new ExprTy.Tuple(elements, context, sourceRange);
    }

    ExprTy.Slice obj2Slice(Object obj, SourceRange sourceRange) {
        ExprTy lower = this.lookupAndConvert(obj, AstState.T_F_LOWER, AstState.T_C_SLICE, this::obj2ExprTy, false);
        ExprTy upper = this.lookupAndConvert(obj, AstState.T_F_UPPER, AstState.T_C_SLICE, this::obj2ExprTy, false);
        ExprTy step = this.lookupAndConvert(obj, AstState.T_F_STEP, AstState.T_C_SLICE, this::obj2ExprTy, false);
        return new ExprTy.Slice(lower, upper, step, sourceRange);
    }

    ExprContextTy obj2ExprContextTy(Object obj) {
        if (Obj2Sst.isInstanceOf(obj, this.state.clsLoad)) {
            return ExprContextTy.Load;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsStore)) {
            return ExprContextTy.Store;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsDel)) {
            return ExprContextTy.Del;
        }
        throw this.unexpectedNodeType(AstState.T_T_EXPR_CONTEXT, obj);
    }

    BoolOpTy obj2BoolOpTy(Object obj) {
        if (Obj2Sst.isInstanceOf(obj, this.state.clsAnd)) {
            return BoolOpTy.And;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsOr)) {
            return BoolOpTy.Or;
        }
        throw this.unexpectedNodeType(AstState.T_T_BOOLOP, obj);
    }

    OperatorTy obj2OperatorTy(Object obj) {
        if (Obj2Sst.isInstanceOf(obj, this.state.clsAdd)) {
            return OperatorTy.Add;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsSub)) {
            return OperatorTy.Sub;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsMult)) {
            return OperatorTy.Mult;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsMatMult)) {
            return OperatorTy.MatMult;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsDiv)) {
            return OperatorTy.Div;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsMod)) {
            return OperatorTy.Mod;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsPow)) {
            return OperatorTy.Pow;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsLShift)) {
            return OperatorTy.LShift;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsRShift)) {
            return OperatorTy.RShift;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsBitOr)) {
            return OperatorTy.BitOr;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsBitXor)) {
            return OperatorTy.BitXor;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsBitAnd)) {
            return OperatorTy.BitAnd;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsFloorDiv)) {
            return OperatorTy.FloorDiv;
        }
        throw this.unexpectedNodeType(AstState.T_T_OPERATOR, obj);
    }

    UnaryOpTy obj2UnaryOpTy(Object obj) {
        if (Obj2Sst.isInstanceOf(obj, this.state.clsInvert)) {
            return UnaryOpTy.Invert;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsNot)) {
            return UnaryOpTy.Not;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsUAdd)) {
            return UnaryOpTy.UAdd;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsUSub)) {
            return UnaryOpTy.USub;
        }
        throw this.unexpectedNodeType(AstState.T_T_UNARYOP, obj);
    }

    CmpOpTy obj2CmpOpTy(Object obj) {
        if (Obj2Sst.isInstanceOf(obj, this.state.clsEq)) {
            return CmpOpTy.Eq;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsNotEq)) {
            return CmpOpTy.NotEq;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsLt)) {
            return CmpOpTy.Lt;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsLtE)) {
            return CmpOpTy.LtE;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsGt)) {
            return CmpOpTy.Gt;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsGtE)) {
            return CmpOpTy.GtE;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsIs)) {
            return CmpOpTy.Is;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsIsNot)) {
            return CmpOpTy.IsNot;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsIn)) {
            return CmpOpTy.In;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsNotIn)) {
            return CmpOpTy.NotIn;
        }
        throw this.unexpectedNodeType(AstState.T_T_CMPOP, obj);
    }

    ComprehensionTy obj2ComprehensionTy(Object obj) {
        ExprTy target = this.lookupAndConvert(obj, AstState.T_F_TARGET, AstState.T_T_COMPREHENSION, this::obj2ExprTy, true);
        ExprTy iter = this.lookupAndConvert(obj, AstState.T_F_ITER, AstState.T_T_COMPREHENSION, this::obj2ExprTy, true);
        ExprTy[] ifs = this.lookupAndConvertSequence(obj, AstState.T_F_IFS, AstState.T_T_COMPREHENSION, this::obj2ExprTy, ExprTy[]::new);
        boolean isAsync = this.lookupAndConvertBoolean(obj, AstState.T_F_IS_ASYNC, AstState.T_T_COMPREHENSION);
        SourceRange sourceRange = SourceRange.ARTIFICIAL_RANGE;
        return new ComprehensionTy(target, iter, ifs, isAsync, sourceRange);
    }

    ExceptHandlerTy obj2ExceptHandlerTy(Object obj) {
        if (obj == PNone.NONE) {
            return null;
        }
        int lineNo = this.lookupAndConvertInt(obj, AstState.T_F_LINENO, AstState.T_T_EXCEPTHANDLER);
        int colOffset = this.lookupAndConvertInt(obj, AstState.T_F_COL_OFFSET, AstState.T_T_EXCEPTHANDLER);
        int endLineno = this.lookupAndConvertIntOpt(obj, AstState.T_F_END_LINENO, AstState.T_T_EXCEPTHANDLER, lineNo);
        int endColOffset = this.lookupAndConvertIntOpt(obj, AstState.T_F_END_COL_OFFSET, AstState.T_T_EXCEPTHANDLER, colOffset);
        SourceRange sourceRange = new SourceRange(lineNo, colOffset, endLineno, endColOffset);
        if (Obj2Sst.isInstanceOf(obj, this.state.clsExceptHandler)) {
            return this.obj2ExceptHandler(obj, sourceRange);
        }
        throw this.unexpectedNodeType(AstState.T_T_EXCEPTHANDLER, obj);
    }

    ExceptHandlerTy.ExceptHandler obj2ExceptHandler(Object obj, SourceRange sourceRange) {
        ExprTy type = this.lookupAndConvert(obj, AstState.T_F_TYPE, AstState.T_C_EXCEPTHANDLER, this::obj2ExprTy, false);
        String name = this.lookupAndConvert(obj, AstState.T_F_NAME, AstState.T_C_EXCEPTHANDLER, this::obj2identifier, false);
        StmtTy[] body = this.lookupAndConvertSequence(obj, AstState.T_F_BODY, AstState.T_C_EXCEPTHANDLER, this::obj2StmtTy, StmtTy[]::new);
        return new ExceptHandlerTy.ExceptHandler(type, name, body, sourceRange);
    }

    ArgumentsTy obj2ArgumentsTy(Object obj) {
        ArgTy[] posOnlyArgs = this.lookupAndConvertSequence(obj, AstState.T_F_POSONLYARGS, AstState.T_T_ARGUMENTS, this::obj2ArgTy, ArgTy[]::new);
        ArgTy[] args = this.lookupAndConvertSequence(obj, AstState.T_F_ARGS, AstState.T_T_ARGUMENTS, this::obj2ArgTy, ArgTy[]::new);
        ArgTy varArg = this.lookupAndConvert(obj, AstState.T_F_VARARG, AstState.T_T_ARGUMENTS, this::obj2ArgTy, false);
        ArgTy[] kwOnlyArgs = this.lookupAndConvertSequence(obj, AstState.T_F_KWONLYARGS, AstState.T_T_ARGUMENTS, this::obj2ArgTy, ArgTy[]::new);
        ExprTy[] kwDefaults = this.lookupAndConvertSequence(obj, AstState.T_F_KW_DEFAULTS, AstState.T_T_ARGUMENTS, this::obj2ExprTy, ExprTy[]::new);
        ArgTy kwArg = this.lookupAndConvert(obj, AstState.T_F_KWARG, AstState.T_T_ARGUMENTS, this::obj2ArgTy, false);
        ExprTy[] defaults = this.lookupAndConvertSequence(obj, AstState.T_F_DEFAULTS, AstState.T_T_ARGUMENTS, this::obj2ExprTy, ExprTy[]::new);
        SourceRange sourceRange = SourceRange.ARTIFICIAL_RANGE;
        return new ArgumentsTy(posOnlyArgs, args, varArg, kwOnlyArgs, kwDefaults, kwArg, defaults, sourceRange);
    }

    ArgTy obj2ArgTy(Object obj) {
        String arg = this.lookupAndConvert(obj, AstState.T_F_ARG, AstState.T_T_ARG, this::obj2identifier, true);
        ExprTy annotation = this.lookupAndConvert(obj, AstState.T_F_ANNOTATION, AstState.T_T_ARG, this::obj2ExprTy, false);
        Object typeComment = this.lookupAndConvert(obj, AstState.T_F_TYPE_COMMENT, AstState.T_T_ARG, this::obj2string, false);
        int lineNo = this.lookupAndConvertInt(obj, AstState.T_F_LINENO, AstState.T_T_ARG);
        int colOffset = this.lookupAndConvertInt(obj, AstState.T_F_COL_OFFSET, AstState.T_T_ARG);
        int endLineno = this.lookupAndConvertIntOpt(obj, AstState.T_F_END_LINENO, AstState.T_T_ARG, lineNo);
        int endColOffset = this.lookupAndConvertIntOpt(obj, AstState.T_F_END_COL_OFFSET, AstState.T_T_ARG, colOffset);
        SourceRange sourceRange = new SourceRange(lineNo, colOffset, endLineno, endColOffset);
        return new ArgTy(arg, annotation, typeComment, sourceRange);
    }

    KeywordTy obj2KeywordTy(Object obj) {
        String arg = this.lookupAndConvert(obj, AstState.T_F_ARG, AstState.T_T_KEYWORD, this::obj2identifier, false);
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_T_KEYWORD, this::obj2ExprTy, true);
        int lineNo = this.lookupAndConvertInt(obj, AstState.T_F_LINENO, AstState.T_T_KEYWORD);
        int colOffset = this.lookupAndConvertInt(obj, AstState.T_F_COL_OFFSET, AstState.T_T_KEYWORD);
        int endLineno = this.lookupAndConvertIntOpt(obj, AstState.T_F_END_LINENO, AstState.T_T_KEYWORD, lineNo);
        int endColOffset = this.lookupAndConvertIntOpt(obj, AstState.T_F_END_COL_OFFSET, AstState.T_T_KEYWORD, colOffset);
        SourceRange sourceRange = new SourceRange(lineNo, colOffset, endLineno, endColOffset);
        return new KeywordTy(arg, value, sourceRange);
    }

    AliasTy obj2AliasTy(Object obj) {
        String name = this.lookupAndConvert(obj, AstState.T_F_NAME, AstState.T_T_ALIAS, this::obj2identifier, true);
        String asName = this.lookupAndConvert(obj, AstState.T_F_ASNAME, AstState.T_T_ALIAS, this::obj2identifier, false);
        int lineNo = this.lookupAndConvertInt(obj, AstState.T_F_LINENO, AstState.T_T_ALIAS);
        int colOffset = this.lookupAndConvertInt(obj, AstState.T_F_COL_OFFSET, AstState.T_T_ALIAS);
        int endLineno = this.lookupAndConvertIntOpt(obj, AstState.T_F_END_LINENO, AstState.T_T_ALIAS, lineNo);
        int endColOffset = this.lookupAndConvertIntOpt(obj, AstState.T_F_END_COL_OFFSET, AstState.T_T_ALIAS, colOffset);
        SourceRange sourceRange = new SourceRange(lineNo, colOffset, endLineno, endColOffset);
        return new AliasTy(name, asName, sourceRange);
    }

    WithItemTy obj2WithItemTy(Object obj) {
        ExprTy contextExpr = this.lookupAndConvert(obj, AstState.T_F_CONTEXT_EXPR, AstState.T_T_WITHITEM, this::obj2ExprTy, true);
        ExprTy optionalVars = this.lookupAndConvert(obj, AstState.T_F_OPTIONAL_VARS, AstState.T_T_WITHITEM, this::obj2ExprTy, false);
        SourceRange sourceRange = SourceRange.ARTIFICIAL_RANGE;
        return new WithItemTy(contextExpr, optionalVars, sourceRange);
    }

    MatchCaseTy obj2MatchCaseTy(Object obj) {
        PatternTy pattern = this.lookupAndConvert(obj, AstState.T_F_PATTERN, AstState.T_T_MATCH_CASE, this::obj2PatternTy, true);
        ExprTy guard = this.lookupAndConvert(obj, AstState.T_F_GUARD, AstState.T_T_MATCH_CASE, this::obj2ExprTy, false);
        StmtTy[] body = this.lookupAndConvertSequence(obj, AstState.T_F_BODY, AstState.T_T_MATCH_CASE, this::obj2StmtTy, StmtTy[]::new);
        SourceRange sourceRange = SourceRange.ARTIFICIAL_RANGE;
        return new MatchCaseTy(pattern, guard, body, sourceRange);
    }

    PatternTy obj2PatternTy(Object obj) {
        if (obj == PNone.NONE) {
            return null;
        }
        int lineNo = this.lookupAndConvertInt(obj, AstState.T_F_LINENO, AstState.T_T_PATTERN);
        int colOffset = this.lookupAndConvertInt(obj, AstState.T_F_COL_OFFSET, AstState.T_T_PATTERN);
        int endLineno = this.lookupAndConvertInt(obj, AstState.T_F_END_LINENO, AstState.T_T_PATTERN);
        int endColOffset = this.lookupAndConvertInt(obj, AstState.T_F_END_COL_OFFSET, AstState.T_T_PATTERN);
        SourceRange sourceRange = new SourceRange(lineNo, colOffset, endLineno, endColOffset);
        if (Obj2Sst.isInstanceOf(obj, this.state.clsMatchValue)) {
            return this.obj2MatchValue(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsMatchSingleton)) {
            return this.obj2MatchSingleton(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsMatchSequence)) {
            return this.obj2MatchSequence(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsMatchMapping)) {
            return this.obj2MatchMapping(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsMatchClass)) {
            return this.obj2MatchClass(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsMatchStar)) {
            return this.obj2MatchStar(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsMatchAs)) {
            return this.obj2MatchAs(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsMatchOr)) {
            return this.obj2MatchOr(obj, sourceRange);
        }
        throw this.unexpectedNodeType(AstState.T_T_PATTERN, obj);
    }

    PatternTy.MatchValue obj2MatchValue(Object obj, SourceRange sourceRange) {
        ExprTy value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_MATCHVALUE, this::obj2ExprTy, true);
        return new PatternTy.MatchValue(value, sourceRange);
    }

    PatternTy.MatchSingleton obj2MatchSingleton(Object obj, SourceRange sourceRange) {
        ConstantValue value = this.lookupAndConvert(obj, AstState.T_F_VALUE, AstState.T_C_MATCHSINGLETON, this::obj2ConstantValue, true);
        return new PatternTy.MatchSingleton(value, sourceRange);
    }

    PatternTy.MatchSequence obj2MatchSequence(Object obj, SourceRange sourceRange) {
        PatternTy[] patterns = this.lookupAndConvertSequence(obj, AstState.T_F_PATTERNS, AstState.T_C_MATCHSEQUENCE, this::obj2PatternTy, PatternTy[]::new);
        return new PatternTy.MatchSequence(patterns, sourceRange);
    }

    PatternTy.MatchMapping obj2MatchMapping(Object obj, SourceRange sourceRange) {
        ExprTy[] keys = this.lookupAndConvertSequence(obj, AstState.T_F_KEYS, AstState.T_C_MATCHMAPPING, this::obj2ExprTy, ExprTy[]::new);
        PatternTy[] patterns = this.lookupAndConvertSequence(obj, AstState.T_F_PATTERNS, AstState.T_C_MATCHMAPPING, this::obj2PatternTy, PatternTy[]::new);
        String rest = this.lookupAndConvert(obj, AstState.T_F_REST, AstState.T_C_MATCHMAPPING, this::obj2identifier, false);
        return new PatternTy.MatchMapping(keys, patterns, rest, sourceRange);
    }

    PatternTy.MatchClass obj2MatchClass(Object obj, SourceRange sourceRange) {
        ExprTy cls = this.lookupAndConvert(obj, AstState.T_F_CLS, AstState.T_C_MATCHCLASS, this::obj2ExprTy, true);
        PatternTy[] patterns = this.lookupAndConvertSequence(obj, AstState.T_F_PATTERNS, AstState.T_C_MATCHCLASS, this::obj2PatternTy, PatternTy[]::new);
        String[] kwdAttrs = this.lookupAndConvertSequence(obj, AstState.T_F_KWD_ATTRS, AstState.T_C_MATCHCLASS, this::obj2identifier, String[]::new);
        PatternTy[] kwdPatterns = this.lookupAndConvertSequence(obj, AstState.T_F_KWD_PATTERNS, AstState.T_C_MATCHCLASS, this::obj2PatternTy, PatternTy[]::new);
        return new PatternTy.MatchClass(cls, patterns, kwdAttrs, kwdPatterns, sourceRange);
    }

    PatternTy.MatchStar obj2MatchStar(Object obj, SourceRange sourceRange) {
        String name = this.lookupAndConvert(obj, AstState.T_F_NAME, AstState.T_C_MATCHSTAR, this::obj2identifier, false);
        return new PatternTy.MatchStar(name, sourceRange);
    }

    PatternTy.MatchAs obj2MatchAs(Object obj, SourceRange sourceRange) {
        PatternTy pattern = this.lookupAndConvert(obj, AstState.T_F_PATTERN, AstState.T_C_MATCHAS, this::obj2PatternTy, false);
        String name = this.lookupAndConvert(obj, AstState.T_F_NAME, AstState.T_C_MATCHAS, this::obj2identifier, false);
        return new PatternTy.MatchAs(pattern, name, sourceRange);
    }

    PatternTy.MatchOr obj2MatchOr(Object obj, SourceRange sourceRange) {
        PatternTy[] patterns = this.lookupAndConvertSequence(obj, AstState.T_F_PATTERNS, AstState.T_C_MATCHOR, this::obj2PatternTy, PatternTy[]::new);
        return new PatternTy.MatchOr(patterns, sourceRange);
    }

    TypeIgnoreTy obj2TypeIgnoreTy(Object obj) {
        if (obj == PNone.NONE) {
            return null;
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsTypeIgnore)) {
            return this.obj2TypeIgnore(obj);
        }
        throw this.unexpectedNodeType(AstState.T_T_TYPE_IGNORE, obj);
    }

    TypeIgnoreTy.TypeIgnore obj2TypeIgnore(Object obj) {
        int lineNo = this.lookupAndConvertInt(obj, AstState.T_F_LINENO, AstState.T_C_TYPEIGNORE);
        Object tag = this.lookupAndConvert(obj, AstState.T_F_TAG, AstState.T_C_TYPEIGNORE, this::obj2string, true);
        SourceRange sourceRange = SourceRange.ARTIFICIAL_RANGE;
        return new TypeIgnoreTy.TypeIgnore(lineNo, tag, sourceRange);
    }

    TypeParamTy obj2TypeParamTy(Object obj) {
        if (obj == PNone.NONE) {
            return null;
        }
        int lineNo = this.lookupAndConvertInt(obj, AstState.T_F_LINENO, AstState.T_T_TYPE_PARAM);
        int colOffset = this.lookupAndConvertInt(obj, AstState.T_F_COL_OFFSET, AstState.T_T_TYPE_PARAM);
        int endLineno = this.lookupAndConvertInt(obj, AstState.T_F_END_LINENO, AstState.T_T_TYPE_PARAM);
        int endColOffset = this.lookupAndConvertInt(obj, AstState.T_F_END_COL_OFFSET, AstState.T_T_TYPE_PARAM);
        SourceRange sourceRange = new SourceRange(lineNo, colOffset, endLineno, endColOffset);
        if (Obj2Sst.isInstanceOf(obj, this.state.clsTypeVar)) {
            return this.obj2TypeVar(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsParamSpec)) {
            return this.obj2ParamSpec(obj, sourceRange);
        }
        if (Obj2Sst.isInstanceOf(obj, this.state.clsTypeVarTuple)) {
            return this.obj2TypeVarTuple(obj, sourceRange);
        }
        throw this.unexpectedNodeType(AstState.T_T_TYPE_PARAM, obj);
    }

    TypeParamTy.TypeVar obj2TypeVar(Object obj, SourceRange sourceRange) {
        String name = this.lookupAndConvert(obj, AstState.T_F_NAME, AstState.T_C_TYPEVAR, this::obj2identifier, true);
        ExprTy bound = this.lookupAndConvert(obj, AstState.T_F_BOUND, AstState.T_C_TYPEVAR, this::obj2ExprTy, false);
        return new TypeParamTy.TypeVar(name, bound, sourceRange);
    }

    TypeParamTy.ParamSpec obj2ParamSpec(Object obj, SourceRange sourceRange) {
        String name = this.lookupAndConvert(obj, AstState.T_F_NAME, AstState.T_C_PARAMSPEC, this::obj2identifier, true);
        return new TypeParamTy.ParamSpec(name, sourceRange);
    }

    TypeParamTy.TypeVarTuple obj2TypeVarTuple(Object obj, SourceRange sourceRange) {
        String name = this.lookupAndConvert(obj, AstState.T_F_NAME, AstState.T_C_TYPEVARTUPLE, this::obj2identifier, true);
        return new TypeParamTy.TypeVarTuple(name, sourceRange);
    }
}

