/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.escape;

import java.util.Locale;
import org.firebirdsql.jdbc.escape.FBSQLParseException;
import org.firebirdsql.jdbc.escape.IntervalMapping;
import org.firebirdsql.jdbc.escape.SQLFunction;

final class TimestampDiffFunction
implements SQLFunction {
    TimestampDiffFunction() {
    }

    @Override
    public String apply(String ... parameters) throws FBSQLParseException {
        if (parameters.length != 3) {
            throw new FBSQLParseException("Expected 3 parameters for TIMESTAMPDIFF, received " + parameters.length);
        }
        String jdbcIntervalName = parameters[0].trim().toUpperCase(Locale.ROOT);
        if ("SQL_TSI_QUARTER".equals(jdbcIntervalName)) {
            return "(DATEDIFF(MONTH," + parameters[1] + "," + parameters[2] + ")/3)";
        }
        if ("SQL_TSI_FRAC_SECOND".equals(jdbcIntervalName)) {
            return "CAST(DATEDIFF(MILLISECOND," + parameters[1] + "," + parameters[2] + ")*1.0e6 AS BIGINT)";
        }
        String fbIntervalName = IntervalMapping.getFirebirdInterval(jdbcIntervalName);
        return "DATEDIFF(" + fbIntervalName + "," + parameters[1] + "," + parameters[2] + ")";
    }
}

