/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.sym;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import tools.jackson.core.sym.HashedMatcherBase;
import tools.jackson.core.util.Named;

public class SimpleNameMatcher
extends HashedMatcherBase
implements Serializable {
    private static final long serialVersionUID = 1L;

    private SimpleNameMatcher(Locale locale, String[] names, int[] offsets, int mask) {
        super(locale, names, offsets, mask, null, null);
    }

    protected SimpleNameMatcher(SimpleNameMatcher base, String[] nameLookup) {
        super((HashedMatcherBase)base, nameLookup);
    }

    protected SimpleNameMatcher(SimpleNameMatcher primary, SimpleNameMatcher secondary) {
        super((HashedMatcherBase)primary, secondary);
    }

    public static SimpleNameMatcher constructFrom(Locale locale, List<Named> propertyNames, boolean alreadyInterned) {
        return SimpleNameMatcher.construct(locale, SimpleNameMatcher.stringsFromNames(propertyNames, alreadyInterned));
    }

    public static SimpleNameMatcher construct(Locale locale, List<String> propertyNames) {
        int nameCount = propertyNames.size();
        int hashSize = SimpleNameMatcher._findSize(nameCount);
        int allocSize = hashSize + (hashSize >> 1);
        String[] names = new String[allocSize];
        int[] offsets = new int[allocSize];
        Arrays.fill(offsets, -2);
        int mask = hashSize - 1;
        int spillPtr = names.length;
        int fcount = propertyNames.size();
        for (int i = 0; i < fcount; ++i) {
            String name = propertyNames.get(i);
            if (name == null) continue;
            int ix = SimpleNameMatcher._hash(name.hashCode(), mask);
            if (names[ix] == null) {
                names[ix] = name;
                offsets[ix] = i;
                continue;
            }
            if (names[ix = mask + 1 + (ix >> 1)] == null) {
                names[ix] = name;
                offsets[ix] = i;
                continue;
            }
            if (names.length == spillPtr) {
                int newLength = names.length + 4;
                names = Arrays.copyOf(names, newLength);
                offsets = Arrays.copyOf(offsets, newLength);
            }
            names[spillPtr] = name;
            offsets[spillPtr] = i;
            ++spillPtr;
        }
        return new SimpleNameMatcher(locale, names, offsets, mask);
    }

    public static SimpleNameMatcher constructCaseInsensitive(Locale locale, List<Named> propertyNames, boolean alreadyInterned) {
        return SimpleNameMatcher.constructCaseInsensitive(locale, SimpleNameMatcher.stringsFromNames(propertyNames, alreadyInterned));
    }

    public static SimpleNameMatcher constructCaseInsensitive(Locale locale, List<String> names) {
        return new SimpleNameMatcher(SimpleNameMatcher.construct(locale, names), SimpleNameMatcher.construct(locale, SimpleNameMatcher._lc(locale, names)));
    }

    @Override
    public int matchByQuad(int q1) {
        return -2;
    }

    @Override
    public int matchByQuad(int q1, int q2) {
        return -2;
    }

    @Override
    public int matchByQuad(int q1, int q2, int q3) {
        return -2;
    }

    @Override
    public int matchByQuad(int[] q, int qlen) {
        return -2;
    }
}

