/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.utils.StickyScrollbarAdjustmentListener;
import org.zaproxy.zap.utils.TableExportAction;

public class ZapTable
extends JXTable {
    private static final long serialVersionUID = 8303870012122236918L;
    private static final String COLUMN_NAME = "ColumnName";
    private static final String COLUMN_INDEX = "ColumnIndex";
    private static final String COLUMN_MODEL_INDEX = "ColumnModelIndex";
    private static final String COLUMN_CONFIGURATION = "ColumnConfiguration_";
    private static final String COLUMN = "Column";
    private boolean autoScroll;
    private AutoScrollAction autoScrollAction;
    private StickyScrollbarAdjustmentListener autoScrollScrollbarAdjustmentListener;
    private String persistanceIdentifier;
    protected TableColumnConfiguration config = null;

    public ZapTable() {
        this.init();
    }

    public ZapTable(TableModel dataModel) {
        super(dataModel);
        this.init();
    }

    public void persistColumnConfiguration() {
        if (StringUtils.isEmpty((CharSequence)this.persistanceIdentifier)) {
            return;
        }
        this.config = new TableColumnConfiguration();
        List columns = ((DefaultTableColumnModelExt)this.columnModel).getColumns(false);
        for (TableColumn column : columns) {
            if (!this.getColumnExt(column.getIdentifier()).isVisible()) continue;
            int index = columns.indexOf(column);
            this.config.addColumn(new TableColumnConfig(column.getIdentifier().toString(), index, column.getModelIndex()));
        }
        this.config.saveToConfig(this.persistanceIdentifier);
    }

    protected void loadColumnConfiguration(String persistanceIdentifier) {
        TableColumnConfiguration config = TableColumnConfiguration.loadFromConfig(persistanceIdentifier);
        this.persistanceIdentifier = persistanceIdentifier;
        this.config = config;
        if (config != null) {
            config.apply(this);
        }
    }

    protected void applyDefaultColumnConfigurations() {
    }

    private void init() {
        this.setDoubleBuffered(true);
        this.setColumnControlVisible(true);
        JComponent columnControl = this.getColumnControl();
        if (columnControl instanceof ZapColumnControlButton) {
            TableExportAction<ZapTable> exportAction;
            ZapColumnControlButton zapColumnControl = (ZapColumnControlButton)((Object)columnControl);
            this.autoScrollAction = this.createAutoScrollAction();
            if (this.autoScrollAction != null) {
                zapColumnControl.addAction((Action)((Object)this.autoScrollAction));
            }
            if ((exportAction = this.createTableExportAction()) != null) {
                zapColumnControl.addAction(exportAction);
            }
            zapColumnControl.addAction((Action)((Object)new ResetColumnsToDefaultAction(this)));
            zapColumnControl.populatePopup();
        }
        this.setAutoScrollOnNewValues(true);
    }

    protected AutoScrollAction createAutoScrollAction() {
        return new AutoScrollAction(this);
    }

    protected AutoScrollAction getAutoScrollAction() {
        return this.autoScrollAction;
    }

    protected TableExportAction<ZapTable> createTableExportAction() {
        return new TableExportAction<ZapTable>(this);
    }

    public void setAutoScrollOnNewValues(boolean autoScroll) {
        if (this.autoScroll == autoScroll) {
            return;
        }
        if (this.autoScroll) {
            this.removeAutoScrollScrollbarAdjustmentListener();
        }
        this.autoScroll = autoScroll;
        if (this.autoScrollAction != null) {
            this.autoScrollAction.putValue("SwingSelectedKey", autoScroll);
        }
        if (this.autoScroll) {
            this.addAutoScrollScrollbarAdjustmentListener();
        }
    }

    public boolean isAutoScrollOnNewValues() {
        return this.autoScroll;
    }

    private void addAutoScrollScrollbarAdjustmentListener() {
        JScrollPane scrollPane = this.getEnclosingScrollPane();
        if (scrollPane != null && this.autoScrollScrollbarAdjustmentListener == null) {
            this.autoScrollScrollbarAdjustmentListener = new StickyScrollbarAdjustmentListener();
            scrollPane.getVerticalScrollBar().addAdjustmentListener(this.autoScrollScrollbarAdjustmentListener);
        }
    }

    private void removeAutoScrollScrollbarAdjustmentListener() {
        JScrollPane scrollPane = this.getEnclosingScrollPane();
        if (scrollPane != null && this.autoScrollScrollbarAdjustmentListener != null) {
            scrollPane.getVerticalScrollBar().removeAdjustmentListener(this.autoScrollScrollbarAdjustmentListener);
            this.autoScrollScrollbarAdjustmentListener = null;
        }
    }

    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        if (this.isAutoScrollOnNewValues()) {
            this.addAutoScrollScrollbarAdjustmentListener();
        }
    }

    protected void unconfigureEnclosingScrollPane() {
        super.unconfigureEnclosingScrollPane();
        if (this.isAutoScrollOnNewValues()) {
            this.removeAutoScrollScrollbarAdjustmentListener();
        }
    }

    protected JScrollPane getEnclosingScrollPane() {
        Container gp;
        Container p = SwingUtilities.getUnwrappedParent((Component)((Object)this));
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || SwingUtilities.getUnwrappedView(viewport) != this) {
                return null;
            }
            return scrollPane;
        }
        return null;
    }

    public Point getPopupLocation(MouseEvent event) {
        if (event != null) {
            int row = this.rowAtPoint(event.getPoint());
            if (row < 0) {
                this.getSelectionModel().clearSelection();
            } else if (!this.getSelectionModel().isSelectedIndex(row)) {
                this.getSelectionModel().setSelectionInterval(row, row);
            }
        }
        return super.getPopupLocation(event);
    }

    protected JComponent createDefaultColumnControl() {
        return new ZapColumnControlButton(this);
    }

    private static class TableColumnConfiguration {
        private List<TableColumnConfig> columnConfigs = new ArrayList<TableColumnConfig>();

        private TableColumnConfiguration() {
        }

        public List<TableColumnConfig> getColumnConfigs() {
            return this.columnConfigs;
        }

        public void addColumn(TableColumnConfig column) {
            TableColumnConfig found = this.findColumnByName(column.getName());
            if (found == null) {
                this.columnConfigs.add(column);
            }
        }

        public void apply(ZapTable table) {
            this.rearrangeColumns(table);
            this.hideInvisibleColumns(table);
        }

        private void rearrangeColumns(ZapTable table) {
            for (int i = 0; i < this.columnConfigs.size(); ++i) {
                TableColumnConfig meta = this.columnConfigs.get(i);
                TableColumn column = this.findColumnByIndex(table, meta.getModelIndex());
                if (column == null) continue;
                int columnIndex = table.columnModel.getColumnIndex(column.getIdentifier());
                table.moveColumn(columnIndex, meta.getIndex());
            }
        }

        private TableColumn findColumnByIndex(ZapTable table, int modelIndex) {
            List columns = ((DefaultTableColumnModelExt)table.columnModel).getColumns(true);
            for (int i = 0; i < columns.size(); ++i) {
                if (((TableColumn)columns.get(i)).getModelIndex() != modelIndex) continue;
                return (TableColumn)columns.get(i);
            }
            return null;
        }

        private void hideInvisibleColumns(ZapTable table) {
            List columns = ((DefaultTableColumnModelExt)table.columnModel).getColumns(true);
            for (int i = 0; i < columns.size(); ++i) {
                TableColumn column = (TableColumn)columns.get(i);
                TableColumnConfig meta = this.findColumnConfigByIndex(column.getModelIndex());
                if (meta != null) continue;
                table.getColumnExt(column.getIdentifier()).setVisible(false);
            }
        }

        private TableColumnConfig findColumnByName(String name) {
            for (TableColumnConfig t : this.columnConfigs) {
                if (!t.getName().equals(name)) continue;
                return t;
            }
            return null;
        }

        private TableColumnConfig findColumnConfigByIndex(int modelIndex) {
            for (TableColumnConfig t : this.columnConfigs) {
                if (t.getModelIndex() != modelIndex) continue;
                return t;
            }
            return null;
        }

        public static TableColumnConfiguration loadFromConfig(String persistanceIdentifier) {
            FileConfiguration config = Model.getSingleton().getOptionsParam().getConfig();
            TableColumnConfiguration tableColumnConfig = new TableColumnConfiguration();
            int i = 0;
            while (true) {
                String elementBaseKey = TableColumnConfiguration.getElementBaseKey(persistanceIdentifier, i);
                Object columnName = config.getProperty(elementBaseKey + ZapTable.COLUMN_NAME);
                Object columnIndex = config.getProperty(elementBaseKey + ZapTable.COLUMN_INDEX);
                Object modelIndex = config.getProperty(elementBaseKey + ZapTable.COLUMN_MODEL_INDEX);
                if (StringUtils.isEmpty((CharSequence)((String)columnName))) break;
                tableColumnConfig.addColumn(new TableColumnConfig(columnName.toString(), Integer.parseInt(columnIndex.toString()), Integer.parseInt(modelIndex.toString())));
                ++i;
            }
            if (tableColumnConfig.getColumnConfigs().size() == 0) {
                return null;
            }
            return tableColumnConfig;
        }

        private static String getElementBaseKey(String persistanceIdentifier, int index) {
            return ZapTable.COLUMN_CONFIGURATION + persistanceIdentifier + "Column(" + index + ").";
        }

        private static FileConfiguration getConfig() {
            return Model.getSingleton().getOptionsParam().getConfig();
        }

        public void saveToConfig(String persistanceIdentifier) {
            TableColumnConfiguration.clearConfigSection(persistanceIdentifier);
            for (int i = 0; i < this.columnConfigs.size(); ++i) {
                TableColumnConfig column = this.columnConfigs.get(i);
                String elementBaseKey = TableColumnConfiguration.getElementBaseKey(persistanceIdentifier, i);
                TableColumnConfiguration.getConfig().setProperty(elementBaseKey + ZapTable.COLUMN_NAME, (Object)column.getName());
                TableColumnConfiguration.getConfig().setProperty(elementBaseKey + ZapTable.COLUMN_INDEX, (Object)column.getIndex());
                TableColumnConfiguration.getConfig().setProperty(elementBaseKey + ZapTable.COLUMN_MODEL_INDEX, (Object)column.getModelIndex());
            }
        }

        private static void clearConfigSection(String persistanceIdentifier) {
            TableColumnConfiguration tableColumnConfig = TableColumnConfiguration.loadFromConfig(persistanceIdentifier);
            if (tableColumnConfig == null) {
                return;
            }
            HierarchicalConfiguration config = (HierarchicalConfiguration)TableColumnConfiguration.getConfig();
            config.clearTree(ZapTable.COLUMN_CONFIGURATION + persistanceIdentifier);
        }
    }

    private static class TableColumnConfig {
        private String name;
        private int index;
        private int modelIndex;

        TableColumnConfig(String name, int index, int modelIndex) {
            this.setName(name);
            this.setIndex(index);
            this.setModelIndex(modelIndex);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getModelIndex() {
            return this.modelIndex;
        }

        public void setModelIndex(int modelIndex) {
            this.modelIndex = modelIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableColumnConfig that = (TableColumnConfig)o;
            if (this.index != that.index) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.index;
            return result;
        }
    }

    protected static class ZapColumnControlButton
    extends ColumnControlButton {
        private static final long serialVersionUID = -2888568545235496369L;
        private List<Action> customActions;

        public ZapColumnControlButton(JXTable table) {
            super(table);
        }

        public ZapColumnControlButton(JXTable table, Icon icon) {
            super(table, icon);
        }

        public void populatePopup() {
            super.populatePopup();
            if (this.customActions != null && this.popup instanceof ColumnControlButton.DefaultColumnControlPopup) {
                ((ColumnControlButton.DefaultColumnControlPopup)this.popup).addAdditionalActionItems(this.customActions);
            }
        }

        public void addAction(Action action) {
            if (this.customActions == null) {
                this.customActions = new ArrayList<Action>(1);
            }
            this.customActions.add(action);
        }
    }

    protected static class AutoScrollAction
    extends AbstractActionExt {
        private static final long serialVersionUID = 5518182106427836717L;
        private final ZapTable table;

        public AutoScrollAction(ZapTable table) {
            super(Constant.messages.getString("view.table.autoscroll.label"));
            this.putValue("ShortDescription", Constant.messages.getString("view.table.autoscroll.tooltip"));
            this.table = table;
        }

        public AutoScrollAction(String label, Icon icon, ZapTable table) {
            super(label, icon);
            this.table = table;
        }

        public boolean isStateAction() {
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            this.table.setAutoScrollOnNewValues(!this.table.isAutoScrollOnNewValues());
        }
    }

    protected static class ResetColumnsToDefaultAction
    extends AbstractActionExt {
        private static final long serialVersionUID = 8724735213507882662L;
        private final ZapTable table;

        public ResetColumnsToDefaultAction(ZapTable table) {
            super(Constant.messages.getString("view.table.resetColumns.label"));
            this.putValue("ShortDescription", Constant.messages.getString("view.table.resetColumns.tooltip"));
            this.table = table;
        }

        public boolean isStateAction() {
            return false;
        }

        public void actionPerformed(ActionEvent e) {
            this.table.createDefaultColumnsFromModel();
            this.table.applyDefaultColumnConfigurations();
        }
    }
}

