package App::Manoc::Search::Item::Group;
#ABSTRACT: A group of result items

use Moose;

our $VERSION = '2.99.2'; ##TRIAL VERSION

extends 'App::Manoc::Search::Item';

has '+item_type' => ( default => 'group' );


has 'items' => (
    is      => 'ro',
    isa     => 'ArrayRef',
    default => sub { [] },
    writer  => '_items',
);


sub add_item {
    my ( $self, $item ) = @_;

    push @{ $self->items }, $item;
}


sub sort_items {
    my $self = shift;

    my @l = sort { $b->timestamp <=> $a->timestamp } @{ $self->items };
    $self->_items( \@l );
}


override load_widgets => sub {
    my $self = shift;

    foreach my $i ( @{ $self->items } ) {
        $i->load_widgets;
    }
    super();
};

no Moose;
__PACKAGE__->meta->make_immutable;

__END__

=pod

=head1 NAME

App::Manoc::Search::Item::Group - A group of result items

=head1 VERSION

version 2.99.2

=head1 ATTRIBUTES

=head2 items

The items in this group.

=head1 METHODS

=head2 add_item

Add a result item to the group

=head2 sort_items

Sort items by timestamp

=head2 load_widgets

Load widget for all items in the group.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
