use strict;
use warnings;
use Test::More tests => 68;
use Digest::SHAvite3 qw(shavite3_256 shavite3_256_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::SHAvite3->new(256)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            shavite3_256_hex($data), $digest,
            "shavite3_256_hex: $len bits of $msg"
        );
        ok(
            shavite3_256($data) eq pack('H*', $digest),
            "shavite3_256: $len bits of $msg"
        );
    }

    my $md = Digest::SHAvite3->new(256)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|08C5825AF2E9E5947286A8FE208BD5F8C6A7C8E4DA598947D7FF8EDA0FCD2BD7
00|8B9B2D57FEA66A7BCD2D591350643C7AFB70FBAB5EB99BFA8C931FBA09044AB9
C0|A04358188E2A02D0D0E93EFA865FB6773B7E33F17702076EDBDE75D5EB92C73D
C0|DF0D9D29D10A69CF2983E005534F84DF6BA56C919D48ED5DD3525000F3B2C992
80|9DD079C0CBD311F134BAF698FCD390FA918172DB056547D0C70A7CF9A6DCA5AA
48|D98E89D7C56270D42953BAC64E09B47374000BC2648C33985C0B3D8740CF2DF4
50|CC143468F9F16E19495930E5663DDDEAFC362E01DA9FF162E7258324A6CCF65D
98|5FD327C7CCA7AE7B6497D79CE44CCBD362C8A5F1839C097A2034AC9F38570A93
CC|A0EE13AF2658A165434E3B5AFE81CC053CB051CB08A40C0768A77209D10EFF86
9800|5EFF23EB5E46108880FDAE72F820EDE41E5F1A4393746AAF19FCBA7965D78D13
9D40|EA9ECF7A6F9AC33D7E2C0361426E0872374DBF1961EA0E6A9BDD4690B04750A1
AA80|882551D7D2AF44ECA624F8015F5967F4A8FBC91E25D2B24CE62CEB9D14ED3D84
9830|B653428DF9DD60CAB9037C9E5FB9F872D2C6A81867FCEAFC23539AD58DF77134
5030|6603A1180DA66AB2B1F535F2217948660CD6AD1836175833B2D3F979C040B7CD
4D24|AD380A4692E1C2860BF064AB098A1541029C62FDCA76D706A2C1988882A22D4A
CBDE|01918993FDED162A9DFEADF4BCE42F69304538F8FE2BEBFC71C1B698A014D4BA
41FB|D14CBCF9314108921E1118E9749E6FD1162A79A424EF383ADC311CAC4C662412
4FF400|CF745FF681EB24DDABF06F1516AC0463CDF1E965455A9972C9E7C01615ECE88D
FD0440|6115ACB870B8F82E8E32B444D49E9D22A48D343E3B2497CC92E0FB73ED19838F
424D00|5FA4B027B58B7FD852FC73A9362CF579E6ABAF88D194F4570FD4B675B0567C63
3FDEE0|65DFF32E7A73528469430B3F3E7F5C978569148FC4F051A95AC20108F68ADBCF
335768|D6C925D980A647A0511953FA9367E61A7E58261FFE141BA74E7789F7E4ECEC0F
051E7C|3CB32F797B78C3F7F57B209A1FC5DF8A0C80A4E40285E5E02CC915DDC4BB6D20
717F8C|299AA82BA4AF6DFA300B742D779602E99B18610B2E45246085E536A473D3505E
1F877C|CDCE33F661886FE9F63382C6A3E40B0DE15F1B164DFF83F5EEA0288F2BF39214
EB35CF80|2C7BE8572374E8DEE2086CE0639B181A52338C2F3A936BA056B7F74EA472C8EB
B406C480|4EF31F2966D5301BBEB1C6FCD4AF138D1328EB0C016F1DFEFC3933603C7CB85C
CEE88040|BCD9BE2AAC520C3B3ED95A3C60100FC8FAEB1348A2367DDF6BBE14DF1F3358BA
C584DB70|06793476753679D2547FAA615C3CEDD9F040861774EBF99C60F1AF77F5C55162
53587BC8|3499BB45839F20542A953EA16468EC6BCAEC4F6057C7E3277976CEC1A1025605
69A305B0|82BA3C7C86EC9C81A0318D8E9448E54751864EF583E5F680AABA0B5DE859C128
C9375ECE|482ED56AD93FDD2056B4366122E98C06F6698E4DE930B718D98A4E61F38E8F62
C1ECFDFC|A4879CCC8107E9E508B1E6D992A9F8B77405BE2EFCA7E03A719CE8AC1E8F6673
8D73E8A280|22BCF0E8581569E382F6FACDE9DCC9700CE429BBD225022E3DBC21BED8D39E45
06F2522080|E9F50FA4BF85FCD4F40250285EC5F93E7E08876D6A5121EC3B41371D69297403
3EF6C36F20|4FD746F7D154566AEC3DB14F582D0BD7853978EC435F00AEC5CCCACB141017DC
0127A1D340|2D5E9CD635698F12A9E78F427ECC3704754EF5EB1BE34FD426715F9E50FAEE0C
6A6AB6C210|03EE1F8AB5D1C042BDB557136BBC3A156F9E5CB8016D7430096D812776F582E5
AF3175E160|EAAD56FC7018F2A246521A5C7E438B1D5A710BAFD765EF2358B3114E11342E75
B66609ED86|EE76FE6703AB8FFBA76F5F65A97AA75F61C3B26CF7D57E50AD4088062AADD9AC
21F134AC57|E1EA4F9725B51B7943A2598EA5D3D16CAC1825E5C1DFF5737E740F6A9983C2B5
3DC2AADFFC80|12778C4478542734793714EC4099DF875F956C5AD952D0DEC09BEE534F0DE051
9202736D2240|C0BCB8E589272D27AEF0D251B19865DBBA61A6FEE3785198B3D8F514E36F1D01
F219BD629820|3CE099F5F65AC7EEBD4B1E3A775B87B0E30DBE55BBE539D4377B701BE9F20C3E
F3511EE2C4B0|F12550AEDD59E81132B0C031033C8AE1683442D149891CBEF1FBED469C3D6933
3ECAB6BF7720|7505AFED2ECD5F164BA159DE5F9165EC58E12B3A4A4CFDF0C6DAA570968FB110
CD62F688F498|69C0399A946CAE2B02DA236B4393BCFC122BD39234B0D9CC31737DB3F797FE1C
C2CBAA33A9F8|55B3A30021B97065E937AAEA9081D513C3023F46F53F017B31E16D79E337ACA6
C6F50BB74E29|29A908593BAC196817F17C0AC66D5CA523F4FECA895B08B805DDBFAC6B7F5F76
79F1B4CCC62A00|56DBBF181B150C7BC9CDD5DE52F6874271BE46C01DD6C4F7DD43C76276FD5A84
