# Generated by default/object.tt
package Paws::AccessAnalyzer::IamRoleConfiguration;
  use Moose;
  has TrustPolicy => (is => 'ro', isa => 'Str', request_name => 'trustPolicy', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::IamRoleConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::IamRoleConfiguration object:

  $service_obj->Method(Att1 => { TrustPolicy => $value, ..., TrustPolicy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::IamRoleConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->TrustPolicy

=head1 DESCRIPTION

The proposed access control configuration for an IAM role. You can
propose a configuration for a new IAM role or an existing IAM role that
you own by specifying the trust policy. If the configuration is for a
new IAM role, you must specify the trust policy. If the configuration
is for an existing IAM role that you own and you do not propose the
trust policy, the access preview uses the existing trust policy for the
role. The proposed trust policy cannot be an empty string. For more
information about role trust policy limits, see IAM and STS quotas
(https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html).

=head1 ATTRIBUTES


=head2 TrustPolicy => Str

The proposed trust policy for the IAM role.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

