# Generated by default/object.tt
package Paws::AmplifyBackend::BackendAuthSocialProviderConfig;
  use Moose;
  has ClientId => (is => 'ro', isa => 'Str', request_name => 'client_id', traits => ['NameInRequest']);
  has ClientSecret => (is => 'ro', isa => 'Str', request_name => 'client_secret', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AmplifyBackend::BackendAuthSocialProviderConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AmplifyBackend::BackendAuthSocialProviderConfig object:

  $service_obj->Method(Att1 => { ClientId => $value, ..., ClientSecret => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AmplifyBackend::BackendAuthSocialProviderConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->ClientId

=head1 DESCRIPTION

Describes third-party social federation configurations for allowing
your app users to sign in using OAuth.

=head1 ATTRIBUTES


=head2 ClientId => Str

Describes the client_id which can be obtained from the third-party
social federation provider.


=head2 ClientSecret => Str

Describes the client_secret which can be obtained from third-party
social federation providers.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AmplifyBackend>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

