# Generated by default/object.tt
package Paws::AppMesh::VirtualGatewayListenerTlsCertificate;
  use Moose;
  has Acm => (is => 'ro', isa => 'Paws::AppMesh::VirtualGatewayListenerTlsAcmCertificate', request_name => 'acm', traits => ['NameInRequest']);
  has File => (is => 'ro', isa => 'Paws::AppMesh::VirtualGatewayListenerTlsFileCertificate', request_name => 'file', traits => ['NameInRequest']);
  has Sds => (is => 'ro', isa => 'Paws::AppMesh::VirtualGatewayListenerTlsSdsCertificate', request_name => 'sds', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppMesh::VirtualGatewayListenerTlsCertificate

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppMesh::VirtualGatewayListenerTlsCertificate object:

  $service_obj->Method(Att1 => { Acm => $value, ..., Sds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppMesh::VirtualGatewayListenerTlsCertificate object:

  $result = $service_obj->Method(...);
  $result->Att1->Acm

=head1 DESCRIPTION

An object that represents a listener's Transport Layer Security (TLS)
certificate.

=head1 ATTRIBUTES


=head2 Acm => L<Paws::AppMesh::VirtualGatewayListenerTlsAcmCertificate>

A reference to an object that represents an Certificate Manager
certificate.


=head2 File => L<Paws::AppMesh::VirtualGatewayListenerTlsFileCertificate>

A reference to an object that represents a local file certificate.


=head2 Sds => L<Paws::AppMesh::VirtualGatewayListenerTlsSdsCertificate>

A reference to an object that represents a virtual gateway's listener's
Secret Discovery Service certificate.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppMesh>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

