# Generated by default/object.tt
package Paws::AppRunner::AutoScalingConfigurationSummary;
  use Moose;
  has AutoScalingConfigurationArn => (is => 'ro', isa => 'Str');
  has AutoScalingConfigurationName => (is => 'ro', isa => 'Str');
  has AutoScalingConfigurationRevision => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppRunner::AutoScalingConfigurationSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppRunner::AutoScalingConfigurationSummary object:

  $service_obj->Method(Att1 => { AutoScalingConfigurationArn => $value, ..., AutoScalingConfigurationRevision => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppRunner::AutoScalingConfigurationSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->AutoScalingConfigurationArn

=head1 DESCRIPTION

Provides summary information about an AWS App Runner automatic scaling
configuration resource.

This type contains limited information about an auto scaling
configuration. It includes only identification information, without
configuration details. It's returned by the
ListAutoScalingConfigurations action. Complete configuration
information is returned by the CreateAutoScalingConfiguration,
DescribeAutoScalingConfiguration, and DeleteAutoScalingConfiguration
actions using the AutoScalingConfiguration type.

=head1 ATTRIBUTES


=head2 AutoScalingConfigurationArn => Str

The Amazon Resource Name (ARN) of this auto scaling configuration.


=head2 AutoScalingConfigurationName => Str

The customer-provided auto scaling configuration name. It can be used
in multiple revisions of a configuration.


=head2 AutoScalingConfigurationRevision => Int

The revision of this auto scaling configuration. It's unique among all
the active configurations (C<"Status": "ACTIVE">) with the same
C<AutoScalingConfigurationName>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppRunner>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

