# Generated by default/object.tt
package Paws::AuditManager::Control;
  use Moose;
  has ActionPlanInstructions => (is => 'ro', isa => 'Str', request_name => 'actionPlanInstructions', traits => ['NameInRequest']);
  has ActionPlanTitle => (is => 'ro', isa => 'Str', request_name => 'actionPlanTitle', traits => ['NameInRequest']);
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has ControlMappingSources => (is => 'ro', isa => 'ArrayRef[Paws::AuditManager::ControlMappingSource]', request_name => 'controlMappingSources', traits => ['NameInRequest']);
  has ControlSources => (is => 'ro', isa => 'Str', request_name => 'controlSources', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has CreatedBy => (is => 'ro', isa => 'Str', request_name => 'createdBy', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has LastUpdatedAt => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedAt', traits => ['NameInRequest']);
  has LastUpdatedBy => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedBy', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'Paws::AuditManager::TagMap', request_name => 'tags', traits => ['NameInRequest']);
  has TestingInformation => (is => 'ro', isa => 'Str', request_name => 'testingInformation', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::Control

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::Control object:

  $service_obj->Method(Att1 => { ActionPlanInstructions => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::Control object:

  $result = $service_obj->Method(...);
  $result->Att1->ActionPlanInstructions

=head1 DESCRIPTION

A control in AWS Audit Manager.

=head1 ATTRIBUTES


=head2 ActionPlanInstructions => Str

The recommended actions to carry out if the control is not fulfilled.


=head2 ActionPlanTitle => Str

The title of the action plan for remediating the control.


=head2 Arn => Str

The Amazon Resource Name (ARN) of the specified control.


=head2 ControlMappingSources => ArrayRef[L<Paws::AuditManager::ControlMappingSource>]

The data mapping sources for the specified control.


=head2 ControlSources => Str

The data source that determines from where AWS Audit Manager collects
evidence for the control.


=head2 CreatedAt => Str

Specifies when the control was created.


=head2 CreatedBy => Str

The IAM user or role that created the control.


=head2 Description => Str

The description of the specified control.


=head2 Id => Str

The unique identifier for the control.


=head2 LastUpdatedAt => Str

Specifies when the control was most recently updated.


=head2 LastUpdatedBy => Str

The IAM user or role that most recently updated the control.


=head2 Name => Str

The name of the specified control.


=head2 Tags => L<Paws::AuditManager::TagMap>

The tags associated with the control.


=head2 TestingInformation => Str

The steps to follow to determine if the control has been satisfied.


=head2 Type => Str

The type of control, such as custom or standard.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

