# Generated by default/object.tt
package Paws::AuditManager::SourceKeyword;
  use Moose;
  has KeywordInputType => (is => 'ro', isa => 'Str', request_name => 'keywordInputType', traits => ['NameInRequest']);
  has KeywordValue => (is => 'ro', isa => 'Str', request_name => 'keywordValue', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::SourceKeyword

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::SourceKeyword object:

  $service_obj->Method(Att1 => { KeywordInputType => $value, ..., KeywordValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::SourceKeyword object:

  $result = $service_obj->Method(...);
  $result->Att1->KeywordInputType

=head1 DESCRIPTION

The keyword to search for in AWS CloudTrail logs, AWS Config rules, AWS
Security Hub checks, and AWS API names.

=head1 ATTRIBUTES


=head2 KeywordInputType => Str

The method of input for the specified keyword.


=head2 KeywordValue => Str

The value of the keyword used to search AWS CloudTrail logs, AWS Config
rules, AWS Security Hub checks, and AWS API names when mapping a
control data source.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

