# Generated by default/object.tt
package Paws::Chime::Participant;
  use Moose;
  has PhoneNumber => (is => 'ro', isa => 'Str');
  has ProxyPhoneNumber => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Chime::Participant

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Chime::Participant object:

  $service_obj->Method(Att1 => { PhoneNumber => $value, ..., ProxyPhoneNumber => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Chime::Participant object:

  $result = $service_obj->Method(...);
  $result->Att1->PhoneNumber

=head1 DESCRIPTION

The phone number and proxy phone number for a participant in an Amazon
Chime Voice Connector proxy session.

=head1 ATTRIBUTES


=head2 PhoneNumber => Str

The participant's phone number.


=head2 ProxyPhoneNumber => Str

The participant's proxy phone number.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Chime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

